/*
 * 쐬: 2007/07/09
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbTreeFrame;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.FavoriteTree;


/** EnterƂ̏. */
public class EnterAction extends AbstractAction {
	public void actionPerformed(ActionEvent e) {
		System.out.println("EnterAction "+e);
		AsanDatabaseBrowser tools = AsanDatabaseBrowser.theApp;
		DbTreeFrame frame = tools.getTreeFrame();
		System.out.println(frame.getContentPane());
		JTabbedPane tab = frame.tab;
		if (tab.getSelectedIndex() == 0) {	// Database^O
	    	// e[uIĂȂÃe[uJB
	    	DbTreeView tree = tools.getTreeFrame().getTree();
			TableInfo table = tree.getSelectedTableInfo();
			if (table != null) {
				KeyEvent ke = new KeyEvent(frame, KeyEvent.KEY_TYPED, e.getWhen(),
							e.getModifiers(), KeyEvent.VK_UNDEFINED, '\n');
				SwingUtilities.notifyAction(frame.openTableAction, 
						KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
						ke, this, 0); 
			}
			VvDatabase db = tree.getSelectedDatabase(false);
	    	if (db != null) {
				KeyEvent ke = new KeyEvent(frame, KeyEvent.KEY_TYPED, e.getWhen(),
						e.getModifiers(), KeyEvent.VK_UNDEFINED, '\n');
				SwingUtilities.notifyAction(frame.databaseConnectAction, 
					KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
					ke, this, 0); 
	    	}
		} else {	// Cɓ^O
			FavoriteTree favtree = tools.getTreeFrame().getFavTree();
			DefaultMutableTreeNode node = (DefaultMutableTreeNode) favtree.getSelectionPath().getLastPathComponent();
			Object obj = node.getUserObject();
			if (obj instanceof FavoriteTable) {
//				FavoriteTable fav = (FavoriteTable) obj;
				KeyEvent ke = new KeyEvent(frame, KeyEvent.KEY_TYPED, e.getWhen(),
						e.getModifiers(), KeyEvent.VK_UNDEFINED, '\n');
				SwingUtilities.notifyAction(frame.openTableAction, 
					KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
					ke, this, 0); 
			}
		}
	}
}
