package asandatabasebrowser.action;

import java.awt.Cursor;
import java.awt.event.*;
import javax.swing.*;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbExecuteFrame;
import asandatabasebrowser.view.DbTableFrame2;


/**
 * w肳ꂽSQLsB
 * R~bgA[obNŎgpB
 * @author Yoshinori_Watanabe
 *
 */
public class ExecuteCommitAction extends AbstractAction {
	DbTableFrame2 frame2;
	DbExecuteFrame frame1;
	final VvDatabase db;
    String sql;
    public ExecuteCommitAction(DbExecuteFrame frame, VvDatabase db, String sql, Icon icon) {
        super(sql);
        if (icon != null) putValue(SMALL_ICON, icon);
        putValue(SHORT_DESCRIPTION, sql+" s܂");
        putValue(LONG_DESCRIPTION, sql+" s܂");
        this.frame1 = frame;
        this.db = db;
        this.sql = sql;
    }
    public ExecuteCommitAction(DbTableFrame2 frame2, VvDatabase db, String sql, Icon icon) {
        super(sql);
        if (icon != null) putValue(SMALL_ICON, icon);
        putValue(SHORT_DESCRIPTION, sql+" s܂");
        putValue(LONG_DESCRIPTION, sql+" s܂");
        this.frame2 = frame2;
        this.db = db;
        this.sql = sql;
    }
    public void actionPerformed(ActionEvent ev) {
        //System.out.println("ExecuteUpdateAction");
        //frame.executeUpdate(sql);
    	JFrame frame = frame1 != null ? (JFrame)frame1: (JFrame)frame2;
        frame.setCursor(new Cursor(Cursor.WAIT_CURSOR));
        try {
        	if (sql.equals("commit"))
        		db.commit();
        	else
        		db.rollback();
           	AsanDatabaseBrowser.theApp.showMessage(frame, sql+" ܂", null, SxOptionPane.INFORMATION_MESSAGE);
        } catch (Exception e) {
            AsanDatabaseBrowser.theApp.showMessage(frame, "G[܂", e, SxOptionPane.ERROR_MESSAGE);
        }
        if (frame2 != null) frame2.updateActionState();
        frame.setCursor(Cursor.getDefaultCursor());    	
    }
}

