package asandatabasebrowser.action;

import java.awt.Cursor;
import java.awt.event.*;
import javax.swing.*;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.view.DbSqlFrame;
import asandatabasebrowser.view.DbTableFrame;
import asandatabasebrowser.view.DbTableFrame2;



public class ExecuteQueryAction extends AbstractAction {
	DbSqlFrame sqlFrame;
	DbTableFrame tableFrame;
	DbTableFrame2 tableFrame2;
	/** @deprecated ÂAPIł */
	public ExecuteQueryAction(DbTableFrame frame) {
		super("Query");
		putValue(SHORT_DESCRIPTION, "Č");
		putValue(LONG_DESCRIPTION, "Č");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/Update.png"));
		this.tableFrame = frame;
	}
	public ExecuteQueryAction(DbTableFrame2 frame2) {
		super("Query");
		putValue(SHORT_DESCRIPTION, "Č");
		putValue(LONG_DESCRIPTION, "Č");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/Update.png"));
		this.tableFrame2 = frame2;
	}
	public ExecuteQueryAction(DbSqlFrame frame) {
		super("Query");
		putValue(SHORT_DESCRIPTION, "SQLs܂");
		putValue(LONG_DESCRIPTION, "SQLs܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/Update.png"));
		this.sqlFrame = frame;
	}

	public void actionPerformed(ActionEvent ev) {
		//System.out.println("QueryAction");
		if (tableFrame != null) {
			tableFrame.setCursor(new Cursor(Cursor.WAIT_CURSOR));
			try {
				String sql = tableFrame.getSql();
				DbData data = tableFrame.tableInfo.db.queryTable(tableFrame.tableInfo, sql, true);
				tableFrame.setData(data);
			} catch (Exception e) {
				AsanDatabaseBrowser.theApp.showMessage(tableFrame, "G[܂", e, SxOptionPane.ERROR_MESSAGE);
			}
			tableFrame.setCursor(Cursor.getDefaultCursor());
		} else if (tableFrame2 != null) {
			tableFrame2.setCursor(new Cursor(Cursor.WAIT_CURSOR));
			try {
				String sql = tableFrame2.getSql();
				DbData data = tableFrame2.tableInfo.db.queryTable(tableFrame2.tableInfo, sql, true);
				tableFrame2.setData(data);
			} catch (Exception e) {
				AsanDatabaseBrowser.theApp.showMessage(tableFrame2, "G[܂", e, SxOptionPane.ERROR_MESSAGE);
			}
			tableFrame2.updateActionState();
			tableFrame2.setCursor(Cursor.getDefaultCursor());
		} else {
			sqlFrame.setCursor(new Cursor(Cursor.WAIT_CURSOR));
			try {
				String sql = sqlFrame.getCurrentSql();
				DbData data = sqlFrame.db.getRecordList(sql);
				sqlFrame.updateData(data);

			} catch (Exception e) {
				//JOptionPane.showMessageDialog(this, "G[܂ "+e);
				AsanDatabaseBrowser.theApp.showMessage(sqlFrame, "G[܂", e, SxOptionPane.ERROR_MESSAGE);
			}
			sqlFrame.setCursor(Cursor.getDefaultCursor());
		}
	}
	/** SQLsA\ύX܂B */
	public void executeQuery() {
	}


}

