/*
 * 쐬: 2007/11/04
 */
package asandatabasebrowser.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Vector;

import javax.swing.*;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteSQL;
import asandatabasebrowser.view.DbSqlFrame;

import net.sourceforge.swingx.SxOptionPane;


public class FavoriteSqlAction extends AbstractAction {
	DbSqlFrame frame;
	public FavoriteSqlAction(DbSqlFrame frame) {
		super("Cɓɕۑ܂");
		putValue(SHORT_DESCRIPTION, "SQLCɓɕۑAɗpł悤ɂ܂");
		putValue(LONG_DESCRIPTION, "Cɓɕۑ܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/Favorite.png"));
		this.frame = frame;
	}
	public void actionPerformed(ActionEvent event) {
		AsanDatabaseBrowser theApp = AsanDatabaseBrowser.theApp;
		if (theApp.doc.favList.size() < 1) {
			theApp.showMessage(frame,
					"CɓɃO[v܂B܂͂Cɓ^uŃO[v쐬Ă",
					null, SxOptionPane.WARNING_MESSAGE);
			return;
		}
		// o^
		JPanel namePanel = new JPanel(new BorderLayout(10, 10));
		namePanel.add(new JLabel("O:"), BorderLayout.WEST);
		JTextField nameField = new JTextField("VKSQLZbg", 20);
		nameField.setToolTipText("Cӂ̖OtĂB");
		namePanel.add(nameField, BorderLayout.CENTER);
		
		// Cɓ̃Xg
		JList list = new JList(new Vector(theApp.doc.favList));
		list.setCellRenderer(new DefaultListCellRenderer() {
			public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
				JLabel label = (JLabel) super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
				FavoriteGroup g = (FavoriteGroup) value;
				label.setText(g.name);
				label.setIcon(Global.groupIcon);
				return label;
			}
		});
		JPanel panel = new JPanel(new BorderLayout(10, 10));
		panel.add(namePanel, BorderLayout.NORTH);
		panel.add(new JScrollPane(list), BorderLayout.CENTER);
		// bZ[W_CAO\
		int ret = SxOptionPane.showMessageDialog(frame, 
				panel, "Cɓɕۑ", 
				SxOptionPane.OK_CANCEL_OPTION, 
				SxOptionPane.PLAIN_MESSAGE, null);
		if (ret != SxOptionPane.OK) return;
		if (list.getSelectedIndex() == -1) return;
		// IꂽOŁAO[vɒǉ
		String name = nameField.getText();
		ArrayList sqlList = new ArrayList();
		for (int i=0; i<frame.textarea.getTabCount(); i++) {
			sqlList.add(frame.textarea.getText(i));
		}
		FavoriteGroup g = (FavoriteGroup) list.getSelectedValue();
		g.add(new FavoriteSQL(frame.db.name, name, sqlList));
		// XVtOZbgBr[ɔfB
		theApp.doc.setModified(true);
		theApp.getTreeFrame().favTree.buildTree();
    	theApp.getTreeFrame().updateMainFrame();
	}
}
