/*
 * 쐬: 2007/07/24
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.FavoriteGroup;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.model.VvDocument;
import asandatabasebrowser.view.DbTreeFrame;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.FavoriteTree;

import net.sourceforge.swingx.SxAction;


public class NodeUpAction extends SxAction {
	public NodeUpAction() {
		super("m[h", Global.arrowUpIcon);
		putValue(SHORT_DESCRIPTION, "m[h");
		putValue(LONG_DESCRIPTION, "m[h");
	}
	public void actionPerformed(ActionEvent e) {
		DbTreeFrame frame = AsanDatabaseBrowser.theApp.getTreeFrame();
		VvDocument doc = AsanDatabaseBrowser.theApp.doc;
		if (frame.tab.getSelectedIndex() == 0) {
			// c[̃r[ύXB
			DbTreeView tree = frame.getTree();
			DefaultTreeModel model = (DefaultTreeModel) tree.getModel();
			TreePath selPath = tree.getSelectionPath();
			if (selPath == null) return;
			DefaultMutableTreeNode child = (DefaultMutableTreeNode) selPath.getLastPathComponent();
			DefaultMutableTreeNode parent =	(DefaultMutableTreeNode) child.getParent();
			if (! (child.getUserObject() instanceof VvDatabase)) return;
			int index = model.getIndexOfChild(parent, child);
			if (index == 0) return;	// łɈԏ
			model.removeNodeFromParent(child);
		    model.insertNodeInto(child, parent, index-1);
		    tree.addSelectionRow(tree.getRow(child));
		    // f[^ύXB
	    	VvDatabase db = (VvDatabase) child.getUserObject();
	    	ArrayList dblist = doc.databaseList;
	    	dblist.remove(db);
	    	dblist.add(index-1, db);
		    doc.setModified(true);
		    frame.updateMainFrame();
		} else {
			// Cɓ̃r[ύXB
			FavoriteTree tree = frame.getFavTree(); 
			DefaultTreeModel model = (DefaultTreeModel) tree.getModel();
			TreePath selPath = tree.getSelectionPath();
			if (selPath == null) return;
			DefaultMutableTreeNode child = (DefaultMutableTreeNode) selPath.getLastPathComponent();
			DefaultMutableTreeNode parent =	(DefaultMutableTreeNode) child.getParent();
			int index = model.getIndexOfChild(parent, child);
			if (index == 0) return;	// łɈԏ
			model.removeNodeFromParent(child);
		    model.insertNodeInto(child, parent, index-1);
		    tree.addSelectionRow(tree.getRow(child));
		    // f[^ύXB
		    if (child.getUserObject() instanceof FavoriteGroup) {
		    	FavoriteGroup g = (FavoriteGroup) child.getUserObject();
		    	ArrayList favList = doc.favList;
		    	favList.remove(g);
		    	favList.add(index-1, g);
		    } else if (child.getUserObject() instanceof FavoriteTable) {
		    	FavoriteGroup g = (FavoriteGroup) parent.getUserObject();
		    	FavoriteTable t = (FavoriteTable) child.getUserObject();
		    	g.list.remove(t);
		    	g.list.add(index-1, t);
		    }
		    doc.setModified(true);
		    frame.updateMainFrame();
		}
	}
	public void updateStatus() {
		DbTreeFrame frame = AsanDatabaseBrowser.theApp.getTreeFrame();
		if (frame.tab.getSelectedIndex() == 0) {
			// c[̃r[ύXB
			DbTreeView tree = frame.getTree();
			DefaultTreeModel model = (DefaultTreeModel) tree.getModel();
			TreePath selPath = tree.getSelectionPath();
			if (selPath == null) {
				setEnabled(false);
				return;
			}
			DefaultMutableTreeNode child = (DefaultMutableTreeNode) selPath.getLastPathComponent();
			DefaultMutableTreeNode parent =	(DefaultMutableTreeNode) child.getParent();
			if (! (child.getUserObject() instanceof VvDatabase)) {
				setEnabled(false);
				return;
			}
			int index = model.getIndexOfChild(parent, child);
			if (index == 0) {
				setEnabled(false);
				return;	// łɈԏ
			}
			setEnabled(true);
		} else {
			// Cɓ̃r[ύXB
			FavoriteTree tree = frame.getFavTree(); 
			DefaultTreeModel model = (DefaultTreeModel) tree.getModel();
			TreePath selPath = tree.getSelectionPath();
			if (selPath == null) {
				setEnabled(false);
				return;
			}
			DefaultMutableTreeNode node = (DefaultMutableTreeNode) selPath.getLastPathComponent();
			DefaultMutableTreeNode parent =	(DefaultMutableTreeNode) node.getParent();
			if (parent == null) {
				setEnabled(false);
				return;
			}
			int index = model.getIndexOfChild(parent, node);
			if (index == 0) {
				setEnabled(false);
				return;	// łɈԏ
			}
			setEnabled(true);
		}
	}
	
}
