package asandatabasebrowser.action;

import java.awt.event.*;
import javax.swing.*;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.FavoriteTable;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbTreeView;



public class OpenExecuteFrameAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	DbTreeView tree;
	public OpenExecuteFrameAction(AsanDatabaseBrowser tools, DbTreeView tree) {
		super("sEBhE");
		putValue(SHORT_DESCRIPTION, "sEBhEJ܂");
		putValue(LONG_DESCRIPTION, "sEBhEJ܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/UpdateView.png"));
		this.tools = tools;
		this.tree = tree;
	}

	public void actionPerformed(ActionEvent ev) {
    	// IĂc[擾
    	VvDatabase db = null;
		int index = tools.getTreeFrame().tab.getSelectedIndex();
		if (index == 0) {
	    	db = tools.getTreeFrame().getTree().getSelectedDatabase(true);
			if (db == null) return;
		} else {
			// Iꂽe[u擾BDBɐڑĂ邱ƁB
			Object obj = tools.getTreeFrame().getFavTree().getSelectionNodeObject();
			if (obj instanceof FavoriteTable) {
				FavoriteTable favtable = (FavoriteTable) obj;
				db = tools.doc.getDatabaseFromFavorite(favtable);
				if (db == null) {
					tools.showMessage(tools.getTreeFrame(),
							"w肳ꂽf[^x[X܂B:"+favtable.dbName, null, 
							SxOptionPane.ERROR_MESSAGE);
					return;
				}
				if (db.getConnection() == null) {
					tools.showMessage(tools.getTreeFrame(),
							"f[^x[XɐڑĂ܂B:"+favtable.dbName, null, 
							SxOptionPane.ERROR_MESSAGE);
					return;
				}
			}
		}

		// t[J
		tools.openExecuteFrame(db);
	}
}

