package asandatabasebrowser.action;

import java.awt.event.*;
import javax.swing.*;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.*;



public class OpenSqlFrameAction extends AbstractAction {
	final AsanDatabaseBrowser tools;

	public OpenSqlFrameAction(AsanDatabaseBrowser tools) {
		super("SQLEBhE");
		putValue(SHORT_DESCRIPTION, "SQLEBhEJ܂");
		putValue(LONG_DESCRIPTION, "SQLEBhEJ܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/SQLView.png"));
		this.tools = tools;
	}

	public void actionPerformed(ActionEvent ev) {
		TableInfo tableInfo = null;
		int index = tools.getTreeFrame().tab.getSelectedIndex();
		if (index == 0) {
			tableInfo = tools.getTreeFrame().getTree().getSelectedTableInfo();
		} else {
			// Iꂽe[u擾BDBɐڑĂ邱ƁB
			Object obj = tools.getTreeFrame().getFavTree().getSelectionNodeObject();
			if (obj instanceof FavoriteTable) {
				FavoriteTable favtable = (FavoriteTable) obj;
				VvDatabase db = tools.doc.getDatabaseFromFavorite(favtable);
				if (db == null) {
					tools.showMessage(tools.getTreeFrame(),
							"w肳ꂽf[^x[X܂B:"+favtable.dbName, null, 
							SxOptionPane.ERROR_MESSAGE);
					return;
				}
				if (db.getConnection() == null) {
					tools.showMessage(tools.getTreeFrame(),
							"f[^x[XɐڑĂ܂B:"+favtable.dbName, null, 
							SxOptionPane.ERROR_MESSAGE);
					return;
				}
				tableInfo = tools.doc.getTableInfoFromFavorite(favtable);
			}
		}
		if (tableInfo == null) return;
		try {
			String sql = "select * from "+tableInfo.getSqlTableName();
			tools.openSqlFrame(tableInfo.db, sql);
		} catch (DbException e) {
			tools.showMessage(tools.getTreeFrame(), 
					"e[uJƂł܂", e, SxOptionPane.ERROR_MESSAGE);
		}
	}
}

