package asandatabasebrowser.action;

import java.awt.event.*;
import javax.swing.*;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.*;
import asandatabasebrowser.view.DbTreeView;
import asandatabasebrowser.view.FavoriteTree;


public class OpenTableAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	public OpenTableAction(AsanDatabaseBrowser tools) {
		super("e[uJ");
		putValue(SHORT_DESCRIPTION, "e[uJ܂");
		putValue(LONG_DESCRIPTION, "e[uJ܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/TableView.png"));
		this.tools = tools;
	}

	public void actionPerformed(ActionEvent ev) {
		//System.out.println("OpenTableAction");
		if (tools.getTreeFrame().tab.getSelectedIndex() == 0) {
			DbTreeView tree = tools.getTreeFrame().getTree();
			TableInfo info = tree.getSelectedTableInfo();
			if (info == null) return;
			try {
				tools.openTableFrame(info);
			} catch (Exception e) {
				tools.showMessage(tree, "e[uJƂł܂:"+info,
						e, SxOptionPane.ERROR_MESSAGE);
			}
		} else {
			FavoriteTree tree = tools.getTreeFrame().getFavTree();
			Object obj = tree.getSelectionNodeObject();
			try {
				if (obj instanceof FavoriteTable) {
                    // Ye[u擾B
                    tools.openTableFrame((FavoriteTable) obj);
				}
			} catch (Exception e) {
				tools.showMessage(tree, "e[uJƂł܂:"+obj,
						e, SxOptionPane.ERROR_MESSAGE);
			}
		}
		tools.getTreeFrame().updateMainFrame();
	}
}

