/*
 * 쐬: 2007/12/22
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import net.sourceforge.swingx.jspread.JSpread;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.EditingRecord;
import asandatabasebrowser.view.DbTableFrame2;


public class RecordDeleteAction extends AbstractAction {
	DbTableFrame2 frame;
	public RecordDeleteAction(DbTableFrame2 frame) {
		super("RecordDelete");
		assert frame != null;
		this.frame = frame;
		putValue(SHORT_DESCRIPTION, "IꂽR[h폜܂");
		putValue(LONG_DESCRIPTION, "IꂽR[h폜܂");
		putValue(SMALL_ICON, Global.recordDeleteIcon);
	}
	public void actionPerformed(ActionEvent ev) {
		AsanDatabaseBrowser tools = AsanDatabaseBrowser.theApp;
		DbData data = frame.tableView.data;
		boolean[] sels = frame.tableView.getSheet().getSelectionArray(JSpread.ROW);
		// IĂ邩H
		boolean exist = false;
		for (int i=0; i<sels.length; i++) {
			if (sels[i]) {
				exist = true;
				break;
			}
		}
		if (! exist) {
			tools.showMessage(frame, 
					"R[hIĂ܂B", 
					null, JOptionPane.ERROR_MESSAGE);
			return;
		}
		// ҏW̃R[h邩H
		for (int i=0; i<sels.length; i++) {
			if (sels[i] && data.getMode(i) != DbData.NONE) {
				tools.showMessage(frame, 
						"łɕҏW̃R[h܂B", 
						null, JOptionPane.ERROR_MESSAGE);
				return;
			}
		}
		// ҏWԂɂ
		for (int i=0; i<sels.length; i++) {
			if (sels[i]) {
				data.setRecord(i, new EditingRecord(DbData.DELETE, data.getRecord(i)));
			}
		}
		
//		int[] rows = frame.tableView.getSelectedRecordIndex();
//		if (rows.length == 0) {
//			tools.showMessage(frame, 
//					"R[hIĂ܂B", 
//					null, JOptionPane.ERROR_MESSAGE);
//			return;
//		}
//		// `FbN
//		for (int i=0; i<rows.length; i++) {
//			if (data.getMode(rows[i]) != DbData.NONE) {
//				tools.showMessage(frame, 
//						"łɕҏW̃R[h܂B", 
//						null, JOptionPane.ERROR_MESSAGE);
//				return;
//			}
//		}
//		// ҏWԂɂ
//		for (int i=0; i<rows.length; i++) {
//			data.setRecord(rows[i], new EditingRecord(DbData.DELETE, data.getRecord(rows[i])));
//			//view.setHeaderValueAt(getValue(SMALL_ICON), JSpread.ROW, rows[i]);
//		}
		frame.setData(data);
		frame.updateActionState();
	}
}
