/*
 * 쐬: 2007/12/25
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import net.sourceforge.swingx.SxTextUtilities;
import net.sourceforge.swingx.jspread.JSpread;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.view.DbTableFrame2;

/**
 * R[hҏWȌԂɖ߂܂B
 * 
 * @author Asan
 */
public class RecordEditCancelAction extends AbstractAction {
	DbTableFrame2 frame;

	public RecordEditCancelAction(DbTableFrame2 frame) {
		super("RecordUndo");
		assert frame != null;
		this.frame = frame;
		putValue(SHORT_DESCRIPTION, "IꂽR[hҏWȌԂɖ߂܂");
		putValue(LONG_DESCRIPTION, "IꂽR[hҏWȌԂɖ߂܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/EditUndo.png"));
	}

	public void actionPerformed(ActionEvent ev) {
		// TableInfo info = (TableInfo) view.data.tableInfo;
		AsanDatabaseBrowser tools = AsanDatabaseBrowser.theApp;
		DbData data = frame.tableView.data;
		boolean[] sels = frame.tableView.getSheet().getSelectionArray(JSpread.ROW);
		// PłIĂ邩H
		if (SxTextUtilities.search(sels, true) == -1) {
			tools.showMessage(frame, "R[hIĂ܂B", null,
					JOptionPane.ERROR_MESSAGE);
			return;
		}
		// IĂ郌R[h̒ɕҏW̃R[h邩H
		boolean found = false;
		for (int i = 0; i < sels.length; i++) {
			if (sels[i] && data.getMode(i) != DbData.NONE) {
				found = true;
				break;
			}
		}
		if (!found) {
			tools.showMessage(frame, "ҏW̃R[h͑IĂ܂B", null,
					JOptionPane.ERROR_MESSAGE);
			return;
		}
		// ҏWLZB}ꂽR[h͍폜ďԂ̂ŉ猳ɖ߂ĂB
		for (int i = sels.length - 1; i >= 0; i--) {
			if (sels[i] && data.getMode(i) != DbData.NONE) {
				data.editCancel(i);
			}
		}

		// int[] rows = frame.tableView.getSelectedRecordIndex();
		// if (rows.length == 0) {
		// tools.showMessage(frame,
		// "R[hIĂ܂B",
		// null, JOptionPane.ERROR_MESSAGE);
		// return;
		// }
		// // `FbN
		// boolean found = false;
		// for (int i=0; i<rows.length; i++) {
		// if (data.getMode(rows[i]) != DbData.NONE) {
		// found = true;
		// break;
		// }
		// }
		// if (! found) {
		// tools.showMessage(frame,
		// "ҏW̃R[h͑IĂ܂B",
		// null, JOptionPane.ERROR_MESSAGE);
		// return;
		// }
		// // ҏWLZB}ꂽR[h͍폜ďԂ̂ŉ猳ɖ߂ĂB
		// for (int i=rows.length-1; i>=0; i--) {
		// if (data.getMode(rows[i]) != DbData.NONE) {
		// data.editCancel(rows[i]);
		// }
		// }
		frame.setData(data);
		frame.updateActionState();
	}
}
