/*
 * 쐬: 2007/12/19
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.Action;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.view.DbTableFrame2;


public class RecordExecuteAction extends AbstractAction {
	DbTableFrame2 frame;
	public RecordExecuteAction(DbTableFrame2 frame) {
		super("s");
		assert frame != null;
		this.frame = frame;
		putValue(SHORT_DESCRIPTION, "ҏWꂽR[h}/XV/폜܂");
		putValue(LONG_DESCRIPTION, "ҏWꂽR[h}/XV/폜܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/Run.png"));
	}
	public void actionPerformed(ActionEvent ev) {
		AsanDatabaseBrowser tools = AsanDatabaseBrowser.theApp;
		DbData data = frame.tableView.data;
		VvDatabase db = data.tableInfo.getDatabase();
		String sql = null;
		try {
			// `FbN
			for (int i=0; i<data.getRecordCount(); i++) {
				switch (data.getMode(i)) {
				case DbData.INSERT:
				case DbData.UPDATE:
				case DbData.DELETE:
					sql = data.createSql(i);
					if (sql != null) {
						System.out.println(sql);
						db.executeUpdate(sql);
					}
					break;
				case DbData.NONE:
					break;
				default:
					assert false: data.getMode(i);
				}
			}
			// ČBłrollback͂ȂB
			sql = frame.getSql();
			data = frame.tableInfo.db.queryTable(frame.tableInfo, sql, false);
			frame.setData(data);
			frame.updateActionState();
		} catch (DbException ex) {
			tools.showMessage(frame, 
					"f[^x[X̑}/XV/폜Ɏs܂B",
					ex, SxOptionPane.ERROR_MESSAGE);
		}
	}
}
