/*
 * 쐬: 2007/12/22
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import net.sourceforge.swingx.SxTextUtilities;
import net.sourceforge.swingx.jspread.JSpread;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.EditingRecord;
import asandatabasebrowser.view.DbTableFrame2;


public class RecordInsertSelectAction extends AbstractAction {
	DbTableFrame2 frame;
	public RecordInsertSelectAction(DbTableFrame2 frame) {
		super("RecordInsertSelect");
		assert frame != null;
		this.frame = frame;
		putValue(SHORT_DESCRIPTION, "IꂽR[hlƂVR[h쐬܂");
		putValue(LONG_DESCRIPTION, "IꂽR[hlƂVR[h쐬܂");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/RecordInsertSelect.png"));
	}
	public void actionPerformed(ActionEvent ev) {
//		TableInfo info = (TableInfo) view.data.tableInfo;
		AsanDatabaseBrowser tools = AsanDatabaseBrowser.theApp;
		DbData data = frame.tableView.data;
		boolean[] sels = frame.tableView.getSheet().getSelectionArray(JSpread.ROW);
		// PłIĂ邩H
		if (SxTextUtilities.search(sels, true) == -1) {
			tools.showMessage(frame, "R[hIĂ܂B", null,
					JOptionPane.ERROR_MESSAGE);
			return;
		}
		// IĂ郌R[h̒ɕҏW̃R[h邩H
		for (int i=0; i<sels.length; i++) {
			if (sels[i] && data.getMode(i) != DbData.NONE) {
				tools.showMessage(frame, "łɕҏW̃R[h܂B", null,
						JOptionPane.ERROR_MESSAGE);
				return;
			}
		}
		// ҏWԂɂ
		for (int i=0; i<sels.length; i++) {
			if (sels[i]) {
				data.addRecord(new EditingRecord(DbData.INSERT, data.getRecord(i)));
			}
		}
		frame.setData(data);		
		frame.updateActionState();
	}
}
