package asandatabasebrowser.action;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.view.DbTextFrame;


public class SaveBinaryDataAction extends AbstractAction {
	AsanDatabaseBrowser tools;
	DbTextFrame textframe;
	
	public SaveBinaryDataAction(AsanDatabaseBrowser tools, DbTextFrame textframe) {
		super("Oĕۑ");
		putValue(SHORT_DESCRIPTION, "Oĕۑ");
		putValue(LONG_DESCRIPTION, "Oĕۑ");
		putValue(SMALL_ICON, Global.getImageIcon("/resources/FileSaveAs.png"));
		this.tools = tools;
		this.textframe = textframe;
	}

	public void actionPerformed(ActionEvent ev) {
		System.out.println("SaveBinaryDataAction");
		// ۑt@CI
	    JFileChooser chooser = new JFileChooser();
	    int returnVal = chooser.showSaveDialog(textframe);
	    if(returnVal != JFileChooser.APPROVE_OPTION) {
	    	return;
	    }
	    File file = chooser.getSelectedFile();
	    byte[] content = textframe.getContent();
	    if (content != null) {
	    	// oCi`ŕۑ
			FileOutputStream out = null;
		    try {
				out = new FileOutputStream(file);
				out.write(content);
				tools.showMessage(textframe, "t@Cۑ܂.", null, JOptionPane.INFORMATION_MESSAGE);
			} catch (IOException e) {
				e.printStackTrace();
				tools.showMessage(textframe, "t@C̕ۑɎs܂.", e, JOptionPane.ERROR_MESSAGE);
			} finally {
				if (out != null) try { out.close(); } catch (IOException ex) {}
			}
		} else {
			// eLXg`ŕۑ
			String text = textframe.getText();
			FileWriter out = null;
		    try {
				out = new FileWriter(file);
				out.write(text);
				tools.showMessage(textframe, "t@Cۑ܂.", null, JOptionPane.INFORMATION_MESSAGE);
			} catch (IOException e) {
				e.printStackTrace();
				tools.showMessage(textframe, "t@C̕ۑɎs܂.", e, JOptionPane.ERROR_MESSAGE);
			} finally {
				if (out != null) try { out.close(); } catch (IOException ex) {}
			}
		}
	}
}

