/*
 * 쐬: 2007/11/07
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.JTextPane;

import net.sourceforge.swingx.SxAction;
import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.AsanDatabaseBrowser;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlTokenConstants;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;

/** SQL̃RgȂ. */
public class SqlExcludeCommentAction extends SxAction {
	final JTextPane pane;
	public SqlExcludeCommentAction(JTextPane pane) {
		super("Iꂽ͈͂̃Rg폜");
		putValue(SHORT_DESCRIPTION, "Iꂽ͈͂̃Rg폜܂");
		putValue(LONG_DESCRIPTION, "Iꂽ͈͂̃Rg폜܂");
		this.pane = pane;
	}
	public void actionPerformed(ActionEvent ev) {
		String text = pane.getSelectedText();
		if (text == null || text.length() == 0) return;
		// SQL͂A傲ƂɂԂ؂B
		ArrayList tokens = null;
		try {
			tokens = new BlancoSqlParser().parse(text);
		} catch (RuntimeException e) {
            AsanDatabaseBrowser.theApp.showMessage(pane, 
            		"SQLsƎv܂",
            		e, SxOptionPane.ERROR_MESSAGE);
			return;	// sSSQLƋN肦B
		}    	
    	// Rg폜B
		StringBuffer sb = new StringBuffer();
		for (int i=0; i<tokens.size(); i++) {
			BlancoSqlToken t = (BlancoSqlToken) tokens.get(i);
			switch (t.getType()) {
			case BlancoSqlTokenConstants.SPACE:
			case BlancoSqlTokenConstants.SYMBOL:
			case BlancoSqlTokenConstants.KEYWORD:
			case BlancoSqlTokenConstants.NAME:
			case BlancoSqlTokenConstants.VALUE:
				sb.append(t.getString());
				break;
			case BlancoSqlTokenConstants.COMMENT:
				if (t.getString().startsWith("--")) {
					// VOCRg̎ɂ́Asc
					sb.append("\n");
				} else {
					// }`CRĝƂɂ́A폜
				}
				break;
			case BlancoSqlTokenConstants.END:
				break;
			case BlancoSqlTokenConstants.UNKNOWN:
			default:
				assert false: t.getType();
			}
		}
		pane.replaceSelection(sb.toString());
	}
	public void updateStatus() {
	}
}
