/*
 * 쐬: 2007/09/20
 */
package asandatabasebrowser.action;

import java.awt.Event;
import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;

import net.sourceforge.swingx.SxAction;
import asandatabasebrowser.AsanDatabaseBrowser;
import blanco.commons.sql.format.BlancoSqlFormatter;
import blanco.commons.sql.format.BlancoSqlFormatterException;
import blanco.commons.sql.format.BlancoSqlRule;

public class SqlFormatAction extends SxAction{
	final BlancoSqlRule rule;
	final JTextPane pane;
	boolean test;
	public SqlFormatAction(BlancoSqlRule rule, JTextPane pane, boolean test) {
		super("SQL`s(F)");
        putValue(MNEMONIC_KEY, new Integer('F'));
		putValue(SHORT_DESCRIPTION, "SQL`s܂"+(test?"test":""));
		putValue(LONG_DESCRIPTION, "SQL`s܂");
		putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke('F', Event.CTRL_MASK|Event.SHIFT_MASK)); // Shift+Ctrl+F
		this.rule = rule;
		this.pane = pane;
		this.test = test;
	}
	public void actionPerformed(ActionEvent e) {
		if (test) {
	        try {
	        	// `B
	            BlancoSqlFormatter formatter = new BlancoSqlFormatter(rule);
	    		String sql = pane.getText();
				String newSql = formatter.format(sql);
				pane.setText(newSql);
			} catch (BlancoSqlFormatterException ex) {
				ex.printStackTrace();
				AsanDatabaseBrowser.theApp.showMessage(pane.getRootPane(), 
						"SQL`Ɏs܂", ex, JOptionPane.ERROR_MESSAGE);
			}
			
		} else {
			try {
	        	// `B
	            BlancoSqlFormatter formatter = new BlancoSqlFormatter(rule);
	    		String sql = pane.getText();
				String newSql = formatter.format(sql);
				pane.setText(newSql);
			} catch (BlancoSqlFormatterException ex) {
				ex.printStackTrace();
				AsanDatabaseBrowser.theApp.showMessage(pane.getRootPane(), 
						"SQL`Ɏs܂", ex, JOptionPane.ERROR_MESSAGE);
			}
		}
        
	}
	public void updateStatus() {
		
	}
}
