/*
 * 쐬: 2007/10/10
 */
package asandatabasebrowser.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.JTextPane;

import asandatabasebrowser.AsanDatabaseBrowser;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlTokenConstants;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;
import net.sourceforge.swingx.SxAction;
import net.sourceforge.swingx.SxOptionPane;


public class SqlUnformatAction extends SxAction {
	final JTextPane pane;
	public SqlUnformatAction(JTextPane pane) {
		super("Iꂽ͈͂1s");
		putValue(SHORT_DESCRIPTION, "Iꂽ͈͂1sɂ܂(Rg͏Ȃ܂)");
		putValue(LONG_DESCRIPTION, "Iꂽ͈͂1sɂ܂(Rg͏Ȃ܂)");
		this.pane = pane;
	}

	private void unformat3() {
		String text = pane.getSelectedText();
		if (text == null) return;
		if (text.length() == 0) return;
		// SQL͂A傲ƂɂԂ؂B
		ArrayList tokens = null;
		try {
			tokens = new BlancoSqlParser().parse(text);
		} catch (RuntimeException e) {
            AsanDatabaseBrowser.theApp.showMessage(pane, 
            		"SQLsƎv܂",
            		e, SxOptionPane.ERROR_MESSAGE);
			return;	// sSSQLƋN肦B
		}    	
    	// 󔒂PɂARg폜B
		StringBuffer sb = new StringBuffer();
		for (int i=0; i<tokens.size(); i++) {
			BlancoSqlToken t = (BlancoSqlToken) tokens.get(i);
			switch (t.getType()) {
			case BlancoSqlTokenConstants.SPACE:
				if (i == 0) {
					sb.append(t.getString());	// ŏ̃Xy[X͏ȂȂB
				} else {
					// OɋLΏȂB
					if (i>0 && ((BlancoSqlToken) tokens.get(i-1)).getType() == BlancoSqlTokenConstants.SYMBOL) {
						break;
					}
					if (i<tokens.size()-1 && ((BlancoSqlToken) tokens.get(i+1)).getType() == BlancoSqlTokenConstants.SYMBOL) {
						break;
					}
					sb.append(" ");
				}
				break;
			case BlancoSqlTokenConstants.SYMBOL:
			case BlancoSqlTokenConstants.KEYWORD:
			case BlancoSqlTokenConstants.NAME:
			case BlancoSqlTokenConstants.VALUE:
				sb.append(t.getString());
				break;
			case BlancoSqlTokenConstants.COMMENT:
				// Ȃ
				break;
			case BlancoSqlTokenConstants.END:
				break;
			case BlancoSqlTokenConstants.UNKNOWN:
			default:
				assert false: t.getType();
			}
		}
		pane.replaceSelection(sb.toString());
	}
	public void actionPerformed(ActionEvent ev) {
		unformat3();
	}
	public void updateStatus() {
		
	}
}
