package asandatabasebrowser.model;

import java.util.ArrayList;

/**
 * J<<entity>>
 */
public class ColumnInfo implements IColumnInfo {
	public String tableCatalog;		// e[uJ^O (null ̉\) 
	public String tableSchema;		// e[uXL[} (null ̉\) 
	public String tableName;		// e[u 
	public String columnName;		//  
	public short  dataType;			// java.sql.Types  SQL ̌^ 
	public String typeName;			// f[^\[Xˑ̌^BUDT ̏ꍇA^͊Sw 
	public int    columnSize;		// TCYBchar  date ̌^ɂĂ͍ő啶Anumeric  decimal ̌^ɂĂ͐x 
	public int    decimalDigits;	// _ȉ̌ 
	public int    numPrecRadix;		//  (ʏ́A10 ܂ 2 ̂ǂ炩) 
	public int    nullable;			// NULL ͋邩
									// columnNoNulls - NULL lȂ\ 
									// columnNullable - K NULL l 
									// columnNullableUnknown - NULL lǂ͕s 
	public String remarks;			// RgLq (null ̉\) 
	public String columnDefault;	// ftHgl (null ̉\) 
	public int	  sqlDataType;		// gp
	public int 	  sqlDatetimeSub;	// gp
	public int    charOctetLength;	// char ̌^ɂĂ͗̍őoCg 
	public int    ordinalPosition;	// e[ũ̗CfbNX (1 n܂) 
	public String isNullable;		// "NO" ́A͌ NULL lȂƂӖB
									// "YES"  NULL l\邱ƂӖB
									// ͕̕sł邱ƂӖ 
	public String scopeCatalog;		// QƑ̃XR[vłe[ũJ^O (DATA_TYPE  REF łȂꍇ null) 
	public String scopeSchema;		// QƑ̃XR[vłe[ũXL[} (DATA_TYPE  REF łȂꍇ null) 
	public String scopeTable;		// QƑ̃XR[vłe[u (DATA_TYPE  REF łȂꍇ null) 
	public short  sourceDataType;	// ʂ̌^܂̓[U Ref ^Ajava.sql.Types  SQL ^̃\[X̌^ 
									// (DATA_TYPE  DISTINCT ܂̓[U REF łȂꍇ null) 
	public ArrayList others;
	/** J𐶐Bfor JDK1.4later */
	public ColumnInfo(
				String tableCatalog,
				String tableSchema,
				String tableName,
				String columnName,
				short  dataType,
				String typeName,
				int    columnSize,
				int    decimalDigits,
				int    numPrecRadix,
				int    nullable,
				String remarks,
				String columnDefault,
				int	   sqlDataType,
				int    sqlDatetimeSub,
				int    charOctetLength,
				int    ordinalPosition,
				String isNullable,
				ArrayList others
		) {
		this.tableCatalog		= tableCatalog;
		this.tableSchema		= tableSchema;
		this.tableName			= tableName;
		this.columnName			= columnName;
		this.dataType			= dataType;
		this.typeName			= typeName;
		this.columnSize			= columnSize;
		this.decimalDigits		= decimalDigits;
		this.numPrecRadix		= numPrecRadix;
		this.nullable			= nullable;
		this.remarks			= remarks;
		this.columnDefault		= columnDefault;
		this.sqlDataType 		= sqlDataType;		// gp
		this.sqlDatetimeSub 	= sqlDatetimeSub;	// gp
		this.charOctetLength	= charOctetLength;
		this.ordinalPosition	= ordinalPosition;
		this.isNullable			= isNullable;
		this.others = others;
	}
	/** J𐶐Bfor JDK1.4later */
	public ColumnInfo(
				String tableCatalog,
				String tableSchema,
				String tableName,
				String columnName,
				short  dataType,
				String typeName,
				int    columnSize,
				int    decimalDigits,
				int    numPrecRadix,
				int    nullable,
				String remarks,
				String columnDefault,
				int    charOctetLength,
				int    ordinalPosition,
				String isNullable,
				String scopeCatalog,
				String scopeSchema,
				String scopeTable,
				short  sourceDataType
		) {
		this.tableCatalog		= tableCatalog;
		this.tableSchema		= tableSchema;
		this.tableName			= tableName;
		this.columnName			= columnName;
		this.dataType			= dataType;
		this.typeName			= typeName;
		this.columnSize			= columnSize;
		this.decimalDigits		= decimalDigits;
		this.numPrecRadix		= numPrecRadix;
		this.nullable			= nullable;
		this.remarks			= remarks;
		this.columnDefault		= columnDefault;
		this.charOctetLength	= charOctetLength;
		this.ordinalPosition	= ordinalPosition;
		this.isNullable			= isNullable;
		this.scopeCatalog		= scopeCatalog;
		this.scopeSchema		= scopeSchema;
		this.scopeTable			= scopeTable;
		this.sourceDataType		= sourceDataType;
	}
	/**  for JDK1.3 */
	public ColumnInfo(
				String tableCatalog,
				String tableSchema,
				String tableName,
				String columnName,
				short  dataType,
				String typeName,
				int    columnSize,
				int    decimalDigits,
				int    numPrecRadix,
				int    nullable,
				String remarks,
				String columnDefault,
				int    charOctetLength,
				int    ordinalPosition,
				String isNullable) {
		this(tableCatalog, tableSchema, tableName, columnName,
			dataType, typeName, columnSize, decimalDigits, numPrecRadix,
			nullable, remarks, columnDefault, charOctetLength, ordinalPosition, isNullable,
			null, null, null, (short)-9999);
	}
	public String toString() { return columnName; }
	public String detail() {
		return  "tableCatalog       ="+tableCatalog+"\n"+
				"tableSchema        ="+tableSchema+"\n"+
				"tableName          ="+tableName+"\n"+
				"columnName         ="+columnName+"\n"+
				"dataType           ="+dataType+"\n"+
				"typeName           ="+typeName+"\n"+
				"columnSize         ="+columnSize+"\n"+
				"decimalDigits      ="+decimalDigits+"\n"+
				"numPrecRadix       ="+numPrecRadix+"\n"+
				"nullable           ="+nullable+"\n"+
				"remarks            ="+remarks+"\n"+
				"columnDefault      ="+columnDefault+"\n"+
				"charOctetLength    ="+charOctetLength+"\n"+
				"ordinalPosition    ="+ordinalPosition+"\n"+
				"isNullable         ="+isNullable+"\n"+
				"scopeCatalog       ="+scopeCatalog+"\n"+
				"scopeSchema        ="+scopeSchema+"\n"+
				"scopeTable         ="+scopeTable+"\n"+
				"sourceDataType     ="+sourceDataType+"\n";
	}
//	/**
//	 * ^̕ԂB
//	 * "DECIMAL(7,2)" "VARCHAR2(80)" "SMALLINT NOT NULL" Ȃ
//	 * @return
//	 */
//	public String getTypeStr() {
//        String typestr = typeName;
//        if (columnSize != 0) {
//			typestr += "("+columnSize+
//			(decimalDigits != 0 ? (", "+decimalDigits) : "")
//			+")";
//		}
//		typestr += "YES".equals(isNullable) ? "" : " NOT NULL";
//		return typestr;
//	}
}


