/*
 * 쐬: 2005/11/29
 */
package asandatabasebrowser.model;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;

import javax.swing.JLabel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HighlightList {
	ArrayList list = new ArrayList();
	private void add(Highlight highlight) {
		list.add(highlight);
	}
	
	public boolean setHighlight(String input, JLabel label) {
		for (int i=0; i<list.size(); i++) {
			Highlight highlight = (Highlight) list.get(i);
			//System.out.println("highlight="+highlight);
			if (highlight.setHighlight(input, label)) return true;
		}
		return false;
	}
	public static HighlightList loadHighlightList(String filename) {
		if (filename == null) return null;
		try {
			File file = new File(filename);
			if (! file.exists()) return null;
			System.out.println("file="+file);
			DocumentBuilderFactory dbfactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = dbfactory.newDocumentBuilder();
			Document document = builder.parse(file);
			NodeList list = document.getChildNodes();
			for (int i=0; i<list.getLength(); i++) {
				Node n = list.item(i);
				if (n.getNodeName().equals("Database")) {
					HighlightList result = loadDatabase(n);
					//System.out.println("Database="+result);
					return result;
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	private static HighlightList loadDatabase(Node node) {
		HighlightList result = new HighlightList();
		NodeList list = node.getChildNodes();
		for (int i=0; i<list.getLength(); i++) {
			Node n = list.item(i);
			if (n.getNodeType() == Node.ELEMENT_NODE) {
				if (n.getNodeName().equals("Highlight")) {
					Highlight highlight = loadHighlight(n);
					result.add(highlight);
				}
			}
		}
		return result;
	}
	private static Highlight loadHighlight(Node node) {
		NamedNodeMap attr = node.getAttributes();
		String name      = attr.getNamedItem("name").getNodeValue();
		String textColorString = attr.getNamedItem("TextColor").getNodeValue();
		String backColorString   = attr.getNamedItem("BackgroundColor").getNodeValue();
		String fontStyleString = attr.getNamedItem("FontStyle").getNodeValue();
		Color textColor = Color.decode(textColorString);
		Color backColor = Color.decode(backColorString);
		int fontStyle = Font.PLAIN;
		if (fontStyleString.toUpperCase().indexOf("BOLD") != -1) {
			fontStyle |= Font.BOLD;
		}
		if (fontStyleString.toUpperCase().indexOf("ITALIC") != -1) {
			fontStyle |= Font.ITALIC;
		}
		//System.out.println("name="+name+" text="+textColor);
		ArrayList regList = new ArrayList();
		NodeList list = node.getChildNodes();
		for (int i=0; i<list.getLength(); i++) {
			Node n = list.item(i);
			if (n.getNodeType() == Node.ELEMENT_NODE) {
				if (n.getNodeName().equals("RegExp")) {
					String regPattern = n.getFirstChild().getNodeValue();
					regList.add(regPattern);
				}
			}
		}
		return new Highlight(name, textColor, backColor, fontStyle, regList);
	}	
}
