package asandatabasebrowser.model;

import net.sourceforge.swingx.SxTextUtilities;

/**
 * ʏ<<entity>>
 */
public class ResultInfo implements IColumnInfo {

	public boolean isAutoIncrement;	// IɔԍtēǂݍݐpƂĈ邩ǂ
	public boolean isCaseSensitive;	// ̑啶ʂ邩ǂ
	public boolean isSearchable;		// where ߂Ŏgpł邩ǂ
	public boolean isCurrency;			// ʉ݂̒lǂ
	public int		isNullable;			// NULL Zbgł邩ǂ(columnNoNulls/columnNullable/columnNullableUnknown)
	public boolean isSigned;			// ltlǂ
	public int		columnDisplaySize;	// ʏ̍ő啝̕
	public String	columnLabel;		// \ɎgpA̐^Cg
	public String  columnName;			// ̖O
	public String	schemaName;			// e[ũXL[}
	public int		precision;			// 10i
	public int		scale;				// _ȉ̌
	public String	tableName;			// e[u
	public String	catalogName;		// e[ũJ^O
	public int		columnType;			//  SQL ^(java.sql.Types  SQL ^)
	public String	columnTypeName;		// ̃f[^x[XŗĽ^
	public boolean	isReadOnly;			// ΓIɏ݉\łȂǂ
	public boolean	isWritable;			// ւ݂̏𐬌邱Ƃł邩ǂ
	public boolean	isDefinitelyWritable;	// ݂̏K邩ǂ
	public String	columnClassName;	// Java NX̊Sw肳ꂽOԂ܂B

	/** ʏ𐶐B */
	public ResultInfo(
				boolean isAutoIncrement,
				boolean isCaseSensitive,
				boolean isSearchable,
				boolean isCurrency,
				int isNullable,
				boolean isSigned,
				int columnDisplaySize,
				String columnLabel,
				String columnName,
				String schemaName,
				int precision,
				int scale,
				String tableName,
				String catalogName,
				int columnType,
				String columnTypeName,
				boolean isReadOnly,
				boolean isWritable,
				boolean isDefinitelyWritable,
				String columnClassName
		) {

		this.isAutoIncrement		= isAutoIncrement;
		this.isCaseSensitive		= isCaseSensitive;
		this.isSearchable			= isSearchable;
		this.isCurrency				= isCurrency;
		this.isNullable				= isNullable;
		this.isSigned				= isSigned;
		this.columnDisplaySize		= columnDisplaySize;
		this.columnLabel			= columnLabel;
		this.columnName				= columnName;
		this.schemaName				= schemaName;
		this.precision				= precision;
		this.scale					= scale;
		this.tableName				= tableName;
		this.catalogName			= catalogName;
		this.columnType				= columnType;
		this.columnTypeName			= columnTypeName;
		this.isReadOnly				= isReadOnly;
		this.isWritable				= isWritable;
		this.isDefinitelyWritable	= isDefinitelyWritable;
		this.columnClassName		= columnClassName;
	}

	public boolean equals(Object obj) {
		if ( !(obj instanceof ResultInfo)) return false;
		ResultInfo info = (ResultInfo) obj;
		if(SxTextUtilities.compareString(catalogName,    info.catalogName   )!=0) return false;
		if(SxTextUtilities.compareString(schemaName,  info.schemaName )!=0) return false;
		if(SxTextUtilities.compareString(tableName,    info.tableName   )!=0) return false;
		if(SxTextUtilities.compareString(columnName, info.columnName)!=0) return false;
		return true;
	}
	public String toString() { return columnLabel; }
	public String toDetailString() {
		return
		"isAutoIncrement		= "+isAutoIncrement+"\n"+
		"isCaseSensitive		= "+isCaseSensitive+"\n"+
		"isSearchable			= "+isSearchable+"\n"+
		"isCurrency				= "+isCurrency+"\n"+
		"isNullable				= "+isNullable+"\n"+
		"isSigned				= "+isSigned+"\n"+
		"columnDisplaySize		= "+columnDisplaySize+"\n"+
		"columnLabel			= "+columnLabel+"\n"+
		"columnName				= "+columnName+"\n"+
		"schemaName				= "+schemaName+"\n"+
		"precision				= "+precision+"\n"+
		"scale					= "+scale+"\n"+
		"tableName				= "+tableName+"\n"+
		"catalogName			= "+catalogName+"\n"+
		"columnType				= "+columnType+"\n"+
		"columnTypeName			= "+columnTypeName+"\n"+
		"isReadOnly				= "+isReadOnly+"\n"+
		"isWritable				= "+isWritable+"\n"+
		"isDefinitelyWritable	= "+isDefinitelyWritable+"\n"+
		"columnClassName		= "+columnClassName+"\n";
	}
}

