package asandatabasebrowser.model;

import java.util.ArrayList;

/**
 * ʏ<<entity>>
 */
public class ResultSetInfo implements ITableInfo {
	public VvDatabase db;
	final ArrayList resultInfoList;	// <ResultInfo>

	public ResultSetInfo(VvDatabase db, ArrayList list) {
		assert db != null;
		assert list != null;
		this.db = db;
		this.resultInfoList = list;
	}

	public int getColumnCount() {
		return resultInfoList.size();
	}
	public ResultInfo getResultInfo(int index) {
		ResultInfo info = (ResultInfo) resultInfoList.get(index);
		return info;
	}
	public IColumnInfo getIColumnInfo(int index) { return getResultInfo(index); }
	public String getColumnName(int index) {
		ResultInfo info = (ResultInfo) resultInfoList.get(index);
		return info.columnLabel;
	}

	public boolean equals(Object obj) {
		if (!(obj instanceof ResultSetInfo)) return false;
		ResultSetInfo info = (ResultSetInfo) obj;
		if (getColumnCount() != info.getColumnCount()) return false;
		for (int i=0; i<resultInfoList.size(); i++) {
			boolean eq = resultInfoList.get(i).equals(info.resultInfoList.get(i));
			if (! eq) return false;
		}
		return true;
	}

	public VvDatabase getDatabase() { return db; }
	
	public String toString() {
		return "resultInfoList = "+resultInfoList;
	}
}


