package asandatabasebrowser.model;

import java.util.ArrayList;


/**
 * XL[}<<entity>>
 * J^OB
 */
public class SchemaInfo {
	final String tableCatalog;	// e[uJ^O (null ̉\) (JDK1.3)
	final String tableSchema;		// e[uXL[}
	private ArrayList tables;		// ArrayList<TableTypeInfo>
	public final VvDatabase db;
	
	SchemaInfo(VvDatabase db, String tableCatalog, String tableSchema, ArrayList tables) {
		assert db != null;
		assert tables!=null;
		this.db = db;
		this.tableCatalog = tableCatalog;
		this.tableSchema  = tableSchema;
		this.tables = tables;
	}

	public String getSchemaName() { return tableSchema; }
	public String getCatalogName() { return tableCatalog; }

	public int getCount() {
		return tables.size();
	}
	public TableTypeInfo getTableTypeInfo(int index) {
		return (TableTypeInfo) tables.get(index);
	}
	public TableTypeInfo getTableTypeInfo(String type) {
		assert type != null;
		for (int i=0; i<tables.size(); i++) {
			TableTypeInfo t = (TableTypeInfo) tables.get(i);
			if (t.type.equals(type)) {
				return t;
			}
		}
		return null;
	}

	public String toString() {
    	if (tableSchema != null) return tableSchema;
    	return tableCatalog;
//		return 
//			"tableCatalog = "+tableCatalog + "\n"+
//			"tableSchema  = "+tableSchema + "\n";
	}
}
