/*
 * 쐬: 2005/11/20
 */
package asandatabasebrowser.util;

import java.awt.*;
import javax.swing.*;

import asandatabasebrowser.Global;

import net.sourceforge.swingx.SxUtilities;



import java.awt.event.*;

/**
 * FontChooser tHgI_CAO
 *
 * tHg     [R{{bNX       ]
 * TCY         [     11][  B  ][  I  ]
*/
public class FontChooser extends JPanel {
	String[] FONT_NAMES = {
		"Serif",
		"SansSerif",
		"Monospaced",
		"Dialog",
		"DialogInput"
	};
	static String A_QUICK_BROWN_FOX = "A quick brown fox jumps over the lazy dog";
	static int GAP = 10;
	private JComboBox cmbFamily;        // tHgt@~[̃R{{bNX
	private JTextField txtSize;         // tHgTCY
	private JToggleButton tglBold;      // 
	private JToggleButton tglItalic;    // Α
    private JTextArea sample;             // Tv
    
    /**
     *  @param showLabel   JLabelgāAutHgvAuTCYvȂǂ̕\邩H
     */
	public FontChooser(boolean showLabel, boolean showSample, boolean logicalFont) {
		// R|[lg̍쐬
		String[] fontNames = null;
		if (logicalFont) {
			fontNames = FONT_NAMES;
		}
		else {
			GraphicsEnvironment genv =
                    GraphicsEnvironment.getLocalGraphicsEnvironment();
			fontNames = genv.getAvailableFontFamilyNames();
		}
		setLayout(new BorderLayout(GAP, GAP));
        JPanel panel = new JPanel();
//        panel.setLayout(new BoxLayout(panel, BoxLayout.X_AXIS));
        panel.setLayout(new GridLayout(2,2, GAP, GAP));
		// tHg
		if (showLabel) panel.add(new JLabel(_("FontFamily")));
		cmbFamily = new JComboBox(fontNames);
        Dimension dim = new Dimension(200,25);
        cmbFamily.setMinimumSize(dim);
        cmbFamily.setPreferredSize(dim);
        cmbFamily.setMaximumSize(dim);
		panel.add(cmbFamily);
		// tHgTCY
		if (showLabel) panel.add(new JLabel(_("FontSize")));
        // tHgTCY{[hC^bN
        JPanel panel2 = new JPanel(new GridLayout(1,3, GAP, GAP));
		txtSize = new JTextField("10", 3);	// 3
        txtSize.setHorizontalAlignment(JTextField.TRAILING);    // E
		panel2.add(txtSize);
		// Bold & Italic
		Icon icon = Global.getImageIcon("/resources/FontBold.png");
		if(icon!=null)
			tglBold = new JToggleButton(icon);
		else
			tglBold = new JToggleButton("Bold");
		tglBold.setPreferredSize(new Dimension(25,25));
		panel2.add(tglBold);
		icon = Global.getImageIcon("/resources/FontItalic.png");
		if (icon!=null)
			tglItalic = new JToggleButton(icon);
		else
			tglItalic = new JToggleButton("Italic");
		tglItalic.setPreferredSize(new Dimension(25,25));
		panel2.add(tglItalic);
        panel.add(panel2);
        this.add(panel, BorderLayout.CENTER);
        // Tv
        if (showSample) {
        	sample = new JTextArea(
        			A_QUICK_BROWN_FOX.toUpperCase()+"\n"+
        			A_QUICK_BROWN_FOX.toLowerCase()+"\n"+
        			"Ђ炪ȃJ^Ji"+"\n"+
        			"12345678901234567890",
        			5, 40);
        	SxUtilities.addPopupMenuMouseListener(sample);
        	this.add(new JScrollPane(sample), BorderLayout.SOUTH);
    		FontListener listener = new FontListener();
    		cmbFamily.addItemListener(listener);
    		tglBold.addActionListener(listener);
    		tglItalic.addActionListener(listener);
        }
	}
	public FontChooser() { this(true, true, true); }
    public FontChooser(Font font) {
        this();
        setFont(font);
    }

	public Font getChoosedFont() {
        String family = (String)cmbFamily.getSelectedItem();
		int style = Font.PLAIN;
		if(tglBold.isSelected()) style |= Font.BOLD;
		if(tglItalic.isSelected()) style |= Font.ITALIC;
		int size = 10;	// ftHg̃TCY
		try {
			size = Integer.parseInt(txtSize.getText());
		} catch(NumberFormatException e) { System.out.println("FontChooser:lłȂ");}
        //System.out.println("family="+family+" stype="+style+" size="+size);
		return new Font(family, style, size);
	}
	public void setChoosedFont(Font font) {
		cmbFamily.setSelectedItem(font.getFamily());
		tglBold.setSelected(font.isBold());
		tglItalic.setSelected(font.isItalic());
		txtSize.setText(""+font.getSize());
		if (sample != null) sample.setFont(font);
	}

	public void setEnabled(boolean sel) {
		cmbFamily.setEnabled(sel);
		txtSize.setEnabled(sel);
		tglBold.setEnabled(sel);
		tglItalic.setEnabled(sel);
		//sample.setEnabled(sel);
	}

	//   Zbg@@@
	public static Font showDialog(Component parent, String title, Font font) {
		FontChooser chooser = new FontChooser();
        chooser.setFont(font);
		int rc = JOptionPane.showConfirmDialog(parent, chooser, title,
						JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
		if(rc!=0) return null;
		// l𔽉f
		return chooser.getFont();
	}
	/** ۉΉ i18n */
	private static String _(String text) {
		//return ApplicationResources.getString("FontChooser."+text, text);
		return text;
	}
	class FontListener implements ActionListener, ItemListener {
		public void actionPerformed(ActionEvent e) {
			System.out.println("actionPerformed() e="+e);
			System.out.println("Bold="+tglBold.isSelected()+ " Italic="+tglItalic.isSelected());
			Font font = getChoosedFont();
			sample.setFont(font);
		}
		public void itemStateChanged(ItemEvent e) {
			System.out.println("itemStateChanged() e="+e);
			Font font = getChoosedFont();
			sample.setFont(font);
		}
	}
	public static void main(String[] args) {

		// ׂẴtHg񋓂
		GraphicsEnvironment genv = GraphicsEnvironment.getLocalGraphicsEnvironment();
		String[] names = genv.getAvailableFontFamilyNames();
        System.out.println("genv.getAvailableFontFamilyNames() size="+names.length);
		for(int i=0; i<names.length; i++) {
			System.out.println(names[i]);
		}
		Font[] fonts = genv.getAllFonts();
        System.out.println("genv.getAllFonts() size="+fonts.length);
		for(int i=0; i<fonts.length; i++) {
			System.out.println(fonts[i]);
		}

		// c[o[ɂĂ݂B
		JFrame frame = new JFrame();
		JToolBar bar = new JToolBar();
        FontChooser chooser = new FontChooser(false, true, true);
        chooser.setFont(new Font("Serif", Font.BOLD, 10));
		bar.add(chooser);
		Container pane = frame.getContentPane();
		pane.add(bar, BorderLayout.NORTH);
		// EBhEIƂɃAvP[VIBʓ|
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}
		});
		frame.setSize(800, 600);
		frame.setVisible(true);

		// _CAO\Ă݂B
		Font font = new Font("Serif", Font.BOLD, 10);
		Font newFont = FontChooser.showDialog(frame, "FontChooser", font);
		System.out.println(newFont);
		System.exit(0);
	}
}

