/*
 * 쐬: 2005/10/29
 */
package asandatabasebrowser.util;

import java.io.*;

public class PathClassLoader extends ClassLoader {
	 
	String[] paths;
	/**
	 * @param paths	X̃pXɂ͖ɃZp[^ȂƁB
	 */
	public PathClassLoader(String[] paths) {
		this.paths = paths;
	}

	public Class findClass(String name) {
		byte[] b = loadClassData(name);
		if (b == null) return null;
		return defineClass(name, b, 0, b.length);
	}

	
	/**
	 * w肳ꂽpXgāAT[õNX擾.
	 */
	private byte[] loadClassData(String name) {
		// NXt@C擾B
		String fname = name.replace('.', File.separatorChar) + ".class";
		// X̃pXɃt@C邩ǂTB
		for (int i=0; i<paths.length; i++) {
			File file = new File(paths[i] + File.separatorChar + fname);
			if (file.exists()) {
				byte[] bytes = new byte[(int) file.length()];
				FileInputStream in = null;
				try {
					in = new FileInputStream(file);
					int len = in.read(bytes);
					if (len == bytes.length) return bytes;
				}
				catch (IOException e) {
					e.printStackTrace();
				}
				finally {
					if (file != null) try { in.close(); } catch (IOException e1) {}
				}
			}
		}
		return null;	// Ȃ(;_;)
	}

}
