package asandatabasebrowser.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

import asandatabasebrowser.model.VvDatabase;

import net.sourceforge.swingx.SxUtilities;



public class ConnectDialog extends JPanel {
	public JTextField name = new JTextField();
	public JTextField driver = new JTextField();
	public JTextField url = new JTextField();
	public JTextField user = new JTextField();
	public JPasswordField pass = new JPasswordField();

	public ConnectDialog() {
		GridBagLayout gridbag = new GridBagLayout();
		this.setLayout(gridbag);
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.insets = new Insets(4,4,4,4);

		name.setEditable(false);
		driver.setEditable(false);
		url.setEditable(false);
		Dimension dim = url.getPreferredSize();
		dim.width = 800;
		url.setPreferredSize(new Dimension(400, dim.height));
		url.setMaximumSize(dim);
		SxUtilities.addPopupMenuMouseListener(name);
		SxUtilities.addPopupMenuMouseListener(driver);
		SxUtilities.addPopupMenuMouseListener(url);
		SxUtilities.addPopupMenuMouseListener(user);
		SxUtilities.addPopupMenuMouseListener(pass);
		
		JLabel label = new JLabel("O");
		gridbag.setConstraints(label, c);
		this.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(name, c);
		this.add(name);

		c.gridwidth = 1;
		label = new JLabel("hCo");
		gridbag.setConstraints(label, c);
		this.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(driver, c);
		this.add(driver);

		c.gridwidth = 1;
		label = new JLabel("URL");
		gridbag.setConstraints(label, c);
		this.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(url, c);
		this.add(url);

		c.gridwidth = 1;
		label = new JLabel("[U(U)");
		label.setDisplayedMnemonic('U');
		label.setLabelFor(user);
		gridbag.setConstraints(label, c);
		this.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(user, c);
		this.add(user);

		c.gridwidth = 1;
		label = new JLabel("pX[h(P)");
		label.setDisplayedMnemonic('P');
		label.setLabelFor(pass);
		gridbag.setConstraints(label, c);
		this.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(pass, c);
		this.add(pass);
	}

	public void setDatabase(VvDatabase db) {
		name.setText(db.name);
		driver.setText(db.driverName);
		url.setText(db.url);
		user.setText(db.user);
		user.selectAll();
		pass.setText(db.password);
		pass.selectAll();
	}
	public String getUser() { return user.getText(); }
	public String getPass() { return new String(pass.getPassword()); }
	
    public static int showConnectDialog(Component parent, VvDatabase db) {
    	ConnectDialog dialog = new ConnectDialog();
		dialog.setDatabase(db);
        int ans = JOptionPane.showConfirmDialog(parent, 
        	dialog,
            "f[^x[Xւ̐ڑ", 
            JOptionPane.OK_CANCEL_OPTION,
            JOptionPane.PLAIN_MESSAGE);
        return ans;
    }
}


