package asandatabasebrowser.view;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.VvDatabase;
import asandatabasebrowser.model.VvDocument;
import blanco.commons.sql.format.BlancoSqlRule;

import net.sourceforge.swingx.SxMessageBox;
import net.sourceforge.swingx.SxOptionPane;
import net.sourceforge.swingx.SxUtilities;


/**
 * f[^x[X̃vpeB.
 *	O:      [              ]
 *	hCo [                            |]
 *	URL:       [                            |]
 *	[U   [              ]
 *	pX[h [********      ]
 *	[x] ڑɃ[UƃpX[h₢킹B
*/
public class DatabaseDialog extends JPanel {
	public JTextField name = new JTextField();
	public JComboBox driver = new JComboBox();
	public JComboBox url = new JComboBox();
	public JTextField user = new JTextField();
	public JPasswordField pass = new JPasswordField();
	public JTextArea classpaths = new JTextArea();
	public JCheckBox isShow = new JCheckBox("ڑɃ[UƃpX[h₢킹");
	public JCheckBox rollbackBeforeClose = new JCheckBox("ؒfrollback");
	public JCheckBox rollbackAfterQuery = new JCheckBox("ɑrollback");
	
	private JComboBox productName = new JComboBox(VvDatabase.productNames);

	public JTextField highlightFile = new JTextField();
	public JCheckBox useOracleTableComments = 
		new JCheckBox("IN̂ƂASYS.ALL_TAB_COMMENTS ̃Rg remark ɂ邩H");
	public JCheckBox useOracleColumnComments = 
		new JCheckBox("IN̂ƂASYS.ALL_COL_COMMENTS ̃Rg remark ɂ邩H");
	public JCheckBox hideOracleBinTable =
		new JCheckBox("IN10gȍ~̂ƂATCNriS~e[uj\ȂB");
	public JRadioButton[] keywordCase = new JRadioButton[3];
	public JTextArea functionNames = new JTextArea(10, 80);
	
	public DatabaseDialog() {
		JTabbedPane tab = new JTabbedPane();
		this.add(tab);
		tab.addTab("{", createBaseTab());
		tab.addTab("g", createExtTab());
		tab.addTab("SQL`", createSqlFormatterTab());
	}
	private JPanel createBaseTab() {
		JPanel panel = new JPanel();
		panel.setBorder(new EmptyBorder(10, 10, 10, 10));
		GridBagLayout gridbag = new GridBagLayout();
		panel.setLayout(gridbag);
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.insets = new Insets(4,8,4,8);

		driver.setEditable(true);
		url.setEditable(true);
		SxUtilities.addPopupMenuMouseListener(name);
		SxUtilities.addPopupMenuMouseListener(user);
		SxUtilities.addPopupMenuMouseListener(pass);
		SxUtilities.addPopupMenuMouseListener(classpaths);
		
		// R{{bNXɂׂẴhCoURLĂB
		VvDocument doc = AsanDatabaseBrowser.theApp.doc;
		Set drivers = new HashSet();
		Set urls = new HashSet();
		for (int i=0; i<doc.databaseList.size(); i++) {
			VvDatabase db = (VvDatabase) doc.databaseList.get(i);
			drivers.add(db.driverName);
			urls.add(db.url);
		}
		// ȒURL͊قė~B
		// http://d.hatena.ne.jp/eyamane/20060731/1154334190
		Dimension dim = url.getPreferredSize();
		dim.width = 800;	// 800hbg炢łH
		url.setPreferredSize(new Dimension(400, dim.height));
		url.setMaximumSize(dim);
		// JDBChCõR{{bNXɑIĂ
//		if (! drivers.isEmpty()) {
//			// ݂̐ݒɂhCoIɓĂB
//			for (Iterator i=drivers.iterator(); i.hasNext(); ) {
//				driver.addItem(i.next());
//			}
//		}
		// http://wiki.paulownia.jp/java/jdbc
		// ftHgƂĈȉ̃hCoB
		driver.addItem("sun.jdbc.odbc.JdbcOdbcDriver");
		driver.addItem("oracle.jdbc.driver.OracleDriver");
		driver.addItem("com.ibm.db2.jcc.DB2Driver");
		driver.addItem("COM.ibm.db2.jdbc.app.DB2Driver");
		driver.addItem("COM.ibm.db2.jdbc.net.DB2Driver");
		driver.addItem("com.ibm.db2.jcc.DB2Driver");
		driver.addItem("com.microsoft.sqlserver.jdbc.SQLServerDriver");
		driver.addItem("com.microsoft.jdbc.sqlserver.SQLServerDriver");
		driver.addItem("com.mysql.jdbc.Driver");
		driver.addItem("org.gjt.mm.mysql.Driver");
		driver.addItem("org.postgresql.Driver");
		driver.addItem("com.ncr.teradata.TeraDriver");
		driver.addItem("org.firebirdsql.jdbc.FBDriver");
		driver.addItem("org.hsqldb.jdbcDriver");
		driver.addItem("org.apache.derby.jdbc.EmbeddedDriver");
		driver.addItem("com.openbase.jdbc.ObDriver");
		driver.addItem("org.h2.Driver");
		driver.addItem("com.sybase.jdbc.SybDriver");
		driver.addItem("com.sybase.jdbc2.jdbc.SybDriver");
		driver.addItem("org.sqlite.JDBC");
		driver.addItem("org.axiondb.jdbc.AxionDriver");
		// KvɉĒǉĂEEE

		// JDBCURLR{{bNXɑIĂ
//		if (! urls.isEmpty()) {
//			for (Iterator i=urls.iterator(); i.hasNext(); ) {
//				url.addItem(i.next());
//			}
//		}
		url.addItem("jdbc:odbc:<DataSourceName>");
		url.addItem("jdbc:oracle:thin:@127.0.0.1:1521:<SID>");
		url.addItem("jdbc:oracle:oci:@<TNS>");
		url.addItem("jdbc:oracle:oci8:@<TNS>");
		url.addItem("jdbc:db2:<DataSourceName>");
		url.addItem("jdbc:db2://127.0.0.1:50000/<DataBaseName>");
		url.addItem("jdbc:db2://127.0.0.1:50000/<DataBaseName>");
		url.addItem("jdbc:sqlserver://localhost:1433;DatabaseName=<DBName>");
		url.addItem("jdbc:microsoft:sqlserver://127.0.0.1:1433;DatabaseName=<DBName>");
		url.addItem("jdbc:mysql://127.0.0.1:3306/<DBName>");
		url.addItem("jdbc:mysql://<host>/<database_name>?useUnicode=true&characterEncoding=SJIS");
		url.addItem("jdbc:postgresql://127.0.0.1:5432/<DBName>");
		url.addItem("jdbc:teradata://127.0.0.1:6063/<DBName>");
		url.addItem("jdbc:firebirdsql://127.0.0.1:3050/<DataBasePath>");
		url.addItem("jdbc:hsqldb:hsql://127.0.0.1:9001/<databasename>");
		url.addItem("jdbc:hsqldb:file:<databasename>");
		url.addItem("jdbc:hsqldb:mem:<databasename>");
		url.addItem("jdbc:derby:<databasename>;create=true");
		url.addItem("jdbc:openbase://localhost/<DataBaseName>");
		url.addItem("jdbc:h2:tcp://localhost:9092/<DataBasePath>");
		url.addItem("jdbc:h2:<DataBasePath>");
		url.addItem("jdbc:sybase:Tds:localhost:8001/<databasename>");
		url.addItem("jdbc:sqlite:<databasefile_path>");
		url.addItem("jdbc:axiondb:<database-name>[:<database-directory>]");
		// KvɉĒǉĂEEE

		
		name.setToolTipText("j[NȔCӂ̖OĂ");
		driver.setToolTipText("K{");
		url.setToolTipText("K{");
		user.setToolTipText("ڑɖ₢킹Ȃȗ\ł");
		pass.setToolTipText("ڑɖ₢킹Ȃȗ\ł");
		classpaths.setToolTipText(
				"<html>JDBChCojart@C̃pXw肵܂B<br>"+
				"GNXv[hbOhbv邱Ƃł܂B</html>");
		classpaths.setRows(5);
		rollbackBeforeClose.setToolTipText(
				"<html>DB2̏ꍇAؒfOcommit/rollbackȂƃG[ɂȂ邻łB<br>"+
				"ODBC Microsoft Access DriverłB</html>");
		rollbackAfterQuery.setToolTipText(
				"<html>DB2ȂǓxɂẮAł̃R[hA܂̓e[ubN܂B<br>"+
				"̏ꍇrollbacksȂƁÃgUNVłȂȂĂ܂܂B</html>");
        // hbv\ȃ^[QbgƂēo^
        new DropTarget(classpaths, DnDConstants.ACTION_COPY_OR_MOVE, new ClassPathDropListener(), true);

       
        JLabel label = new JLabel("O(N)");
		label.setDisplayedMnemonic('N');
		label.setLabelFor(name);
		gridbag.setConstraints(label, c);
		panel.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(name, c);
		panel.add(name);

		c.gridwidth = 1;
		label = new JLabel("hCo(D)");
		label.setDisplayedMnemonic('D');
		label.setLabelFor(driver);
		gridbag.setConstraints(label, c);
		panel.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(driver, c);
		panel.add(driver);

		c.gridwidth = 1;
		label = new JLabel("URL");
		label.setDisplayedMnemonic('L');
		label.setLabelFor(url);
		gridbag.setConstraints(label, c);
		panel.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(url, c);
		panel.add(url);

		c.gridwidth = 1;
		label = new JLabel("[U(U)");
		label.setDisplayedMnemonic('U');
		label.setLabelFor(user);
		gridbag.setConstraints(label, c);
		panel.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(user, c);
		panel.add(user);

		c.gridwidth = 1;
		label = new JLabel("pX[h(P)");
		label.setDisplayedMnemonic('P');
		label.setLabelFor(pass);
		gridbag.setConstraints(label, c);
		panel.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(pass, c);
		panel.add(pass);

		c.gridwidth = 1;
		label = new JLabel("NXpX(C)");
		label.setDisplayedMnemonic('C');
		label.setLabelFor(classpaths);
		gridbag.setConstraints(label, c);
		panel.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		JScrollPane s = new JScrollPane(classpaths);
		gridbag.setConstraints(s, c);
		panel.add(s);
		
		c.gridwidth = GridBagConstraints.REMAINDER; //end row

		JTextArea jdbctip = new JTextArea(
				"hCoURL̐ݒ@̓RRQlɂȂ܂B"+
				"http://wiki.paulownia.jp/java/jdbc");
		jdbctip.setForeground(java.awt.Color.BLUE);
		jdbctip.setEditable(false);
		jdbctip.setOpaque(false);
		SxUtilities.addPopupMenuMouseListener(jdbctip);
		gridbag.setConstraints(jdbctip, c);
		panel.add(jdbctip);

		gridbag.setConstraints(isShow, c);
		panel.add(isShow);

		gridbag.setConstraints(rollbackBeforeClose, c);
		panel.add(rollbackBeforeClose);

		gridbag.setConstraints(rollbackAfterQuery, c);
		panel.add(rollbackAfterQuery);

		c.gridwidth = 1;
		label = new JLabel("f[^x[Xi(P)");
		label.setDisplayedMnemonic('P');
		label.setLabelFor(productName);
		gridbag.setConstraints(label, c);
		panel.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(productName, c);
		panel.add(productName);

		return panel;
	}
	private JPanel createExtTab() {
		JPanel panel = new JPanel();
		panel.setBorder(new EmptyBorder(10, 10, 10, 10));
		GridBagLayout gridbag = new GridBagLayout();
		panel.setLayout(gridbag);
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.insets = new Insets(4,8,4,8);

		SxUtilities.addPopupMenuMouseListener(highlightFile);
		highlightFile.setColumns(40); 
        highlightFile.setToolTipText(
        		"\t@Cw肵܂B\n"+
        		"ڂ SampleHighlight.xml QƁB");
        hideOracleBinTable.setToolTipText(
        		"<html>IN10gȍ~ADropꂽe[u͂ɂ͍폜ꂸɁATCNrƂ"+
        		" <font color=\"BLUE\">BIN$KGWUZUW7RLaF/azn7fs5Nw==$0</font>"+
        		"݂ȖOɕςāA邱Ƃł܂B<br>"+
        		"WindowsȂǂ̃S~݂ȊłB<br>"+
        		"Ȃ݂ɁAꗗɂ́A<font color=\"BLUE\">show recyclebin</font><br>"+
        		"ɂ́A <font color=\"BLUE\">flashback table \"BIN$KGWUZUW7RLaF/azn7fs5Nw==$0\" to before drop;</font><br>"+
        		"Sɏɂ́A <font color=\"BLUE\">purge user_recyclebin;</font> łB</html>");
        new DropTarget(highlightFile, DnDConstants.ACTION_COPY_OR_MOVE, new HighlightDropListener(), true);

        
		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		JLabel label = new JLabel("<html><font color=\"blue\">ȉ̐ݒ͕K{ł͂܂BftHĝ܂܂łgpł܂B</font></html>");
		gridbag.setConstraints(label, c);
		panel.add(label);
		
		c.gridwidth = 1;
		label = new JLabel("\(H)");
		label.setDisplayedMnemonic('H');
		label.setLabelFor(highlightFile);
		gridbag.setConstraints(label, c);
		panel.add(label);
		
		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(highlightFile, c);
		panel.add(highlightFile);
		
		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(useOracleTableComments, c);
		panel.add(useOracleTableComments);

		gridbag.setConstraints(useOracleColumnComments, c);
		panel.add(useOracleColumnComments);
		
		gridbag.setConstraints(hideOracleBinTable, c);
		panel.add(hideOracleBinTable);

		return panel;
	}
	private JPanel createSqlFormatterTab() {
		JPanel panel = new JPanel(new BorderLayout());
		GridBagLayout gridbag = new GridBagLayout();
		panel.setLayout(gridbag);
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.insets = new Insets(4,8,4,8);
		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		
		keywordCase[0] = new JRadioButton("Ȃ");
		keywordCase[1] = new JRadioButton("啶ɂ");
		keywordCase[2] = new JRadioButton("ɂ");
		Box box = Box.createHorizontalBox();
		box.add(keywordCase[0]);
		box.add(keywordCase[1]);
		box.add(keywordCase[2]);
		box.setBorder(new TitledBorder("L[[h̕ϊK"));
		ButtonGroup group = new ButtonGroup();
		group.add(keywordCase[0]);
		group.add(keywordCase[1]);
		group.add(keywordCase[2]);
		gridbag.setConstraints(box, c);
		panel.add(box);
		
		SxUtilities.addPopupMenuMouseListener(functionNames);
		functionNames.setFont(AsanDatabaseBrowser.theApp.doc.getFont());
		functionNames.setToolTipText("<html>f[^x[Xg֐B<br>"+
				"J}؂ATAB؂A܂̓Xy[Xŋ؂ĂB<br>"+
				"擪Z~R̍s͖܂B</html>");
		JScrollPane pane = new JScrollPane(functionNames);
		String title = "֐(SUBSTRȂ)";
		pane.setBorder(new CompoundBorder(new TitledBorder(title), pane.getBorder()));
		panel.add(pane);
		gridbag.setConstraints(pane, c);
		return panel;
	}
	public int getSelectedKeywordCase() {
		for (int i=0; i<keywordCase.length; i++) {
			if (keywordCase[i].isSelected()) {
				return i;
			}
		}
		return BlancoSqlRule.KEYWORD_NONE;	// ǂIĂȂƂAftHglɂB
	}
	public void setDatabase(VvDatabase db) {
		assert db != null;
		// {
		name.setText(db.name);
		name.selectAll();
		driver.getEditor().setItem(db.driverName);
		//driver.getEditor().selectAll();
		url.getEditor().setItem(db.url);
		//url.getEditor().selectAll();
		user.setText(db.user);
		user.selectAll();
		pass.setText(db.password);
		pass.selectAll();
		isShow.setSelected(db.isShowLoginDialog);
		rollbackBeforeClose.setSelected(db.rollbackBeforeClose);
		rollbackAfterQuery.setSelected(db.rollbackAfterQuery);
		String text = "";
		for (int i=0; i<db.jarnames.size(); i++) {
			String name = (String) db.jarnames.get(i);
			text += name + "\n";
		}
		classpaths.setText(text);
		// g
		productName.setSelectedItem(db.productName);
		System.out.println(productName);
		highlightFile.setText(db.highlightFilename);
		useOracleTableComments.setSelected(db.useOracleTableComments);
		useOracleColumnComments.setSelected(db.useOracleColumnComments);
		hideOracleBinTable.setSelected(db.hideOracleBinTable);
		// SQL`
		if (0 <= db.keywordCase && db.keywordCase < keywordCase.length) {
			keywordCase[db.keywordCase].setSelected(true);
		}
		functionNames.setText(db.functionNames);
	}
	public VvDatabase getDatabase() {
		ArrayList zipnames = new ArrayList();
		String paths = classpaths.getText();
		StringTokenizer st = new StringTokenizer(paths, "\n");
		while (st.hasMoreTokens()) {
			String name = st.nextToken();
			//System.out.println("name="+name);
			zipnames.add(name);
		}
		String fname = highlightFile.getText();
		System.out.println("fname="+fname);
		System.out.println("driver="+driver.getSelectedItem());
		System.out.println("url="+url.getSelectedItem());
		ComboBoxEditor editor = driver.getEditor();
		System.out.println("eidtor="+editor.getItem()+" class="+editor.getEditorComponent().getClass());
		return new VvDatabase(
			name.getText(),
			(String) driver.getEditor().getItem(),
			(String) url.getEditor().getItem(),
			user.getText(),
			new String(pass.getPassword()),
			zipnames,
			(String) productName.getSelectedItem(),
			fname,
			isShow.isSelected(),
			rollbackBeforeClose.isSelected(),
			rollbackAfterQuery.isSelected(),
			useOracleTableComments.isSelected(),
			useOracleColumnComments.isSelected(),
			hideOracleBinTable.isSelected(),
			getSelectedKeywordCase(),
			functionNames.getText()
			);
	}
	public static int show(final JFrame frame, VvDatabase db) {
		final DatabaseDialog chooser = new DatabaseDialog();
		chooser.setDatabase(db);
		SxOptionPane pane = new SxOptionPane(frame, "f[^x[X̃vpeB",
				SxOptionPane.PLAIN_MESSAGE, SxOptionPane.OK_CANCEL_OPTION);
		pane.getContentPane().add(chooser, BorderLayout.CENTER);
		JButton button = pane.getButton("OK");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent event) {
				if (chooser.name.getText().length() == 0) {
					chooser.name.requestFocus();
					SxMessageBox.show(frame, "f[^x[X̃vpeB", "O͕K{łB");
					return;
				}
				String driver = (String) chooser.driver.getEditor().getItem();
				if (driver.length() == 0) {
					chooser.driver.requestFocus();
					SxMessageBox.show(frame, "f[^x[X̃vpeB", "hCo͕K{łB");
					return;
				}
				String url = (String) chooser.url.getEditor().getItem();
				if (url.length() == 0) {
					chooser.url.requestFocus();
					SxMessageBox.show(frame, "f[^x[X̃vpeB", "URL͕K{łB");
					return;
				}
			}
		});
		pane.pack();
		pane.setLocationRelativeTo(frame);
		pane.setVisible(true);
		int rc = pane.getReturnValue();
		// ߂lԂB
		if (rc == SxOptionPane.OK) {
			db.copyFrom(chooser.getDatabase());
		}
        return rc;
	}

    private class ClassPathDropListener implements DropTargetListener {
    	
        /** hbOꂽ̂ĂB*/
        public void dragEnter(DropTargetDragEvent e) {
            // {́ADataFlavorɂ󂯕t邩ǂf悢
            e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);	// 󂯓
        }

        public void dragExit(DropTargetEvent e) {}
        public void dragOver(DropTargetDragEvent e) {}
        public void dropActionChanged(DropTargetDragEvent e) {}

        /** hbvꂽBTransferablef[^擾B*/
        public void drop(DropTargetDropEvent e) {
    		// t@CXgT|[gĂ邩H
    		if (! e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) return;
    		// t@CXg擾B
    		List files = null;
            e.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
            Transferable t = e.getTransferable();
            try {
    			files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
    			for(Iterator ite=files.iterator(); ite.hasNext(); ) {
    				Object obj = ite.next();
    				System.out.println(" NX="+obj.getClass()+" "+obj);
    			}
    			e.dropComplete(true);
    		}
    		catch (Exception ex) {
    			ex.printStackTrace();
    			e.dropComplete(false);
    			return;
    		}
    		// t@CXgǉB
    		for (int i=0; i<files.size(); i++) {
    			File file = (File) files.get(i);
        		classpaths.append(file.getAbsolutePath()+"\n");
    		}
        }
    }
    private class HighlightDropListener implements DropTargetListener {
    	
        /** hbOꂽ̂ĂB*/
        public void dragEnter(DropTargetDragEvent e) {
            // {́ADataFlavorɂ󂯕t邩ǂf悢
            e.acceptDrag(DnDConstants.ACTION_COPY_OR_MOVE);	// 󂯓
        }

        public void dragExit(DropTargetEvent e) {}
        public void dragOver(DropTargetDragEvent e) {}
        public void dropActionChanged(DropTargetDragEvent e) {}

        /** hbvꂽBTransferablef[^擾B*/
        public void drop(DropTargetDropEvent e) {
    		// t@CXgT|[gĂ邩H
    		if (! e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) return;
    		// t@CXg擾B
    		List files = null;
            e.acceptDrop(DnDConstants.ACTION_COPY_OR_MOVE);
            Transferable t = e.getTransferable();
            try {
    			files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
    			for(Iterator ite=files.iterator(); ite.hasNext(); ) {
    				Object obj = ite.next();
    				System.out.println(" NX="+obj.getClass()+" "+obj);
    			}
    			e.dropComplete(true);
    		}
    		catch (Exception ex) {
    			ex.printStackTrace();
    			e.dropComplete(false);
    			return;
    		}
    		// t@CXgǉB
    		for (int i=0; i<files.size(); i++) {
    			File file = (File) files.get(i);
        		highlightFile.setText(file.getAbsolutePath());
        		break;
    		}
        }
    }

}


