/*
 * 쐬: 2007/07/17
 */
package asandatabasebrowser.view;

import java.awt.BorderLayout;
import java.awt.Image;
import java.util.ArrayList;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

import asandatabasebrowser.model.DbData;

import net.sourceforge.swingx.SxTextUtilities;

public class DbDatabaseDefinitionFrame extends JFrame {

	public DbDatabaseDefinitionFrame(String title, Image icon, ArrayList list) {
		assert title != null;
		assert list != null;
		
		setIconImage(icon);
		JTabbedPane tabpane = new JTabbedPane(JTabbedPane.TOP, JTabbedPane.WRAP_TAB_LAYOUT);
		
		// ^u
		for (int i=0; i<list.size(); i++) {
			Object[] objs = (Object[]) list.get(i);
			String tabtitle = (String) objs[0];
			if (objs[1] instanceof DbData) {
				DbData data = (DbData) objs[1];
				DbResultSetPanel tableView = new DbResultSetPanel(data);
				tabpane.addTab(tabtitle, tableView);
			} else {
				Exception e = (Exception) objs[1];
				JTextArea area = new JTextArea(SxTextUtilities.getStackTraceString(e));
				tabpane.addTab(tabtitle, new JScrollPane(area));
			}
		}

		this.getContentPane().setLayout(new BorderLayout());
		getContentPane().add(tabpane, BorderLayout.CENTER);

		// \B
		setTitle(title);
		setSize(640, 480);
		setVisible(true);
	}

}
