package asandatabasebrowser.view;

import javax.swing.*;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.*;
import asandatabasebrowser.action.*;
import asandatabasebrowser.model.*;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlTokenConstants;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;


import java.awt.BorderLayout;
import java.awt.event.*;
import java.awt.Cursor;
import java.util.ArrayList;


/**
 * st[
 * <<view>>
 */
public class DbExecuteFrame extends JFrame {
	public VvDatabase db;
	JTabbedTextArea textarea;
	
    public DbExecuteFrame(VvDatabase db) {
    	this.db = db;
    	setTitle(db.name+"(autoCommit=false)");
    	setIconImage(Global.getImage("/resources/UpdateView.png"));
    	String text = 
    		"-- UPDATE e[u SET J1 = l1 {, J2 = l2 } [ WHERE  ]\n"+
    		"-- INSERT INTO e[u [ ( J1, ... ) ] VALUES ( l1, ...)\n"+
    		"-- DELETE FROM e[u [ WHERE  ]";
    	text = text.toLowerCase();
    	textarea = new JTabbedTextArea(db, new SqlKeyListener());
    	textarea.addTextArea(text);
        // r[쐬BCAEgB
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(textarea, BorderLayout.CENTER);
        // c[o[
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
        toolbar.add(new ExecuteUpdateAction(this));
        toolbar.addSeparator();
        toolbar.add(new ExecuteCommitAction(this, db, "commit", null));
        toolbar.add(new ExecuteCommitAction(this, db, "rollback", null));
        toolbar.addSeparator();
		toolbar.add(new TabAddAction(textarea));
		toolbar.add(new TabRemoveAction(textarea));
        this.getContentPane().add(toolbar, BorderLayout.NORTH);

        // \B
        setSize(640, 360);
        setVisible(true);
    }

    /**
     * SQLs܂B
     * IĂ΂SQLōXV܂B
     * IĂȂ΂ׂĂSQLōXV܂B
     */
    public void executeUpdate() {
    	String text = textarea.getSelectedText();
    	if (text != null) text = text.trim();
    	if (text == null || text.length() == 0) {
    		text = textarea.getCurrentText();
        	if (text != null) text = text.trim();
    	}
    	if (text == null) return;
		// SQL͂A傲ƂɂԂ؂B
		ArrayList tokens = null;
		try {
			tokens = new BlancoSqlParser().parse(text);
		} catch (RuntimeException e) {
            AsanDatabaseBrowser.theApp.showMessage(textarea, 
            		"SQLsƎv܂",
            		e, SxOptionPane.ERROR_MESSAGE);
			return;	// sSSQLƋN肦B
		}    	
    	// Z~RSQL𕪊B
		ArrayList sqlList = new ArrayList();
		StringBuffer sb = new StringBuffer();
		for (int i=0; i<tokens.size(); i++) {
			BlancoSqlToken t = (BlancoSqlToken) tokens.get(i);
			switch (t.getType()) {
			case BlancoSqlTokenConstants.SPACE:
				sb.append(" ");
				break;
			case BlancoSqlTokenConstants.SYMBOL:
				if (t.getString().equals(";")) {
					sqlList.add(sb.toString());
					sb = new StringBuffer();
				} else {
					sb.append(t.getString().trim());
				}
				break;
			case BlancoSqlTokenConstants.KEYWORD:
			case BlancoSqlTokenConstants.NAME:
			case BlancoSqlTokenConstants.VALUE:
				sb.append(t.getString());
				break;
			case BlancoSqlTokenConstants.COMMENT:
				// Ȃ
				break;
			case BlancoSqlTokenConstants.END:
				sqlList.add(sb.toString());
				sb = new StringBuffer();
				break;
			case BlancoSqlTokenConstants.UNKNOWN:
			default:
				assert false: t.getType();
			}
		}
		if (sb.toString().trim().length() > 0) {
			sqlList.add(sb.toString().trim());
		}
    	// SQLs.
        setCursor(new Cursor(Cursor.WAIT_CURSOR));
        try {
        	int records = 0;
        	for (int i=0; i<sqlList.size(); i++) {
        		String sql = (String) sqlList.get(i);
        		records += db.executeUpdate(sql);
        	}
           	AsanDatabaseBrowser.theApp.showMessage(textarea, 
           			"XV܂ "+records+" ", 
           			null, SxOptionPane.INFORMATION_MESSAGE);
        } catch (Exception e) {
            AsanDatabaseBrowser.theApp.showMessage(textarea, "G[܂", e, SxOptionPane.ERROR_MESSAGE);
        }
        setCursor(Cursor.getDefaultCursor());
    }

    /** Shift+EnterꂽSQLs܂B*/
    class SqlKeyListener extends KeyAdapter {
        public void keyReleased(KeyEvent e) {
            //System.out.println(e);
            if (e.getKeyCode() == KeyEvent.VK_ENTER && e.isShiftDown()) {
                executeUpdate();
            }
        }
    }

}


