package asandatabasebrowser.view;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;

import net.sourceforge.swingx.SxOptionPane;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.ColumnInfo;
import asandatabasebrowser.model.ITableInfo;
import asandatabasebrowser.model.ResultInfo;
import asandatabasebrowser.model.ResultSetInfo;
import asandatabasebrowser.model.TableInfo;
import asandatabasebrowser.model.VvDatabase;


/**
 * vpeB̂悤ɏcɕ\r[.
 * 
 * @author Asan
 */
public class DbRecordView extends RitchTable {
	static final Object NO_RECORD = "NO_RECORD";
	// <<model>>
	/** e[u. null */
	ITableInfo tableInfo = null;
	/** R[h̒l̔z. null */
	private Object[] rec = null;	// PR[h̃f[^
	
	private DefaultTableModel model = new DefaultTableModel();
	private DbColumnNameRenderer columnNameRenderer;
	private DbColumnValueRenderer columnValueRenderer;

	DbRecordView(final VvDatabase db) {
		assert db != null;
		this.setModel(model);
		addMouseListener(new RecordMouseListener());
		this.getTableHeader().setReorderingAllowed(false); // wb_̃hbO͖ 
		this.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
		this.setColumnSelectionAllowed(true);
		this.setRowSelectionAllowed(true);
		model.addColumn("name");
		model.addColumn("value");
		setToolTipText("ꂱ[");
		// _[
		columnNameRenderer = new DbColumnNameRenderer(db);
		columnValueRenderer = new DbColumnValueRenderer();
		this.getColumnModel().getColumn(0).setCellRenderer(columnNameRenderer);
		this.getColumnModel().getColumn(1).setCellRenderer(columnValueRenderer);
	}
	/**
	 * \郌R[hݒ肷.
	 * @param tableInfo	R[ȟ^Ȃǂ̏Bnulls
	 * @param rec		R[h̒l̔zBnull
	 */
	public void setRecord(ITableInfo tableInfo, Object[] rec) {
		assert tableInfo != null;
		this.tableInfo = tableInfo;
		this.rec = rec;
		model.setRowCount(tableInfo.getColumnCount());
		for (int i=0; i<tableInfo.getColumnCount(); i++) {
			String name = tableInfo.getColumnName(i);
			model.setValueAt(name, i, 0);
			model.setValueAt(rec!=null ? rec[i]: NO_RECORD, i, 1);
		}
		//model.fireTableDataChanged();	// TODO:͕KvH
	}
	/** }EXʒũZƂɃc[`bv̕ԂB*/
	public String getToolTipText(MouseEvent e) {
		int col = columnAtPoint(e.getPoint());
		if (col == -1) return null;
		int row = rowAtPoint(e.getPoint());
		if (row == -1) return null;
		//System.out.println("col="+col+" row="+row);
		if (col == 0) {
			if (tableInfo instanceof TableInfo) {
				TableInfo table = (TableInfo) tableInfo;
				ColumnInfo info = table.getColumnInfo(row);
				return table.getDatabase().getToolTipText(table, info);
			}
			else {
				ResultSetInfo table = (ResultSetInfo) tableInfo;
				ResultInfo info = table.getResultInfo(row);
				return table.getDatabase().getToolTipText(info);
			}
		} else {
			if (rec == null) return null;
			Object value = model.getValueAt(row, col);
			if (value == null) return "<html><font color=\"GRAY\">NULL</font></html>";
			return value.toString();
		}
	}
	public boolean 	isCellEditable(int row, int column) {
		 return false;
	}
	/**
	 * J_uNbNAJJB
	 */
	class RecordMouseListener extends MouseAdapter {
		public void mouseClicked(MouseEvent e) {
			//System.out.println(e);
			try {
				// {^_uNbNꂽALargeObject̏ꍇA̓e\B
				if (e.getClickCount()==2 && (e.getModifiers()&MouseEvent.BUTTON1_MASK)!=0) {
					int col = columnAtPoint(e.getPoint());
					if (col == -1) return;
					int row = rowAtPoint(e.getPoint());
					if (row == -1) return;
					//System.out.println("col="+col+" row="+row);
					if (col==1) {
						Object data = getValueAt(row, col);
						//@BLOB/CLOBȂǂ̂ƂAe\B 
						AsanDatabaseBrowser.theApp.openLargeObject(data, tableInfo, rec, row);
					}
				}
			}
			catch (Exception ex) {
				AsanDatabaseBrowser.theApp.showMessage(DbRecordView.this, "G[܂", ex, SxOptionPane.ERROR_MESSAGE);
			}
		}
		public void mouseReleased(MouseEvent e) {
			// |bvAbvj[\B
			if (e.isPopupTrigger()) {
				mousePopup(e);
			}
		}
		public void mousePressed(MouseEvent e) {
			// |bvAbvj[\B
			if (e.isPopupTrigger()) {
				mousePopup(e);
			}
		}
		void mousePopup(MouseEvent e) {
			//System.out.println("Popup!");
			JPopupMenu popup = new JPopupMenu();
			popup.add(new CopyClipboardAction(DbRecordView.this));
			popup.add(new SelectAllAction(DbRecordView.this));
//			if (data.tableInfo instanceof TableInfo) {
//				popup.addSeparator();
//				popup.add(new CreateInsertAction(VerticalViewer.theApp, DbRecordView.this));
//				popup.add(new CreateUpdateAction(VerticalViewer.theApp, DbRecordView.this));
//			}
			popup.show(DbRecordView.this, e.getX(), e.getY());
		}
	}
}


