/*
 * 쐬: 2007/07/17
 */
package asandatabasebrowser.view;

import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import asandatabasebrowser.model.DbData;


/**
 * 
 * 
 * @author Asan
 */
public class DbResultSetPanel extends JSplitPane {
	DbData data;
	DbResultSetView tableView = null;
	DbRecordView recordView = null;
	public DbResultSetPanel(DbData data) {
		super(JSplitPane.HORIZONTAL_SPLIT);
		assert data != null;
		this.data = data;

        // 2̃r[쐬BCAEgB
		tableView = new DbResultSetView();
		tableView.updateData(data);
		recordView = new DbRecordView(data.tableInfo.getDatabase());
		
		this.setLeftComponent(new JScrollPane(tableView));
		this.setRightComponent(new JScrollPane(recordView));
		this.setOneTouchExpandable(true);
		this.setResizeWeight(0.7);
		
		// A
		tableView.getSelectionModel().addListSelectionListener(new TableSelectionListener());
	}


	/** ĕ`悷B 
	public void refresh() {
		((AbstractTableModel) tableView.getModel()).fireTableStructureChanged();
		((AbstractTableModel) recordView.getModel()).fireTableDataChanged();
	}

	/** e[u̍sIꂽƂ */
	class TableSelectionListener implements ListSelectionListener {
		public void valueChanged(ListSelectionEvent e) {
			//System.out.println(e);
			if (e.getValueIsAdjusting()==false) {
				int index = tableView.getSelectionModel().getAnchorSelectionIndex();
				//System.out.println("index="+index);
				if (0 <= index && index < data.getRecordCount()) {
					Object[] rec = data.getRecord(index);
					recordView.setRecord(data.tableInfo, rec);
				}
				else {
					recordView.setRecord(data.tableInfo, null);
				}
			}
		}
	}
}

