package asandatabasebrowser.view;

import java.awt.BorderLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

import asandatabasebrowser.Global;
import asandatabasebrowser.action.ExecuteQueryAction;
import asandatabasebrowser.action.FavoriteSqlAction;
import asandatabasebrowser.action.TabAddAction;
import asandatabasebrowser.action.TabRemoveAction;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.VvDatabase;




/**
 * NG[ʃr[
 * <<view>>
 */
public class DbSqlFrame extends JFrame {
	/** nulls */
	public final VvDatabase db;
	/** null */
	public DbData data = null;
	// view
	DbResultSetView tableView = null;
	DbRecordView recordView = null;
	public JTabbedTextArea textarea;
	ExecuteQueryAction queryAction = new ExecuteQueryAction(this);
	
	public DbSqlFrame(VvDatabase db) throws DbException {
		assert db != null;
		setIconImage(Global.getImage("/resources/SQLView.png"));
		this.db = db;

		// R̃r[쐬BCAEgB
		tableView = new DbResultSetView();
		recordView = new DbRecordView(db);
		textarea = new JTabbedTextArea(db, new SqlKeyListener());
		JSplitPane sp2 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		sp2.setLeftComponent(new JScrollPane(tableView));
		sp2.setRightComponent(new JScrollPane(recordView));
		sp2.setDividerLocation(400);	// 70%
		sp2.setOneTouchExpandable(true);

		JSplitPane sp1 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		sp1.setTopComponent(textarea);
		sp1.setBottomComponent(sp2);
		sp1.setDividerLocation(100);	// 30%
		sp1.setOneTouchExpandable(true);

		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(sp1, BorderLayout.CENTER);
		// c[o[
		JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
		toolbar.add(queryAction);
        toolbar.addSeparator();
		toolbar.add(new TabAddAction(textarea));
		toolbar.add(new TabRemoveAction(textarea));
		if (System.getProperty("debug") != null) {
	        toolbar.addSeparator();
			toolbar.add(new FavoriteSqlAction(this));
		}
		this.getContentPane().add(toolbar, BorderLayout.NORTH);
		// A
		tableView.getSelectionModel().addListSelectionListener(new TableSelectionListener());
		// \B
		setTitle(db.name);
		setSize(640, 480);
		//setVisible(true);
	}
	// TODO:͉ĂȂBrl@
	public void addSqlTab(String sql) {
		textarea.addTextArea(sql);
	}
	public String getCurrentSql() { return textarea.getCurrentText(); }
	public void updateData(DbData data) {
		// J񂪕ςH
		boolean changed = false;
		if ((this.data == null) != (data == null)) {
			changed = true;	// ݂̂null̂Ƃ́AςI
		}
		if (this.data != null && data != null) {
			if (! this.data.tableInfo.equals(data.tableInfo)) {
				changed = true;
			}
		}
		// f[^Zbg
		this.data = data;
		tableView.updateData(data);
		// J񂪕ςƂA
		if (changed) {
			int index = tableView.getSelectionModel().getAnchorSelectionIndex();
			Object[] rec = (index != -1) ? data.getRecord(index) : null;
			recordView.setRecord(data.tableInfo, rec);
		}
		setTitle(db.name+"("+data.getRecordCount()+" records)");
	}

	/** ĕ`悷B */
	public void refresh() {
		((AbstractTableModel) tableView.getModel()).fireTableStructureChanged();
		((AbstractTableModel) recordView.getModel()).fireTableDataChanged();
	}

	/** Shift+EnterꂽSQLs܂B*/
	class SqlKeyListener extends KeyAdapter {
		public void keyReleased(KeyEvent e) {
			//System.out.println(e);
			if (e.getKeyCode() == KeyEvent.VK_ENTER && e.isShiftDown()) {
				queryAction.executeQuery();
			}
		}
	}
	/** e[u̍sIꂽƂ */
	class TableSelectionListener implements ListSelectionListener {
		public void valueChanged(ListSelectionEvent e) {
			//System.out.println(e);
			if (e.getValueIsAdjusting()==false) {
				int index = tableView.getSelectionModel().getAnchorSelectionIndex();
				//System.out.println("index="+index);
				if (0 <= index && index < data.getRecordCount()) {
					Object[] rec = data.getRecord(index);
					recordView.setRecord(data.tableInfo, rec);
				}
				else if (data.getRecordCount() == 0) {
					recordView.setRecord(data.tableInfo, null);
				} else {
					Object[] rec = data.getRecord(0);
					recordView.setRecord(data.tableInfo, rec);
				}
			}
		}
	}
}


