/*
 * 쐬: 2005/09/25
 */
package asandatabasebrowser.view;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

import asandatabasebrowser.Global;
import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.action.ExecuteQueryAction;
import asandatabasebrowser.action.TabAddAction;
import asandatabasebrowser.action.TabRemoveAction;
import asandatabasebrowser.model.DbData;
import asandatabasebrowser.model.DbException;
import asandatabasebrowser.model.TableInfo;

import net.sourceforge.swingx.SxOptionPane;
import net.sourceforge.swingx.SxUtilities;



/**
 * e[ur[
 * <<view>>
 * @deprecated	VerticalVieweřÂr[łB
 */
public class DbTableFrame extends JFrame {
	public final TableInfo tableInfo;
	String defaultSql;
	// view
	DbResultSetView tableView = null;
	DbRecordView recordView = null;
	JTabbedTextArea textarea;
	ExecuteQueryAction refreshAction = new ExecuteQueryAction(this);
	public DbTableFrame(TableInfo tableInfo) throws DbException {
		assert tableInfo!=null;
		this.tableInfo = tableInfo;
		tableInfo.updateColumnInfoList();
        setIconImage(Global.getImage("/resources/TableView.png"));
 
        defaultSql = "select * from "+tableInfo.getSqlTableName();
        DbData data = tableInfo.db.queryTable(tableInfo, defaultSql, true);
         // R̃r[쐬BCAEgB
       	tableView = new DbResultSetView();
       	tableView.updateData(data);
		recordView = new DbRecordView(tableInfo.db);
		//recordView.setRecord(tableInfo, data.rec)
		textarea = new JTabbedTextArea(tableInfo.db, new SqlKeyListener());
		textarea.addTextArea("-- whereȍ~LqĂ");
		JSplitPane sp2 = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		sp2.setLeftComponent(new JScrollPane(tableView));
		sp2.setRightComponent(new JScrollPane(recordView));
		sp2.setOneTouchExpandable(true);
		sp2.setResizeWeight(0.7);
		
		JSplitPane sp1 = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		getContentPane().setLayout(new BorderLayout());
		JPanel top = new JPanel(new BorderLayout());
		// SELECT̑O쐬BI\ɂ邽߁AJLabelł͂ȂJTextFieldɁB
		JTextField label = new JTextField(defaultSql);
		label.setEditable(false);
		label.setBorder(null);
		SxUtilities.addPopupMenuMouseListener(label);
		label.setFont(AsanDatabaseBrowser.theApp.doc.getFont());
		
		top.add(label, BorderLayout.NORTH);
		top.add(textarea, BorderLayout.CENTER);
		sp1.setTopComponent(top);
		sp1.setBottomComponent(sp2);
		sp1.setOneTouchExpandable(true);
		sp1.setResizeWeight(0.25);

		this.getContentPane().setLayout(new BorderLayout());
		getContentPane().add(sp1, BorderLayout.CENTER);
		// c[o[
		JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setRollover(true);
		toolbar.add(refreshAction);
        toolbar.addSeparator();
		toolbar.add(new OpenSqlFrameAction(AsanDatabaseBrowser.theApp));
        toolbar.addSeparator();
		toolbar.add(new TabAddAction(textarea));
		toolbar.add(new TabRemoveAction(textarea));
		this.getContentPane().add(toolbar, BorderLayout.NORTH);
		// A
		tableView.getSelectionModel().addListSelectionListener(new TableSelectionListener());
		// \B
		//setTitle(tableInfo.getTitleName()+" ("+data.getRecordCount()+" records)");
		setTitle(tableInfo.getSqlTableName()+" ("+data.getRecordCount()+" records)");
		setSize(640, 480);
		//setVisible(true);
	}
	public String getSql() {
		return defaultSql + " " + textarea.getCurrentText();
	}
	public void setData(DbData data) {
		tableView.updateData(data);
		((AbstractTableModel) recordView.getModel()).fireTableDataChanged();
		setTitle(tableInfo.getSqlTableName()+" ("+data.getRecordCount()+" records)");
	}

	/** ĕ`悷B */
	public void refresh() {
		((AbstractTableModel) tableView.getModel()).fireTableStructureChanged();
		((AbstractTableModel) recordView.getModel()).fireTableDataChanged();
	}
	
	/** Shift+EnterꂽSQLs܂B*/
	class SqlKeyListener extends KeyAdapter {
		public void keyReleased(KeyEvent e) {
			//System.out.println(e);
			if (e.getKeyCode() == KeyEvent.VK_ENTER && e.isShiftDown()) {
				refreshAction.executeQuery();
			}
		}
	}
	/** e[u̍sIꂽƂ */
	class TableSelectionListener implements ListSelectionListener {
		public void valueChanged(ListSelectionEvent e) {
			//System.out.println(e);
			if (e.getValueIsAdjusting()==false) {
				DbData data = tableView.data;
				int index = tableView.getSelectionModel().getAnchorSelectionIndex();
				//System.out.println("index="+index);
				if (0 <= index && index < data.getRecordCount()) {
					Object[] rec = data.getRecord(index);
					recordView.setRecord(data.tableInfo, rec);
				}
				else {
					recordView.setRecord(data.tableInfo, null);
				}
			}
		}
	}
	class OpenSqlFrameAction extends AbstractAction {
		AsanDatabaseBrowser tools;
		public OpenSqlFrameAction(AsanDatabaseBrowser tools) {
			super("SQLEBhE");
			putValue(SHORT_DESCRIPTION, "SQLEBhEJ܂");
			putValue(LONG_DESCRIPTION, "SQLEBhEJ܂");
			putValue(SMALL_ICON, Global.getImageIcon("/resources/SQLView.png"));
			this.tools = tools;
		}
		public void actionPerformed(ActionEvent ev) {
			try {
				String sql = defaultSql + " " + textarea.getCurrentText();
				tools.openSqlFrame(tableInfo.db, sql);
			} catch (Exception e) {
				tools.showMessage(DbTableFrame.this, "e[uJƂł܂", 
						e, SxOptionPane.ERROR_MESSAGE);
			}
		}
	}
}


