package asandatabasebrowser.view;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.action.SaveBinaryDataAction;

import net.sourceforge.swingx.SxUtilities;



public class DbTextFrame extends JFrame {
	JTextArea textarea;
	JButton closeButton;
	/** oCi̎̓eieLXgɂnullj */
	byte[] content = null;
	SaveBinaryDataAction saveBinaryDataAction;
	
	public DbTextFrame(String title, boolean editable) {
		super(title);
		textarea = new JTextArea();
		textarea.setEditable(editable);
		textarea.setFont(AsanDatabaseBrowser.theApp.doc.getFont());
		SxUtilities.addPopupMenuMouseListener(textarea);
		saveBinaryDataAction = new SaveBinaryDataAction(AsanDatabaseBrowser.theApp, this);
		
		JToolBar toolbar = new JToolBar();
		toolbar.add(saveBinaryDataAction);
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(toolbar, BorderLayout.NORTH);
		this.getContentPane().add(new JScrollPane(textarea),
				BorderLayout.CENTER);
		JPanel buttonPanel = new JPanel();
		closeButton = new JButton("");
		closeButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				DbTextFrame.this.dispose();
			}
		});
		buttonPanel.add(closeButton);
		getRootPane().setDefaultButton(closeButton);
		this.getContentPane().add(buttonPanel, BorderLayout.SOUTH);
		this.setSize(640, 600);
		this.setVisible(true);
	}
	
	public void setText(String text) {
		textarea.setText(text);
		textarea.setCaretPosition(0);
	}
	public String getText() {
		return textarea.getText();
	}
	public void setContent(byte[] content) {
		this.content = content;
	}
	public byte[] getContent() {
		return content;
	}
	
}
