/*
 * 쐬: 2005/09/25
 */
package asandatabasebrowser.view;

import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

import asandatabasebrowser.AsanDatabaseBrowser;
import asandatabasebrowser.model.VvDatabase;

import net.sourceforge.swingx.SxOptionPane;


/**
 * ^uteLXgGA. 
 * ^u̐OłB
 */
public class JTabbedTextArea extends JTabbedPane {
	int count = 0;
    VvDatabase db;
	KeyListener keyListener;
    
	JTabbedTextArea(VvDatabase db, KeyListener keyListener) {
		super(JTabbedPane.TOP, JTabbedPane.SCROLL_TAB_LAYOUT);
		this.db = db;
		this.keyListener = keyListener;
		this.addMouseListener(new TabMouseListener());
	}

	public String getCurrentText() {
		if (this.getTabCount() == 0) return null;
		JScrollPane scroll = (JScrollPane) this.getSelectedComponent();  
		JTextPane textarea = (JTextPane) scroll.getViewport().getView();  
		return textarea.getText();
	}
	String getSelectedText() {
		JScrollPane scroll = (JScrollPane) this.getSelectedComponent();  
		JTextPane textarea = (JTextPane) scroll.getViewport().getView();  
		return textarea.getSelectedText();
	}
	public String getText(int index) {
		JScrollPane scroll = (JScrollPane)this.getComponentAt(index);
		JTextPane area = (JTextPane) scroll.getViewport().getView();
		return area.getText();
	}
	public void addTextArea(String sql) {
		SqlEditor editor = new SqlEditor(sql, db.getBlancoSqlRule(), AsanDatabaseBrowser.theApp.doc.getFont());
		// TODO:\\ɂȂĂAShift+EnterȂȂĂB܂AZ~RĂs\ɂB
		if (System.getProperty("debug") != null) {
			editor.setToolTipText("<html>Shift+EnterSQLs܂B<br>ɃZ~R͕svłB</html>");
		}
		editor.addKeyListener(keyListener);
		
		this.addTab("SQL"+count, new JScrollPane(editor));
		this.setSelectedIndex(getTabCount()-1);
		count++;
	}

	public void removeTextArea() {
		if (getTabCount() <= 1) return;
		removeTabAt(getSelectedIndex());  
	}

    /** _uNbNƃ^u̕ҏWsB */
    class TabMouseListener extends MouseAdapter {
    	public void mouseClicked(MouseEvent e) {
    		System.out.println(e);
    		// {^_uNbNƂ
    		if (e.getButton() == MouseEvent.BUTTON1 && e.getClickCount() == 2) {
        		// ǂ̃^uIꂽH
    			int index = indexAtLocation(e.getX(), e.getY());
    			if (index == -1) return;
    			// ^u̖OҏW
    			JTextField field = new JTextField(getTitleAt(index), 10);
    			int rc = SxOptionPane.showMessageDialog(
    					JTabbedTextArea.this,
    					field, "^u̕ҏW",
    					SxOptionPane.OK_CANCEL_OPTION,
    					SxOptionPane.PLAIN_MESSAGE, null);
    			// OK{^ȊOȂ牽ȂB
    			if (rc != SxOptionPane.OK) return;
    			// ҏWꂽ󕶎ȂG[
    			String text = field.getText();
				if (text.length() == 0) {
					SxOptionPane.showMessageDialog(
	    					JTabbedTextArea.this,
	    					"1ȏ͂̕ĂB",
	    					"^u̕ҏW",
	    					SxOptionPane.OK_ONLY_OPTION,
	    					SxOptionPane.ERROR_MESSAGE, null);
					return;
				}
    			// w肳ꂽ^ũ^CgύX
				setTitleAt(index, text);
    		}
    	}
    }
}
