/*
 * 쐬: 2005/11/06
 */
package asandatabasebrowser.view;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

import net.sourceforge.swingx.SxUtilities;


/**
 * IvV
 * ős
 * ؒfɃ[obN邩H
 * e[u̐K\iIÑS~e[u\Ȃ߁j
 * tHg tHg͌Œł悢̂Ń{cTCŶ݂ύX\ɂB
 * @author Asan
 */
public class OptionDialog extends JDialog {
	private JTextField maxRecordText = new JTextField();
//	private JTextField ignoreTableNamePattern = new JTextField();
//	private FontChooser fontChooser = new FontChooser(true, true, true);
	private JSpinner fontSpinner = new JSpinner(new SpinnerNumberModel(16, 8, 100, 1));
	private JButton okButton = new JButton("OK");
	private JButton cancelButton = new JButton("LZ");
	int returnValue = JOptionPane.CANCEL_OPTION;
	
	public OptionDialog(Frame owner) {
		super(owner, "IvV", true);
		JPanel panel = new JPanel();
		GridBagLayout gridbag = new GridBagLayout();
		panel.setLayout(gridbag);
		GridBagConstraints c = new GridBagConstraints();
		c.fill = GridBagConstraints.BOTH;
		c.weightx = 1.0;
		c.insets = new Insets(4,4,4,4);

		//maxRecordText.setToolTipText("???");
//		ignoreTableNamePattern.setToolTipText(
//				"<html>INȂǂ̃S~e[u\ȂƂɎw肵܂B<br>"+
//				"󕶎̂Ƃׂ͂Ẵe[u\܂B<br>"+
//				"Ȃ݂ɃIÑS~e[ȕꍇ͈ȉ̂悤Ɏw肵܂B<br>"+
//				"^BIN\\$.*==\\$0$</html>");
		SxUtilities.addPopupMenuMouseListener(maxRecordText);
//		SxUtilities.addPopupMenuMouseListener(ignoreTableNamePattern);
		
		JLabel label = new JLabel("ő僌R[h(M)");
		label.setDisplayedMnemonic('M');
		label.setLabelFor(maxRecordText);
		gridbag.setConstraints(label, c);
		panel.add(label);

		c.gridwidth = GridBagConstraints.REMAINDER; //end row
		gridbag.setConstraints(maxRecordText, c);
		panel.add(maxRecordText);

//		label = new JLabel("\Ȃe[u̐K\(I)");
//		label.setDisplayedMnemonic('I');
//		label.setLabelFor(ignoreTableNamePattern);
//		gridbag.setConstraints(label, c);
//		panel.add(label);

//		c.gridwidth = GridBagConstraints.REMAINDER; //end row
//		gridbag.setConstraints(ignoreTableNamePattern, c);
//		panel.add(ignoreTableNamePattern);

		
		label = new JLabel("tHgTCY(F)");
		label.setDisplayedMnemonic('F');
		label.setLabelFor(fontSpinner);
		c.gridwidth = GridBagConstraints.RELATIVE;
		gridbag.setConstraints(label, c);
		panel.add(label);

		fontSpinner.setToolTipText("̋NŔf܂");
		gridbag.setConstraints(fontSpinner, c);
		panel.add(fontSpinner);
//		fontChooser.setBorder(new TitledBorder("tHg"));
//		gridbag.setConstraints(fontChooser, c);
//		panel.add(fontChooser);
		
		getContentPane().setLayout(new BorderLayout());
		JPanel button_panel = new JPanel();
		button_panel.add(okButton);
		button_panel.add(cancelButton);
		getRootPane().setDefaultButton(okButton);
		okButton.addActionListener(new OkListener());
		cancelButton.addActionListener(new CancelListener());
		getContentPane().add(panel, BorderLayout.CENTER);
		getContentPane().add(button_panel, BorderLayout.SOUTH);
		((JPanel)getContentPane()).setBorder(new EmptyBorder(10, 10, 10, 10));
	}
	
	public int getMaxRecord() {
		try {
			int maxRecord = Integer.parseInt(maxRecordText.getText());
			return maxRecord;
		}
		catch(NumberFormatException e) {
			return 1000;
		}
	}
	public void setMaxRecored(int maxrecord) {
		maxRecordText.setText(""+maxrecord);
	}

//	public void setIgnoreTableNamePattern(String pattern) {
//		ignoreTableNamePattern.setText(pattern != null ? pattern : "");
//	}
//	public String getIgnoreTableNamePattern() {
//		String pattern = ignoreTableNamePattern.getText();
//		if (pattern.trim().length() == 0) return null;
//		return pattern;
//	}
	public void setFontSize(int size) {
		fontSpinner.setValue(new Integer(size));
	}
	public int getFontSize() {
		return ((Integer) fontSpinner.getValue()).intValue();
	}
//	public void setChoosedFont(Font font) {
//		fontChooser.setChoosedFont(font);
//	}
//	public Font getChoosedFont() {
//		return fontChooser.getChoosedFont();
//	}
	public int getReturnValue() { return returnValue; }
	class OkListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			returnValue = JOptionPane.OK_OPTION;
			dispose();
		}
	}
	class CancelListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			returnValue = JOptionPane.CANCEL_OPTION;
			dispose();
		}
	}
}
