package asandatabasebrowser.view;

import java.awt.Event;
import java.awt.event.*;
import javax.swing.*;

import asandatabasebrowser.Global;


import java.awt.Toolkit;
import java.awt.datatransfer.*;

/**
 * ʏJTableɁASI(Control-A)ƃNbv{[hւ̃Rs[(Control-C)ł悤ɂ.
 * 
 * @author Asan
 */
public class RitchTable extends JTable {


	public RitchTable() {
		init();
	}
	/** 2 z rowData ̒l\ JTable A columnNames ō\z܂B */
	public RitchTable(Object[][] rowData, Object[] columnNames) {
		super(rowData, columnNames);
		init();
	}
	void init() {
//		getTableHeader().addMouseListener(new DbTableMouseListener());
		// ANV}bvƃCvbg}bvo^
		ActionMap actionmap = new ActionMap();
		actionmap.put("copy", new CopyClipboardAction(this));
		actionmap.put("select-all", new SelectAllAction(this));
		SwingUtilities.replaceUIActionMap(this, actionmap);
		InputMap inputmap = new InputMap();
		inputmap.put(KeyStroke.getKeyStroke('C', Event.CTRL_MASK), "copy");   // Ctrl+C
		inputmap.put(KeyStroke.getKeyStroke('A', Event.CTRL_MASK), "select-all");   // Ctrl+A
		SwingUtilities.replaceUIInputMap(this, JComponent.WHEN_FOCUSED, inputmap);
	}
/*
JTable() {
          ftHgf[^fAftHg񃂃fAуftHgIfŏAftHg JTable \z܂B 
JTable(int numRows, int numColumns) 
          DefaultTableModel gāÃZ numRows  numColumns  JTable \z܂B 
JTable(TableModel dm) 
          f[^f dmAftHg񃂃fAуftHgIfŏ JTable \z܂B 
JTable(TableModel dm, TableColumnModel cm) 
          f[^f dmA񃂃f cmAуftHgIfŏ JTable \z܂B 
JTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) 
          f[^f dmA񃂃f cmAёIf sm ŏ JTable \z܂B 
JTable(Vector rowData, Vector columnNames)  
*/

	class CopyClipboardAction extends AbstractAction {
		JTable table;
		public CopyClipboardAction(JTable table) {
			super("Rs[(C)");
			putValue(SHORT_DESCRIPTION, "Rs[");
			putValue(LONG_DESCRIPTION, "Rs[");
			putValue(MNEMONIC_KEY, new Integer('C'));
			putValue(SMALL_ICON, Global.getImageIcon("/resources/eclipse_EditCopy.png"));
			this.table = table;
		}

		public void actionPerformed(ActionEvent ev) {
			System.out.println("CopyClipboardAction");
			String data = "";
			int[] cols = table.getSelectedColumns();
			int[] rows = table.getSelectedRows();
			for (int row=0; row<rows.length; row++) {
				String line = null;
				for (int col=0; col<cols.length; col++) {
					if (table.isCellSelected(rows[row], cols[col])) {
						Object val = table.getValueAt(rows[row], cols[col]);
						if (line==null) line = ""+val; else line += "\t" + val;
System.out.println(val);
					}
				}
				data += line + "\n";
			}
			// Nbv{[hɃRs[
			StringSelection ss = new StringSelection(data);
			Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss,ss);
		}
	}

	public class SelectAllAction extends AbstractAction {
		JTable table;
		public SelectAllAction(JTable table) {
			super("ׂĂI(A)");
			putValue(MNEMONIC_KEY, new Integer('A'));
			putValue(SHORT_DESCRIPTION, "SI");
			putValue(LONG_DESCRIPTION, "SI");
			this.table = table;
		}

		public void actionPerformed(ActionEvent ev) {
			System.out.println("SelectAllAction");
			table.selectAll();
		}
	}


}


