/*
 * 쐬: 2007/11/09
 */
package asandatabasebrowser.view;

import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoManager;

import net.sourceforge.swingx.SxAction;
import net.sourceforge.swingx.SxMouseAdapter;
import net.sourceforge.swingx.SxTextUtilities;
import net.sourceforge.swingx.SxUtilities;
import asandatabasebrowser.Global;
import asandatabasebrowser.action.SqlExcludeCommentAction;
import asandatabasebrowser.action.SqlFormatAction;
import asandatabasebrowser.action.SqlUnformatAction;
import blanco.commons.sql.format.BlancoSqlConstants;
import blanco.commons.sql.format.BlancoSqlParser;
import blanco.commons.sql.format.BlancoSqlRule;
import blanco.commons.sql.format.BlancoSqlTokenConstants;
import blanco.commons.sql.format.valueobject.BlancoSqlToken;

public class SqlEditor extends JTextPane {
	static final int TAB_SIZE = 4;
    BlancoSqlParser fParser = new BlancoSqlParser();
    static SimpleAttributeSet PLANE = new SimpleAttributeSet();
    static SimpleAttributeSet KEYWORD = new SimpleAttributeSet();
    static SimpleAttributeSet COMMENT = new SimpleAttributeSet();
    static SimpleAttributeSet VALUE = new SimpleAttributeSet();
    static SimpleAttributeSet NAME = new SimpleAttributeSet();
    static SimpleAttributeSet SQL89 = new SimpleAttributeSet();
    static SimpleAttributeSet SQL92 = new SimpleAttributeSet();
    static SimpleAttributeSet SQL99 = new SimpleAttributeSet();
    static SimpleAttributeSet SQL_FAMOUS = new SimpleAttributeSet();
    static SimpleAttributeSet UNKNOWN = new SimpleAttributeSet();
    
    static {
    	// F͂ BlancoSqlEditorPlugin ɍ킹Ă܂B
        StyleConstants.setForeground(KEYWORD, Color.BLUE);
        StyleConstants.setForeground(COMMENT, new Color(0, 128, 0));	// dark green
        StyleConstants.setForeground(VALUE, Color.RED);
        StyleConstants.setBackground(UNKNOWN, Color.RED);  // wi̐F
        StyleConstants.setForeground(SQL89, new Color(255, 0, 255));
        StyleConstants.setForeground(SQL92, new Color(192, 0, 255));
        StyleConstants.setForeground(SQL99, new Color(96, 0, 255));
        StyleConstants.setForeground(SQL_FAMOUS, new Color(0, 128, 255));
    }
	BlancoSqlRule rule;
	UndoManager undoManager = new UndoManager();
	RedoAction redoAction;
	UndoAction undoAction;
    SqlFormatAction sqlFormatAction;
    SqlCommentAction sqlCommentAction;
    SqlCommentAddAction sqlCommentAddAction;
    SqlCommentDeleteAction sqlCommentDeleteAction;
    SqlUnformatAction sqlUnformatAction;
    SqlExcludeCommentAction sqlExcludeCommentAction;
    
    public SqlEditor(String sql, BlancoSqlRule rule, Font font) {
		super();
		this.rule = rule;
		this.setText(sql);
		this.setFont(font);
		this.selectAll();
		
		// ANV̐ݒ
		ActionMap amap = getActionMap();
		redoAction = new RedoAction();
		undoAction = new UndoAction();
		sqlFormatAction = new SqlFormatAction(rule, SqlEditor.this, false);
		sqlCommentAction = new SqlCommentAction();
		sqlCommentAddAction = new SqlCommentAddAction();
		sqlCommentDeleteAction = new SqlCommentDeleteAction();
		sqlUnformatAction = new SqlUnformatAction(SqlEditor.this);
		sqlExcludeCommentAction = new SqlExcludeCommentAction(SqlEditor.this);
		
		amap.put(undoAction.getClass().getName(), undoAction);
		amap.put(redoAction.getClass().getName(), redoAction);
		amap.put(sqlFormatAction.getClass().getName(), sqlFormatAction);
		amap.put(sqlCommentAction.getClass().getName(), sqlCommentAction);
		amap.put(sqlCommentAddAction.getClass().getName(), sqlCommentAddAction);
		amap.put(sqlCommentDeleteAction.getClass().getName(), sqlCommentDeleteAction);
		amap.put(sqlUnformatAction.getClass().getName(), sqlUnformatAction);
		amap.put(sqlExcludeCommentAction.getClass().getName(), sqlExcludeCommentAction);

		
		InputMap imap = getInputMap();
		imap.put(undoAction.getAcceleratorKey(), undoAction);
		imap.put(redoAction.getAcceleratorKey(), redoAction);
		imap.put(sqlFormatAction.getAcceleratorKey(), sqlFormatAction);
		imap.put(sqlCommentAction.getAcceleratorKey(), sqlCommentAction);
		// ftHg̃ANVɃANZ[^L[AACRo^B
		Action act_cut = amap.get("cut-to-clipboard");
		if (act_cut.getValue(Action.ACCELERATOR_KEY) == null) {
			act_cut.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke('X', Event.CTRL_MASK));	// Ctrl+X
		}
		if (act_cut.getValue(Action.SMALL_ICON) == null) {
			act_cut.putValue(Action.SMALL_ICON, Global.getImageIcon("/resources/eclipse_EditCut.png"));
		}
		Action act_copy = amap.get("copy-to-clipboard");
		if (act_copy.getValue(Action.ACCELERATOR_KEY) == null) {
			act_copy.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke('C', Event.CTRL_MASK));	// Ctrl+C
		}
		if (act_copy.getValue(Action.SMALL_ICON) == null) {
			act_copy.putValue(Action.SMALL_ICON, Global.getImageIcon("/resources/eclipse_EditCopy.png"));
		}
		Action act_paste = amap.get("paste-from-clipboard");
		if (act_paste.getValue(Action.ACCELERATOR_KEY) == null) {
			act_paste.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke('V', Event.CTRL_MASK));	// Ctrl+V
		}
		if (act_paste.getValue(Action.SMALL_ICON) == null) {
			act_paste.putValue(Action.SMALL_ICON, Global.getImageIcon("/resources/eclipse_EditPaste.png"));
		}
		Action act_selall = amap.get("select-all");
		if (act_selall.getValue(Action.ACCELERATOR_KEY) == null) {
			act_selall.putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke('A', Event.CTRL_MASK));	// Ctrl+A
		}
		
		getDocument().addUndoableEditListener(new UndoableListener());

		// |bvAbvj[o^
		SxUtilities.addPopupMenuMouseListener(this);
		this.addMouseListener(new PopupListener());
		
        StyledDocument doc = (StyledDocument) this.getDocument();
        invokeSetHighlight(doc);
        doc.addDocumentListener(new DocListener());
    }
    
	/** \ݒ肷. */
	void setHighlight(StyledDocument doc) {
		// SQLoB
     	String text = "";
		try {
			text = doc.getText(0, doc.getLength());
		} catch (BadLocationException e) {
			e.printStackTrace();
			return;	// tc[ARRɂ͗ȂǁA悤ȂΐFÂȂǂȂB
		}
		// SQL͂A傲ƂɂԂ؂B
		ArrayList tokens = null;
		try {
			tokens = fParser.parse(text);
		} catch (RuntimeException e) {
			//e.printStackTrace();
			return;	// sSSQLƋN肦B
		}
        // UAׂĂ̑
        doc.setCharacterAttributes(0, text.length(), PLANE, true);
        // g[NƂɐFB
        for (int i=0; i<tokens.size(); i++) {
			BlancoSqlToken t = (BlancoSqlToken) tokens.get(i);
			int pos = t.getPos();
			String str = t.getString();
			switch (t.getType()) {
			case BlancoSqlTokenConstants.SPACE:		// 󔒁ATABAsȂ
				break;
			case BlancoSqlTokenConstants.SYMBOL:	// L. " <="̂悤ȂQłP̋LB
				break;
			case BlancoSqlTokenConstants.KEYWORD:	// L[[h. "SELECT", "ORDER"Ȃ.
				str = str.toUpperCase();
                if (Arrays.binarySearch(BlancoSqlConstants.SQL89_RESERVED_WORDS, str) >= 0) {
					doc.setCharacterAttributes(pos, str.length(), SQL89, true);
				} else if (Arrays.binarySearch(BlancoSqlConstants.SQL92_RESERVED_WORDS, str) >= 0) {
					doc.setCharacterAttributes(pos, str.length(), SQL92, true);
				} else if (Arrays.binarySearch(BlancoSqlConstants.SQL99_RESERVED_WORDS, str) >= 0) {
					doc.setCharacterAttributes(pos, str.length(), SQL99, true);
				} else if (Arrays.binarySearch(BlancoSqlConstants.SQL_FAMOUS_WORDS, str) >= 0) {
					doc.setCharacterAttributes(pos, str.length(), SQL_FAMOUS, true);
				} else {
					doc.setCharacterAttributes(pos, str.length(), KEYWORD, true);
					// RRɂ͗Ȃ͂
					System.out.println("keyword="+str);
				}
				break;
			case BlancoSqlTokenConstants.NAME:		// O.e[uA񖼂ȂǁB_uNH[e[VtꍇB
                doc.setCharacterAttributes(pos, str.length(), NAME, true);
				break;
			case BlancoSqlTokenConstants.VALUE:		// l. liAjAȂǁB
                doc.setCharacterAttributes(pos, str.length(), VALUE, true);
				break;
			case BlancoSqlTokenConstants.COMMENT:	// Rg. VOCRgƃ}`CRgB
                doc.setCharacterAttributes(pos, str.length(), COMMENT, true);
				break;
			case BlancoSqlTokenConstants.END:		// SQL̏I.
				break;
			case BlancoSqlTokenConstants.UNKNOWN:	// ͕s\ȃg[N. ʏSQLł͂肦ȂB
                doc.setCharacterAttributes(pos, str.length(), UNKNOWN, true);
				break;
			default:
				assert false: t.getType();	// 肦Ȃ
			}
		}
    }

	void invokeSetHighlight(final StyledDocument doc) {
        // hLgύXɌĂԂƋ̂ŁAɌĂԂ悤ɂB
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                setHighlight(doc);
            }
        });
    }

	private class PopupListener extends SxMouseAdapter {
		public void mousePopup(MouseEvent ev) {
			JPopupMenu popup = new JPopupMenu();
			if (System.getProperty("debug") != null) {
				// TODO:\܂߂Undo/Redo܂ȂB
				popup.add(undoAction);
				popup.add(redoAction);
				popup.addSeparator();
			}
			SxUtilities.addMenuItems(SqlEditor.this, popup);
			popup.addSeparator();
//			popup.add(sqlCommentAction);
			popup.add(sqlCommentAddAction);
			popup.add(sqlCommentDeleteAction);
			popup.addSeparator();
			popup.add(sqlFormatAction);
			popup.addSeparator();
			popup.add(sqlUnformatAction);
			popup.add(sqlExcludeCommentAction);
			if (System.getProperty("debug") != null) {
				popup.addSeparator();
				popup.add(new SqlFormatAction(rule, SqlEditor.this, true));
			}
			popup.show(SqlEditor.this, ev.getX(), ev.getY());
		}
		private JMenuItem createMenuItem(Action action, String text,
				int mnemonic, boolean enable) {
			assert action != null;
			assert text != null;

			JMenuItem menu = new JMenuItem(action);
			menu.setText(text);
			menu.setMnemonic(mnemonic);
			menu.setEnabled(enable);
			KeyStroke ks = (KeyStroke) action.getValue(Action.ACCELERATOR_KEY);
			if (ks != null) {
				menu.setAccelerator(ks);
			}
			return menu;
		}
	}
	
	/** hLgύXꂽƂ̃Xi[. */
    private class DocListener implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
        	System.out.println(getText());
        	System.out.println("insertUpdate(e)"+e);
            invokeSetHighlight((StyledDocument)e.getDocument());
        }
        public void removeUpdate(DocumentEvent e) {
            //System.out.println("removeUpdate(e)"+e);
            invokeSetHighlight((StyledDocument)e.getDocument());
        }
        public void changedUpdate(DocumentEvent e) {
            //System.out.println("changedUpdate(e)"+e);
            // ςƂ́AȂĂ悢B
        }
    }
    class UndoEdit extends AbstractUndoableEdit {
    	String before;
    	String after;
    	UndoEdit(String before, String after) {
    		this.before = before;
    		this.after = after;
    	}
    	public void undo() {
    		setText(before);
     	}
    	public void redo() {
    		setText(after);
    	}
    }
    /** SQLGfB^ŕҏWsꂽƂA̕ύXɑ΂UndoManagerɓo^邩ǂs */
    private class UndoableListener implements UndoableEditListener {
		public void undoableEditHappened(UndoableEditEvent e) {
			System.out.println(e.getEdit().getClass());
			AbstractDocument.DefaultDocumentEvent event = (AbstractDocument.DefaultDocumentEvent) e.getEdit();
			if (event.getType() != DocumentEvent.EventType.CHANGE) {
				undoManager.addEdit(e.getEdit());
				undoAction.updateStatus();
				redoAction.updateStatus();
			}
		}
	}
	private class UndoAction extends SxAction {
		static final String TITLE = "ɖ߂(U)";
		UndoAction() {
			super(TITLE);
    		putValue(MNEMONIC_KEY, new Integer(KeyEvent.VK_U));
    		putValue(SMALL_ICON, Global.undoIcon);
    		putValue(SHORT_DESCRIPTION, "ɖ߂");
    		putValue(LONG_DESCRIPTION, "ɖ߂");
			putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke('Z', Event.CTRL_MASK));
			updateStatus();
		}
		public void actionPerformed(ActionEvent e) {
			undoManager.undo();
			redoAction.updateStatus();
			updateStatus();
		}
		public void updateStatus() {
			boolean canUndo = undoManager.canUndo();
			if (canUndo) {
				setEnabled(true);
				putValue(Action.NAME, undoManager.getUndoPresentationName());
			} else {
				setEnabled(false);
				putValue(Action.NAME, TITLE);
			}
		}
	}
	private class RedoAction extends SxAction {
		final static String TITLE = "蒼(R)";
		RedoAction() {
			super(TITLE);
    		putValue(MNEMONIC_KEY, new Integer(KeyEvent.VK_R));
    		putValue(SMALL_ICON, Global.redoIcon);
    		putValue(SHORT_DESCRIPTION, "蒼");
    		putValue(LONG_DESCRIPTION, "蒼");
			putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke('Y', Event.CTRL_MASK));
			updateStatus();
		}
		public void actionPerformed(ActionEvent e) {
			undoManager.redo();
			undoAction.updateStatus();
			updateStatus();
		}
		public void updateStatus() {
			boolean canRedo = undoManager.canRedo();
			if (canRedo) {
				setEnabled(true);
				putValue(Action.NAME, undoManager.getRedoPresentationName());
			} else {
				setEnabled(false);
				putValue(Action.NAME, TITLE);
			}
		}
	}

    class SqlCommentAction extends SxAction {
    	SqlCommentAction() {
    		super("Rg̐؂ւ(L)");
    		putValue(MNEMONIC_KEY, new Integer('L'));
    		putValue(SMALL_ICON, Global.getImageIcon("/resources/CommentAdd.png"));
    		putValue(SHORT_DESCRIPTION, "Rg̐؂ւ");
    		putValue(LONG_DESCRIPTION, "Rg̐؂ւ");
    		putValue(ACCELERATOR_KEY, KeyStroke.getKeyStroke('-', Event.CTRL_MASK)); // Ctrl+f|f
    	}
    	public void actionPerformed(ActionEvent event) {
    		// Iꂽ͈͂sڂ牽sڂ𒲂ׂB
    		String text = getText();
    		int start = getSelectionStart();
    		int end = getSelectionEnd();
    		int[] slinecol = SxTextUtilities.getLineColumnIndex(text, start);
    		int[] elinecol = SxTextUtilities.getLineColumnIndex(text, end);
    		int sline = slinecol[0];
    		int eline = elinecol[0];
    		if (elinecol[1] == 0 && sline < eline) eline--;
    		System.out.println("sline="+sline+" eline="+eline);
    		// eLXgsƂ̔zɂB
    		String[] lines = SxTextUtilities.splitLine(text);
    		// ׂĂ̍s̐擪Rgn܂Ă邩H
    		boolean allComment = true;
    		for (int i=sline; i<=eline; i++) {
    			if (! lines[i].startsWith("--")) {
    				allComment = false;
    				break;
    			}
    		}
    		// ׂĂ̍sRgn܂Ăꍇ́ARgOB
    		if (allComment) {
        		for (int i=sline; i<=eline; i++) {
        			lines[i] = lines[i].substring(2);
        		}
    		} else {
        		for (int i=sline; i<=eline; i++) {
        			lines[i] = "--" + lines[i];
        		}
        	}
    		// sȂB
    		text = "";
    		for (int i=0; i<lines.length; i++) {
    			text += lines[i];
    		}
    		setText(text);
    	}
    	public void updateStatus() {}
    }
    class SqlCommentAddAction extends SxAction {
    	SqlCommentAddAction() {
    		super("Rg̒ǉ");
    		putValue(SHORT_DESCRIPTION, "Rg̒ǉ");
    		putValue(LONG_DESCRIPTION, "Rg̒ǉ");
    		putValue(SMALL_ICON, Global.getImageIcon("/resources/CommentAdd.png"));
    	}
    	public void actionPerformed(ActionEvent event) {
    		// Iꂽ͈͂sڂ牽sڂ𒲂ׂB
    		String text = getText();
    		int start = getSelectionStart();
    		int end = getSelectionEnd();
    		int[] slinecol = SxTextUtilities.getLineColumnIndex(text, start);
    		int[] elinecol = SxTextUtilities.getLineColumnIndex(text, end);
    		int sline = slinecol[0];
    		int eline = elinecol[0];
    		if (elinecol[1] == 0 && sline < eline) eline--;
    		System.out.println("sline="+sline+" eline="+eline);
    		// eLXgsƂ̔zɂB
    		String[] lines = SxTextUtilities.splitLine(text);
    		// Rgǉ
    		for (int i=sline; i<=eline; i++) {
    			lines[i] = "--" + lines[i];
    		}
    		// sȂB
    		text = "";
    		for (int i=0; i<lines.length; i++) {
    			text += lines[i];
    		}
    		setText(text);
    	}
    	public void updateStatus() {}
    }
    class SqlCommentDeleteAction extends SxAction {
    	SqlCommentDeleteAction() {
    		super("Rg̏");
    		putValue(SHORT_DESCRIPTION, "Rg̏");
    		putValue(LONG_DESCRIPTION, "Rg̏");
    		putValue(SMALL_ICON, Global.getImageIcon("/resources/CommentDelete.png"));
    	}
    	public void actionPerformed(ActionEvent event) {
    		// Iꂽ͈͂sڂ牽sڂ𒲂ׂB
    		String text = getText();
    		int start = getSelectionStart();
    		int end = getSelectionEnd();
    		int[] slinecol = SxTextUtilities.getLineColumnIndex(text, start);
    		int[] elinecol = SxTextUtilities.getLineColumnIndex(text, end);
    		int sline = slinecol[0];
    		int eline = elinecol[0];
    		if (elinecol[1] == 0 && sline < eline) eline--;
    		System.out.println("sline="+sline+" eline="+eline);
    		// eLXgsƂ̔zɂB
    		String[] lines = SxTextUtilities.splitLine(text);
    		// ׂĂ̍sRgn܂Ăꍇ́ARgOB
    		for (int i=sline; i<=eline; i++) {
    			if (lines[i].startsWith("--")) {
    				lines[i] = lines[i].substring(2);
    			}
    		}
    		// sȂB
    		text = "";
    		for (int i=0; i<lines.length; i++) {
    			text += lines[i];
    		}
    		setText(text);
    	}
    	public void updateStatus() {}
    }
    
    public static void main(String[] args) {
    	SwingUtilities.invokeLater(new Runnable() {
            public void run() {
        		// XbLƂtHgɂB
        		System.setProperty("swing.plaf.metal.controlFont", "Dialog-12");
            	JFrame frame = new JFrame("SQL Editor");
            	BlancoSqlRule rule = new BlancoSqlRule();
            	String sql = 
            		"-- Tvł\n"+
            		"UPDATE\n"+
            		"table1\n"+
            		"SET\n"+
            		"col2 = 'ABC'\n"+
            		",col3 = 123\n"+
            		"WHERE\n"+
            		"col1 = 5;\n"+
            		"INSERT INTO table2 values(1,2,3);";
            	Font font = new Font("Monospaced", Font.PLAIN, 12);
            	SqlEditor editor = new SqlEditor(sql, rule, font);
            	editor.setBorder(new EmptyBorder(5, 10, 0, 0));
            	frame.getContentPane().add(new JScrollPane(editor));
            	frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            	frame.setSize(640, 800);
            	frame.setVisible(true);
            }
        });    	
    }
}
