/*
 * 쐬: 2007/11/27
 */
package blanco.commons.sql.format;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

import blanco.commons.sql.format.valueobject.BlancoSqlToken;

/**
 * BlancoSqlFormatter2: SQL`c[. SQL߂ꂽ[ɏ]`܂B
 * 
 * tH[}bg{邽߂ɂ́A͂SQLSQLƂđÓł邱ƂOƂȂ܂B
 * ̂߁ASQLÓłȂ\ꍇɂ́AĂяotry/catchŗOsƂ߂܂B
 * ̃NXSQL`̃[ɂẮALURLQƂB
 * http://homepage2.nifty.com/igat/igapyon/diary/2005/ig050613.html
 * 
 * 2005.08.08 Tosiki Iga: ( ) ɂĂ (*) ̂悤ɂЂ悤ɕύXB <br>
 * 2005.08.03 Tosiki Iga: ߂ꂽOX[悤ɕύX܂B
 * 
 * @author Yoshinori WATANABE (a-san) : original version at 2005.07.04.
 * @author Tosiki Iga : marge into blanc Framework at 2005.07.04
 * @deprecated		
 */
public class BlancoSqlFormatter2 {
    private final BlancoSqlParser fParser = new BlancoSqlParser();

    private BlancoSqlRule fRule = null;

    /** ۃJbR֐̂̂ǂoB */
    private Stack functionBracket = new Stack();

    /**
     * SQL`c[̃CX^X쐬܂B
     * 
     * @param argRule
     *            SQLϊ[B
     */
    public BlancoSqlFormatter2(final BlancoSqlRule argRule) {
        fRule = argRule;
    }

    /**
     * ^ꂽSQL𐮌`܂B
     * 
     * 1.sŏISQĹA`stł悤ɂ܂B
     * 
     * @param argSql
     *            `OSQL
     * @return `SQL
     * @throws BlancoSqlFormatterException
     *             IɔO͑SẴNXɂȂ܂B
     */
    public String format(final String argSql)
            throws BlancoSqlFormatterException {
        functionBracket.clear();
        try {
        	// sŏIĂ邩ǂH
            boolean isSqlEndsWithNewLine = false;
            if (argSql.endsWith("\n")) {
                isSqlEndsWithNewLine = true;
            }

            // SQL傲Ƃɋ؂Ď̃XgɂB
            List list = fParser.parse(argSql);

            // ̃Xg𐮌`ÃXgԂBRRXSC
            list = format(list);

            // ϊʂP̕ɖ߂B
            StringBuffer after = new StringBuffer();
            for (int index = 0; index < list.size(); index++) {
                BlancoSqlToken token = (BlancoSqlToken) list.get(index);
                after.append(token.getString());
            }

        	// ŏSQLsŏIĂ΁AsB
            if (isSqlEndsWithNewLine) {
                after.append("\n");
            }
            
            // `SQLԂB
            return after.toString();

        } catch (Exception ex) {
            final BlancoSqlFormatterException sqlException = new BlancoSqlFormatterException(
                    ex.toString());
            sqlException.initCause(ex);
            throw sqlException;
        }
    }

    /**
     * ̔zAw肳ꂽSQLKɏ]ĕϊ܂B
     * 
     * @param argList
     *            ϊO̎̔zBArrayList <Token>
     * @return ϊ̎̔zBArrayList <Token>
     */
    private List format(final List list0) {

        // TODO:SQL`̃JX^}CYKvȕ́AAȂ̍sɕϊĉB
        // ȂׂVvŖmȐ`[ɂĂB
        // ܂ANgȂ悤ȕsKvȑI͂߂܂傤B
    	
    	// `Ƃ͂Kɏ]ċ󔒂݂̂u邱ƂłB܂󔒂폜BƂœK؂ɒǉB
    	ArrayList list1 = new ArrayList();
    	for (int i=0; i<list0.size(); i++) {
        	BlancoSqlToken token = (BlancoSqlToken) list0.get(i);
        	switch (token.getType()) {
        	case BlancoSqlTokenConstants.SPACE:
        		// 󔒂͏B
        		break;
         	default:
        		// ȊÔƂ
        		list1.add(token);
        	}
    	}
    	
    	// L[[hAіO(e[uAJȂ)啶AɕϊB
    	ArrayList list2 = new ArrayList();
    	for (int i=0; i<list1.size(); i++) {
        	BlancoSqlToken token = (BlancoSqlToken) list1.get(i);
        	switch (token.getType()) {
            case BlancoSqlTokenConstants.KEYWORD:
            	// L[[ĥƂAϊKɂA啶/ɕϊB
                switch (fRule.keyword) {
                case BlancoSqlRule.KEYWORD_NONE:
                	list2.add(token);
                    break;
                case BlancoSqlRule.KEYWORD_UPPER_CASE:
                	token = new BlancoSqlToken(token.getType(), token.getString().toUpperCase());
                	list2.add(token);
                    break;
                case BlancoSqlRule.KEYWORD_LOWER_CASE:
                	token = new BlancoSqlToken(token.getType(), token.getString().toLowerCase());
                	list2.add(token);
                    break;
                default:
                	assert false: fRule.keyword;
                }
                break;
            case BlancoSqlTokenConstants.NAME:
            	// O(e[uAJȂ)̂ƂAϊKɂA啶/ɕϊB
                switch (fRule.name) {
                case BlancoSqlRule.NAME_NONE:
                	list2.add(token);
                    break;
                case BlancoSqlRule.NAME_UPPER_CASE:
                	token = new BlancoSqlToken(token.getType(), token.getString().toUpperCase());
                    list2.add(token);
                    break;
                case BlancoSqlRule.NAME_LOWER_CASE:
                	token = new BlancoSqlToken(token.getType(), token.getString().toLowerCase());
                    list2.add(token);
                    break;
                default:
                	assert false: fRule.name;
                }
            	break;
        	default:
        		// ȊÔƂ
        		list2.add(token);
        	}
    	}


        // Q񂾃L[[h͂P̃L[[hƂ݂ȂB(ex."INSERT INTO", "ORDER BY")
        // ߑ̌̓L[[hQԂƂ͂ȂBÂł́ARi܂lԂ̌j
        // ߂Â邽߁AL[[hQԂƂBAߑł"ORDER_BY"A邢"OrderBy"
        // ̂悤ɁAǐ𑹂ȂƂȂA͂₷@̗pĂB
    	ArrayList list3 = new ArrayList();
        for (int index = 0; index < list2.size() - 2; index++) {
            BlancoSqlToken t0 = (BlancoSqlToken) list2.get(index);
            BlancoSqlToken t1 = (BlancoSqlToken) list2.get(index + 1);
            BlancoSqlToken t2 = (BlancoSqlToken) list2.get(index + 2);

            if (t0.getType() == BlancoSqlTokenConstants.KEYWORD
                    && t1.getType() == BlancoSqlTokenConstants.KEYWORD &&
                (t0.getString().equalsIgnoreCase("ORDER") ||
                	  t0.getString().equalsIgnoreCase("GROUP")) &&
                	  t1.getString().equalsIgnoreCase("BY")) {
                	BlancoSqlToken t = new BlancoSqlToken(
                			BlancoSqlTokenConstants.KEYWORD, 
                			t0.getString() + " " + t1.getString());
                    list3.add(t);
                    index++;
           }
            // OracleΉ begin 2007/10/24 A.Watanabe
			// Oracle̊OZq"(+)"P̉ZqƂB
            else if (t0.getString().equals("(") && t1.getString().equals("+")
					&& t2.getString().equals(")")) {
            	BlancoSqlToken t = new BlancoSqlToken(
            			BlancoSqlTokenConstants.SYMBOL, "(+)");
				list3.add(t);
			}
			// OracleΉ end
            else {
         	   list3.add(t0);
            }
            // ŌȂAt1,t2ǉ
            if (index == list2.size() - 3) {
          	   list3.add(t1);
         	   list3.add(t2);            	
            }
        }



        // Cfg𐮂B
        int indent = 0;
        // ۃJbR̃CfgʒuoB
        Stack bracketIndent = new Stack();
        BlancoSqlToken prev = new BlancoSqlToken(BlancoSqlTokenConstants.SPACE, " ");
        boolean encounterBetween = false;
        for (int index = 0; index < list3.size(); index++) {
        	BlancoSqlToken token = (BlancoSqlToken) list3.get(index);
            // System.out.println("@@@"+i+"@"+t);
            if (token.getType() == BlancoSqlTokenConstants.SYMBOL) {
                // indentP₵A'('̂ƂŉsB
                if (token.getString().equals("(")) {
                    functionBracket.push(
                            fRule.isFunction(prev.getString()) ? 
                                    Boolean.TRUE :
                                    Boolean.FALSE);
                    bracketIndent.push(new Integer(indent));
                    indent++;
                    index += insertReturnAndIndent(list3, index + 1, indent);
                }
                // indentP₵A')'̑OƌŉsB
                else if (token.getString().equals(")")) {
                    indent = ((Integer) bracketIndent.pop()).intValue();
                    // indent--;
                    index += insertReturnAndIndent(list3, index, indent);
                    // i += insertReturnAndIndent(list, i+1, indent);
                    functionBracket.pop();
                }
                // ','̑Oŉs
                else if (token.getString().equals(",")) {
                    index += insertReturnAndIndent(list3, index, indent);
                } else if (token.getString().equals(";")) {
                    // 2007/11/27 A-san ADD begin OɃuN΂B
                	if (prev.getType() == BlancoSqlTokenConstants.SPACE) {
                		list3.remove(index);
                	}
                	// 2007/11/27 A-san ADD end
                    // 2005.07.26 Tosiki Iga Ƃ肠Z~RSQLԂȂ悤ɉ
                    indent = 0;
                    index += insertReturnAndIndent(list3, index, indent);
                }
            } else if (token.getType() == BlancoSqlTokenConstants.KEYWORD) {
                // indentQ₵AL[[ȟŉs
                if (token.getString().equalsIgnoreCase("DELETE")
                        || token.getString().equalsIgnoreCase("SELECT")
                        || token.getString().equalsIgnoreCase("UPDATE")) {
                    indent += 2;
                    index += insertReturnAndIndent(list3, index + 1, indent);
                }
                // indentP₵AL[[ȟŉs
                if (token.getString().equalsIgnoreCase("INSERT")
                        || token.getString().equalsIgnoreCase("INTO")
                        || token.getString().equalsIgnoreCase("CREATE")
                        || token.getString().equalsIgnoreCase("DROP")
                        || token.getString().equalsIgnoreCase("TRUNCATE")
                        || token.getString().equalsIgnoreCase("TABLE")
                        || token.getString().equalsIgnoreCase("CASE")) {
                    indent++;
                    index += insertReturnAndIndent(list3, index + 1, indent);
                }
                // L[[h̑OindentP炵ĉsAL[[ȟindent߂ĉsB
                if (token.getString().equalsIgnoreCase("FROM")
                        || token.getString().equalsIgnoreCase("WHERE")
                        || token.getString().equalsIgnoreCase("SET")
                        || token.getString().equalsIgnoreCase("ORDER BY")
                        || token.getString().equalsIgnoreCase("GROUP BY")
                        || token.getString().equalsIgnoreCase("HAVING")) {
                    index += insertReturnAndIndent(list3, index, indent - 1);
                    index += insertReturnAndIndent(list3, index + 1, indent);
                }
                // L[[h̑OindentP炵ĉsAL[[ȟindent߂ĉsB
                if (token.getString().equalsIgnoreCase("VALUES")) {
                    indent--;
                    index += insertReturnAndIndent(list3, index, indent);
                }
                // L[[h̑OindentP炵ĉs
                if (token.getString().equalsIgnoreCase("END")) {
                    indent--;
                    index += insertReturnAndIndent(list3, index, indent);
                }
                // L[[h̑Oŉs
                if (token.getString().equalsIgnoreCase("OR")
                        //|| token.getString().equalsIgnoreCase("AND")
                        || token.getString().equalsIgnoreCase("THEN")
                        || token.getString().equalsIgnoreCase("ELSE")) {
                    index += insertReturnAndIndent(list3, index, indent);
                }
                // L[[h̑Oŉs
                if (token.getString().equalsIgnoreCase("ON")
                        || token.getString().equalsIgnoreCase("USING")) {
                    index += insertReturnAndIndent(list3, index, indent + 1);
                }
                // L[[h̑OŉsBindentIɂOɂB
                if (token.getString().equalsIgnoreCase("UNION")
                        || token.getString().equalsIgnoreCase("INTERSECT")
                        || token.getString().equalsIgnoreCase("EXCEPT")) {
                    indent -= 2;
                    index += insertReturnAndIndent(list3, index, indent);
                    index += insertReturnAndIndent(list3, index + 1, indent);
                }
                if (token.getString().equalsIgnoreCase("BETWEEN")) {
                    encounterBetween = true;
                }
                if (token.getString().equalsIgnoreCase("AND")) {
                    // BETWEEN ̂ƂAND͉sȂB
                    if (! encounterBetween) {
                        index += insertReturnAndIndent(list3, index, indent);
                    }
                    encounterBetween = false;
                }
            } else if (token.getType() == BlancoSqlTokenConstants.COMMENT) {
                // System.out.println(">>>"+t.s);
                if (token.getString().startsWith("/*")) {
                    // }`CRǧɉsB
                    index += insertReturnAndIndent(list3, index + 1, indent);
                }
            }
            prev = token;
        }

//        // ۃJbRň͂܂ꂽ (ЂƂ̍)ɂĂ͓ʈsB @author tosiki iga
//		for (int index = argList.size() - 1; index >= 4; index--) {
//			if (index >= argList.size()) {
//				continue;
//			}
//
//			BlancoSqlToken t0 = (BlancoSqlToken) argList.get(index);
//			BlancoSqlToken t1 = (BlancoSqlToken) argList.get(index - 1);
//			BlancoSqlToken t2 = (BlancoSqlToken) argList.get(index - 2);
//			BlancoSqlToken t3 = (BlancoSqlToken) argList.get(index - 3);
//			BlancoSqlToken t4 = (BlancoSqlToken) argList.get(index - 4);
//
//			if (t4.getString().equalsIgnoreCase("(")
//					&& t3.getString().trim().equalsIgnoreCase("")
//					&& t1.getString().trim().equalsIgnoreCase("")
//					&& t0.getString().equalsIgnoreCase(")")) {
//				t4.setString(t4.getString() + t2.getString() + t0.getString());
//				argList.remove(index);
//				argList.remove(index - 1);
//				argList.remove(index - 2);
//				argList.remove(index - 3);
//			}
//		}
//
//        // OɃXy[X
//        for (int index = 1; index < argList.size(); index++) {
//            prev = (BlancoSqlToken) argList.get(index - 1);
//            token = (BlancoSqlToken) argList.get(index);
//
//            if (prev.getType() != BlancoSqlTokenConstants.SPACE
//                    && token.getType() != BlancoSqlTokenConstants.SPACE) {
//                // J}̌ɂ̓Xy[XȂ
//                if (prev.getString().equals(",")) {
//                    continue;
//                }
//                // ֐̌ɂ̓Xy[X͓Ȃ
//                if (fRule.isFunction(prev.getString())
//                        && token.getString().equals("(")) {
//                    continue;
//                }
//                // Rǧɂ̓Xy[X͓ȂB
//                if (prev.getType() == BlancoSqlTokenConstants.COMMENT) {
//                	continue;
//                }
//                // Xy[X
//                argList.add(index, new BlancoSqlToken(
//                        BlancoSqlTokenConstants.SPACE, " "));
//            }
//        }

        return list3;
    }

    /**
     * sƃCfg}.
     * 
     * @param argList
     * @param argIndex
     * @param argIndent
     * @return 󔒂}ꍇ͂PA󔒂uꍇ͂OԂB
     */
    private int insertReturnAndIndent(final List argList, final int argIndex,
            final int argIndent) {
        // ֐ł͉s͑}Ȃ
        if (functionBracket.contains(Boolean.TRUE))
            return 0;
        try {
            // }镶쐬B
            String s = "\n";
            // POɃVOCRgȂAs͕svB
            BlancoSqlToken prevToken = (BlancoSqlToken) (argList
                    .get(argIndex - 1));
            if (prevToken.getType() == BlancoSqlTokenConstants.COMMENT
                    && prevToken.getString().startsWith("--")) {
                s = "";
            }
            // CfgB
            for (int index = 0; index < argIndent; index++) {
                s += fRule.indentString;
            }

            // OɂłɃXy[X΁AuB
            BlancoSqlToken token = (BlancoSqlToken) argList.get(argIndex);
            if (token.getType() == BlancoSqlTokenConstants.SPACE) {
                token.setString(s);
                return 0;
            }

            token = (BlancoSqlToken) argList.get(argIndex - 1);
            if (token.getType() == BlancoSqlTokenConstants.SPACE) {
                token.setString(s);
                return 0;
            }
            // OɂȂ΁AVɃXy[XǉB
            argList.add(argIndex, new BlancoSqlToken(
                    BlancoSqlTokenConstants.SPACE, s));
            return 1;
        } catch (IndexOutOfBoundsException e) {
            // e.printStackTrace();
            return 0;
        }
    }

    public static void main(final String[] args) throws Exception {
        // [ݒ肷
        final BlancoSqlRule rule = new BlancoSqlRule();
        rule.keyword = BlancoSqlRule.KEYWORD_UPPER_CASE;
        rule.indentString = "    ";
        String[] mySqlFuncs = {
                // getNumericFunctions
                "ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "BIT_COUNT", "CEILING",
                "COS", "COT", "DEGREES", "EXP", "FLOOR", "LOG", "LOG10", "MAX",
                "MIN", "MOD", "PI", "POW", "POWER", "RADIANS", "RAND", "ROUND",
                "SIN", "SQRT", "TAN", "TRUNCATE",
                // getStringFunctions
                "ASCII", "BIN", "BIT_LENGTH", "CHAR", "CHARACTER_LENGTH",
                "CHAR_LENGTH", "CONCAT", "CONCAT_WS", "CONV", "ELT",
                "EXPORT_SET", "FIELD", "FIND_IN_SET", "HEX,INSERT", "INSTR",
                "LCASE", "LEFT", "LENGTH", "LOAD_FILE", "LOCATE", "LOCATE",
                "LOWER", "LPAD", "LTRIM", "MAKE_SET", "MATCH", "MID", "OCT",
                "OCTET_LENGTH", "ORD", "POSITION", "QUOTE", "REPEAT",
                "REPLACE", "REVERSE", "RIGHT", "RPAD", "RTRIM", "SOUNDEX",
                "SPACE", "STRCMP", "SUBSTRING", "SUBSTRING", "SUBSTRING",
                "SUBSTRING", "SUBSTRING_INDEX", "TRIM", "UCASE", "UPPER",
                // getSystemFunctions
                "DATABASE", "USER", "SYSTEM_USER", "SESSION_USER", "PASSWORD",
                "ENCRYPT", "LAST_INSERT_ID", "VERSION",
                // getTimeDateFunctions
                "DAYOFWEEK", "WEEKDAY", "DAYOFMONTH", "DAYOFYEAR", "MONTH",
                "DAYNAME", "MONTHNAME", "QUARTER", "WEEK", "YEAR", "HOUR",
                "MINUTE", "SECOND", "PERIOD_ADD", "PERIOD_DIFF", "TO_DAYS",
                "FROM_DAYS", "DATE_FORMAT", "TIME_FORMAT", "CURDATE",
                "CURRENT_DATE", "CURTIME", "CURRENT_TIME", "NOW", "SYSDATE",
                "CURRENT_TIMESTAMP", "UNIX_TIMESTAMP", "FROM_UNIXTIME",
                "SEC_TO_TIME", "TIME_TO_SEC"
        };
        rule.setFunctionNames(mySqlFuncs);
        final BlancoSqlFormatter2 formatter = new BlancoSqlFormatter2(rule);

        // eXgfBNg̃t@CꊇŕϊB
        final File[] files = new File("Test").listFiles();
        for (int i = 0; i < files.length; i++) {
            System.out.println("-- " + files[i]);
            // t@CSQLǂݍ.
            final BufferedReader reader = new BufferedReader(new FileReader(
                    files[i]));
            String before = "";
            while (reader.ready()) {
                String line = reader.readLine();
                if (line == null)
                    break;
                before += line + "\n";
            }
            reader.close();

            // `
            System.out.println("[before]\n" + before);
            String after = formatter.format(before);
            System.out.println("[after]\n" + after);
        }
    }
}
