/*
 * blanco Framework
 * Copyright (C) 2004-2006 WATANABE Yoshinori
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.sql.format;

/**
 * BlancoSqlFormatter: SQL`c[. SQL߂ꂽ[ɏ]`܂B
 * 
 * tH[}bg{邽߂ɂ́A͂SQLSQLƂđÓł邱ƂOƂȂ܂B
 * 
 * ̃NXSQL`̃[ɂẮALURLQƂB
 * http://homepage2.nifty.com/igat/igapyon/diary/2005/ig050613.html
 * 
 * ̃NX SQL̕ϊK\܂B
 * 
 * @author WATANABE Yoshinori (a-san) : original version at 2005.07.04.
 * @author IGA Tosiki : marge into blanc Framework at 2005.07.04
 */
public class BlancoSqlRule {
    /** L[[h̕ϊK. */
    int keyword = KEYWORD_UPPER_CASE;

    /** L[[h̕ϊK:Ȃ */
    public static final int KEYWORD_NONE = 0;

    /** L[[h̕ϊK:啶ɂ */
    public static final int KEYWORD_UPPER_CASE = 1;

    /** L[[h̕ϊK:ɂ */
    public static final int KEYWORD_LOWER_CASE = 2;

    /** O(e[uAJȂ)̕ϊK. */
    int name = NAME_NONE;
    
    /** O(e[uAJȂ)̕ϊKFȂ@*/
    public static final int NAME_NONE = 0; 

    /** O(e[uAJȂ)̕ϊK:啶ɂ */
    public static final int NAME_UPPER_CASE = 1;

    /** O(e[uAJȂ)̕ϊK:ɂ */
    public static final int NAME_LOWER_CASE = 2;

    /**
     * Cfg̕. ݒ͎R͂ƂBʏ " ", "    ", "\t" ̂ꂩB
     */
    String indentString = "    ";

	/**
	 * ֐̖OB
	 */
	private String[] fFunctionNames = null;

	/**
	 * L[[h̕ϊKݒ肵܂B
	 * @param	keyword	KEYWORD_NONE,KEYWORD_UPPER_CASE,KEYWORD_LOWER_CASÊꂩ
	 */
	public void setKeywordCase(int keyword) {
		this.keyword = keyword;
	}
	
	/**
	 * O(e[uAJȂ)̕ϊKݒ肵܂B
	 * @param name	NAME_NONE,NAME_UPPER_CASE,NAME_LOWER_CASE ̂ꂩ
	 */
	public void setNameCase(int name) {
		this.name = name;
	}
	
	/**
	 * ֐̖OH
	 * @param	name	ׂ閼O
	 * @return	֐̖ÔƂA<code>true</code> ԂB
	 */
	boolean isFunction(String name) {
		if (fFunctionNames == null) return false;
		for (int i=0; i<fFunctionNames.length; i++) {
			if (fFunctionNames[i].equalsIgnoreCase(name)) return true;
		}
		return false;
	}

	/**
	 * ֐̖O̔zo^܂B
	 * @param	names	֐̔zBnullB
	 */
	public void setFunctionNames(String[] names) {
		fFunctionNames = names;
	}

    // TODO JX^}CŸBJX^}CYKvȏꍇɂ́AȉɋKǉĂB
}
