/*
 * 쐬: 2007/05/29
 */
package net.sourceforge.swingx;
import java.awt.*;
import java.util.*;


/**
 * 呺j񂪍CAEg}l[W
 * 
 * 
 */
public class RatioLayout implements LayoutManager2 {
	private ArrayList ratios = new ArrayList();
	private int axis;
	private Container target;
	public static final int X_AXIS = 0;
	public static final int Y_AXIS = 1;
	public RatioLayout(Container target, int axis) {
		assert axis == X_AXIS || axis == Y_AXIS: axis;
		this.axis = axis;
		this.target = target;
	}
	public void addLayoutComponent(Component comp, Object ratio) {
		ratios.add(ratio);
	}
	public void addLayoutComponent(String name, Component comp) {
		assert false;
	}
	public void layoutContainer(Container target) {
		assert this.target == target: target;
		int nChildren = target.getComponentCount();
		int[] xOffsets = new int[nChildren];
		int[] xSpans = new int[nChildren];
		int[] yOffsets = new int[nChildren];
		int[] ySpans = new int[nChildren];
		Dimension alloc = target.getSize();
		Insets in = target.getInsets();
		alloc.width  -= (in.left + in.right);
		alloc.height -= (in.top + in.bottom);
		int offset = 0;
		int ratio;
		for (int i=0; i<nChildren; i++) {
			if(axis == X_AXIS) {
				yOffsets[i] = in.top;
				ySpans[i] = alloc.height;
				xOffsets[i] = alloc.width * offset / 100;
				Integer xRatio = (Integer) ratios.get(i);
				ratio = xRatio.intValue();
				xSpans[i] = alloc.width * ratio / 100;
				offset += ratio;
			} else {
				xOffsets[i] = in.left;
				xSpans[i] = alloc.width;
				yOffsets[i] = alloc.height * offset / 100;
				Integer yRatio = (Integer) ratios.get(i);
				ratio = yRatio.intValue();
				ySpans[i] = alloc.height * ratio / 100;
				offset += ratio;
			}
		}
		for (int i=0; i<nChildren; i++) {
			Component c = target.getComponent(i);
			c.setBounds(in.left + xOffsets[i], in.top + yOffsets[i],
					xSpans[i], ySpans[i]);
//			System.out.println(" "+c.getBounds());
		}
	}
	public float getLayoutAlignmentX(Container target) { return 0.5f; }
	public float getLayoutAlignmentY(Container target) { return 0.5f; }
	public void invalidateLayout(Container target) {}
	public void removeLayoutComponent(Component comp) {}
	public Dimension maximumLayoutSize(Container target) {
//		return target.getMaximumSize();
		Dimension dim = new Dimension();
		for (int i=0; i<target.getComponentCount(); i++) {
			Component c = target.getComponent(i);
			Dimension d = c.getMaximumSize();
			if (axis == X_AXIS) {
				if (d.width == Integer.MAX_VALUE || dim.width == Integer.MAX_VALUE)
					dim.width = Integer.MAX_VALUE;
				else
					dim.width += d.width;
				dim.height = Math.max(dim.height, d.height);
			} else {
				if (d.height == Integer.MAX_VALUE || dim.height == Integer.MAX_VALUE)
					dim.height = Integer.MAX_VALUE;
				else
					dim.height += d.height;
				dim.width = Math.max(dim.width, d.width);
			}
		}
//		System.out.println(dim);
		return dim;
	}
	public Dimension preferredLayoutSize(Container target) {
//		return target.getPreferredSize();
		Dimension dim = new Dimension();
		for (int i=0; i<target.getComponentCount(); i++) {
			Component c = target.getComponent(i);
			Dimension d = c.getPreferredSize();
			if (axis == X_AXIS) {
				dim.width += d.width;
				dim.height = Math.max(dim.height, d.height);
			} else {
				dim.height += d.height;
				dim.width = Math.max(dim.width, d.width);
			}
		}
//		System.out.println(dim);
		return dim;
	}
	public Dimension minimumLayoutSize(Container target) {
//		return target.getMinimumSize();
		Dimension dim = new Dimension();
		for (int i=0; i<target.getComponentCount(); i++) {
			Component c = target.getComponent(i);
			Dimension d = c.getMinimumSize();
			if (axis == X_AXIS) {
				dim.width += d.width;
				dim.height = Math.max(dim.height, d.height);
			} else {
				dim.height += d.height;
				dim.width = Math.max(dim.width, d.width);
			}
		}
//		System.out.println(dim);
		return dim;
	}
}
