/*
 * 쐬: 2007/06/03
 */
package net.sourceforge.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ScrollPaneConstants;


/**
 * bZ[W{bNX.
 * eLXg̃bZ[WƁAException΁AExceptioñX^bNƃ[X\_CAOB
 * 
 */
public class SxMessageBox extends JPanel {
	/** bZ[WRsy\ɂ邽߁AJTextAreaŕ\B*/
	JTextArea messageArea;
	/** O΁A\GA쐬B */
	JTextArea area;
	
	
	SxMessageBox(String message, Throwable th) {
		
		this.setLayout(new BorderLayout(20, 20));
		messageArea = new JTextArea();
		messageArea.setEditable(false);
		messageArea.setOpaque(false);
		messageArea.setText(message);
		SxUtilities.addPopupMenuMouseListener(messageArea);
		add(messageArea, BorderLayout.NORTH);

		if (th != null) {
			// X^bNg[X擾
			th.printStackTrace();
			StringWriter sw = new StringWriter();
			th.printStackTrace(new PrintWriter(sw));
			String st = sw.toString();
			
			area = new JTextArea();
			area.setColumns(80);
			area.setRows(10);
			area.setEditable(false);
			area.setText(st);
			area.setCaretPosition(0);
			SxUtilities.addPopupMenuMouseListener(area);
			JScrollPane sp = new JScrollPane(area,
					ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
					ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
			sp.setPreferredSize(new Dimension(640, 180));
			add(sp, BorderLayout.CENTER);
		}
	}
	/**
	 * bZ[W{bNX\B 
	 * @param parent
	 * @param message
	 * @param th
	 * @param optionType
	 * @param messageType JOptionPane.ERROR_MESSAGE JOptionPane.INFORMATION_MESSAGE JOptionPane.WARNING_MESSAGE JOptionPane.QUESTION_MESSAGE JOptionPane.PLAIN_MESSAGE 
	 */
	public static int show(Component parent, String title, String message, Throwable th, 
				int optionType, int messageType) {
		SxMessageBox box = new SxMessageBox(message, th);
		int rc = SxOptionPane.showMessageDialog(parent, box, title, optionType, messageType, null);
		return rc;
	}
	/**
	 * bZ[W{bNX\B 
	 * @param parent
	 * @param message
	 * @param th
	 * @param messageType JOptionPane.ERROR_MESSAGE JOptionPane.INFORMATION_MESSAGE JOptionPane.WARNING_MESSAGE JOptionPane.QUESTION_MESSAGE JOptionPane.PLAIN_MESSAGE 
	 */
	public static int show(Component parent, String title, String message, Throwable th, int messageType) {
		SxMessageBox box = new SxMessageBox(message, th);
		return SxOptionPane.showMessageDialog(parent, box, title, SxOptionPane.OK_ONLY_OPTION, messageType, null);
	}
	public static int show(Component parent, String title, String message, Throwable th) {
		return show(parent, title, message, th, SxOptionPane.PLAIN_MESSAGE);
	}
	public static int show(Component parent, String title, String message) {
		return show(parent, title, message, null);
	}
}

