/*
 * 쐬: 2007/06/18
 */
package net.sourceforge.swingx;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

/**
 * vOXE_CAO.
 *  
 */
public class SxProgressDialog extends JDialog {
	
	Thread thread;
	final String title;
	final JProgressBar progress;
	final JLabel label = new JLabel("message");
	final JButton button;
	private boolean isAbort = false;
	private boolean isInquire = true;
	/**
	 * 
	 * @param owner
	 * @param title
	 * @param thread	null̂Ƃɂ́Af{^\ȂB
	 * @param min
	 * @param max
	 */
	public SxProgressDialog(Frame owner, String title, Thread thread, int min, int max) {
		super(owner, title, true);
		assert owner != null;
		assert title != null;
		assert thread != null;
		assert min < max: "min="+min+" max="+max;
		this.thread = thread;
		this.title = title;
		progress = new JProgressBar(JProgressBar.HORIZONTAL, min, max);
		button = new JButton(new AboutAction());
		if (thread == null) button.setVisible(false);
		label.setHorizontalAlignment(JLabel.CENTER);
		JPanel panel = new JPanel(new BorderLayout());
		panel.add(progress, BorderLayout.SOUTH);
		panel.add(label, BorderLayout.CENTER);
		JPanel button_panel = new JPanel();
		button_panel.add(button);
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(panel, BorderLayout.CENTER);
		getContentPane().add(button_panel, BorderLayout.SOUTH);
		((JPanel) getContentPane()).setBorder(new EmptyBorder(10, 10, 10, 10));
		getRootPane().setDefaultButton(button);
		setSize(320, 240);
		setLocationRelativeTo(owner);
	}
	
	public SxProgressDialog(Frame owner, String title, Thread thread) {
		this(owner, title, thread, 0, 100);
	}
	/** f{^ꂽƂA₢킹邩HƂɒf邩H */
	public void setInquire(boolean isInquire) {
		this.isInquire = isInquire;
	}
	
	// TODO:͕KvH
	public void start() {
		assert thread != null;
		thread.start();
		setVisible(true);
	}

	/**
	 * ̃\bhSwing̃CxgfBXpb`XbhƂ͕ʂ̃XbhĂ΂邱Ƃz肵Ă܂B
	 * CxgfBXpb`XbhĂł\܂B
	 */
	public void setProgress(final int pos, final String message) {
		assert message != null;
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				progress.setValue(pos);
				label.setText(message);
			}
		});
	}
	/** 
	 * f{^ꂽԂB
	 * ₢킹sƂɂ́AꂪmF܂ł́AfalseԂB
	 */
	public boolean isAbort() { return isAbort; }
	
	
	/** f{^ꂽƂ̃ANV. */
	private class AboutAction extends AbstractAction {
		AboutAction() {
			super("f");
		}
		public void actionPerformed(ActionEvent event) {
			// ₢킹邩HƂɒf邩H
			if (isInquire) {
				int rc = JOptionPane.showConfirmDialog(SxProgressDialog.this, 
		            "f܂H",
		            title, JOptionPane.YES_NO_OPTION);
				if (rc != JOptionPane.YES_OPTION) return;
			}
			// fv
			isAbort = true;
			dispose();
		}
	}
	/** eXgp̃_CAO. */
	private static class TestProgressDialog {
		JFrame frame = new JFrame("SxProgressDialog̃eXg");
		SxProgressDialog dialog;
		TestAction start = new TestAction();
		void test() {
			JMenuBar menubar = new JMenuBar();
			JMenu test = new JMenu("eXg");
			test.add(new JMenuItem(start));
			menubar.add(test);
			frame.setJMenuBar(menubar);
			frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
			frame.setSize(640, 480);
			frame.setVisible(true);
		}
		class TestAction extends AbstractAction {
			TestAction() {
				super("eXg");
			}
			public void actionPerformed(ActionEvent e) {
				thread = new Thread() {
						public void run() {
							for (int i=0; i<100; i++) {
								if (dialog.isAbort()) break;
								try { Thread.sleep(100); } catch (InterruptedException e) {}
								dialog.setProgress(i, "message="+i);
								System.out.println("message="+i);
							}
							dialog.dispose();
							System.out.println("dispose");
						}
					};
				dialog = new SxProgressDialog(frame, "SxProgressDialog", thread);
				dialog.start();
			}
		};
		Thread thread;
	}
	public static void main(String[] args) {
		new TestProgressDialog().test();
	}
}
