/*
 * 쐬: 2007/06/03
 */
package net.sourceforge.swingx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class SxResource {
	   /**
	 * \[XURL擾.
	 * @param name	"/resources/xxx.png"Ȃ
	 * @return URL
	 */
	public static URL getUrl(String name) {
        return SxUtilities.class.getResource(name);
	}
	public static Cursor getAutoResizeCursor(String resourcename, String cursorname, int x, int y) throws IOException {
		BufferedImage bi = ImageIO.read(SxResource.getUrl(resourcename));
		Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(
				bi, new Point(x, y), cursorname);
		return cursor;
	}
	public static Cursor getCursor(String resourcename, String cursorname, int x, int y) throws IOException {
		BufferedImage image = ImageIO.read(SxResource.getUrl(resourcename));
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dim = toolkit.getBestCursorSize(image.getWidth(), image.getHeight());
        if (dim.width != image.getWidth() || dim.height != image.getHeight()) {
              BufferedImage newimage = new BufferedImage(dim.width, dim.height, BufferedImage.TYPE_4BYTE_ABGR);
              Graphics2D g2 = (Graphics2D) newimage.getGraphics();
              g2.drawImage(image, 0, 0, new Color(255,0,0,0), null);
              image = newimage;
        }
		Cursor cursor = toolkit.createCustomCursor(image, new Point(x, y), cursorname);
		return cursor;
	}
	/**
	 * \[XACR擾.
	 * @param name	"/resources/xxx.png"Ȃ
	 * @return ACR
	 */
	public static ImageIcon getImageIcon(String name) {
        java.net.URL url = SxUtilities.class.getResource(name);
        return new ImageIcon(url);
	}
}
