package net.sourceforge.swingx.jspread;


import java.awt.BorderLayout;
import java.awt.Event;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

import net.sourceforge.swingx.Logger;
import net.sourceforge.swingx.jspread.JSpreadSheet.CurrentFocus;


/**
 * XvbhNXłB
 * 
 * 
 * @author Asan
 */
public class JSpread extends JPanel implements JSpreadConstant {
	static Logger logger = Logger.getLogger(JSpread.class);

	/** ݂̃V[g. */
	JSpreadSheet sheet;
	
	JSpreadProperty properties = new JSpreadProperty();
	/** ArrayList<JSpreadSelectionListener>[0..*] vfnulls */
	private ArrayList selectionListeners = null;

	// <<controller>>
	JSpreadControllerHeaderData headerDataController = new JSpreadControllerHeaderData(this);
	JSpreadControllerBuilder viewController= new JSpreadControllerBuilder(this);
	JSpreadControllerHeader headerController = new JSpreadControllerHeader(this);
	JSpreadControllerCellRenderer rendererController = new JSpreadControllerCellRenderer(this);
	JSpreadControllerCellEditor editorController = new JSpreadControllerCellEditor(this);


	//---------------------------------------------------------------------
	// RXgN^֌W
	//---------------------------------------------------------------------
	
	/**
	 * Xvbh쐬܂.
	 * 256*256̃V[g쐬܂B
	 */
	public JSpread() {
		this(256, 256);
	}
	/**
	 * w肳ꂽ*s̃Xvbh쐬܂.
	 * @param	numRows		(c)̐BOȏB
	 * @param	numCols		s()̐BOȏB
	 */
	public JSpread(int numRows, int numCols) {
		assert numRows >= 0: numRows;
		assert numCols >= 0: numCols;
		sheet = new JSpreadSheet(this, "Sheet", numRows, numCols);

		// ANVo^ TODO:̂
		ActionMap actionmap = getActionMap();
		Action selectAllAction = new JSpreadActions.SelectAllAction(this);
		Action copyClipboardAction = new JSpreadActions.CopyClipboardAction(this);
		actionmap.put("SelectAllAction", selectAllAction);
		actionmap.put("CopyClipboardAction", copyClipboardAction);
		InputMap inputmap = getInputMap(WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
		inputmap.put(KeyStroke.getKeyStroke('A', Event.CTRL_MASK), "SelectAllAction");
		inputmap.put(KeyStroke.getKeyStroke('C', Event.CTRL_MASK), "CopyClipboardAction");
//      enableEvents(AWTEvent.KEY_EVENT_MASK);
//      setFocusable(true);		
//		setEnabled(true);

		// JTablẽ\[XRs[@begin
        setOpaque(true);
		//setSurrendersFocusOnKeystroke(false);
        //setPreferredScrollableViewportSize(new Dimension(450, 400));
        // I'm registered to do tool tips so we can draw tips for the renderers
//        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
//        toolTipManager.registerComponent(this);
        setAutoscrolls(true);
        // TODO:ToolTipManagerɑ΂Qs͕KvƎv邪AsetAutoScrolls(true)͕Kvǂs
		// JTablẽ\[XRs[@end

	}

	//---------------------------------------------------------------------
	// f[^֌W
	//---------------------------------------------------------------------
	public JSpreadSheet getSheet() {
		return sheet;
	}
	
	/**
	 * rowAcolumn ɈʒuZ̒l擾܂.
	 * @param	rowDataIndex	̃f[^ԍ(dataIndex)(0..*)
	 * @param	colDataIndex	s̃f[^ԍ(dataIndex)(0..*)
	 * @return	l(null)
	 */
	public Object getValueAt(int rowDataIndex, int colDataIndex) {
		//logger.debug("getValueAt()"+sheet+" rowDataIndex="+rowDataIndex+" colDataIndex="+colDataIndex);
		assert 0 <= rowDataIndex: rowDataIndex;
		assert 0 <= colDataIndex: colDataIndex;
		Object obj = sheet.getValueAt(rowDataIndex, colDataIndex);
		//logger.debug("getValueAt() exit obj="+obj);
		return obj;
	}
	
	/**
	 * rowAcolumn ɈʒuZ̒lݒ肵܂.
	 * @param	value	lBnull
	 * @param	rowDataIndex	̃f[^ԍ(dataIndex)(0..*)
	 * @param	colDataIndex	s̃f[^ԍ(dataIndex)(0..*)
	 */
	public void setValueAt(Object value, int rowDataIndex, int colDataIndex) {
		//logger.debug("setValue() value="+value+" rowDataIndex="+rowDataIndex+" colDataIndex="+colDataIndex);
		assert 0 <= rowDataIndex: rowDataIndex;
		assert 0 <= colDataIndex: colDataIndex;
		sheet.setValueAt(value, rowDataIndex, colDataIndex);
		//logger.debug("exit");
	}

	/**
	 * wb_̒l擾܂.
	 * ftHgł<code> null </code>ݒ肳Ă܂B
	 * @param	orientation	wb_̎. ROW/COLUMN/CORNER
	 * @param	dataIndex	f[^ԍ(dataIndex)(0..*).CORNEȐꍇ͖B
	 * @return	l(null)
	 */
	public Object getHeaderValueAt(int header, int dataIndex) {
		logger.debug("enter");
		assert header != ROW || header != COLUMN: header;
		assert 0 <= dataIndex: dataIndex;
		Object obj = sheet.getHeaderValueAt(header, dataIndex);
		logger.debug("exit");
		return obj;
	}
	/**
	 * wb_̒lݒ肵܂.
	 * <code> null </code>̏ꍇ́As̏ꍇ"A","B",...,"Z","AA","AB",...̒lA
	 * ̏ꍇ"1","2","3",...\܂B
	 * @param	value	lBnull
	 * @param	header		wb_̎. ROW/COLUMN
	 * @param	dataIndex	f[^ԍ(dataIndex)(0..*)
	 */
	public void setHeaderValueAt(Object value, int header, int dataIndex) {
		logger.debug("enter");
		assert header != ROW || header != COLUMN: header;
		assert 0 <= dataIndex: dataIndex;
		logger.debug("setHeaderValueAt() value="+value+" header="+header+" dataIndex="+dataIndex);
		sheet.setHeaderValueAt(value, header, dataIndex);
		logger.debug("exit");
	}
	/**
	 * ̃R[i[̒l擾܂B
	 * @return	l(null)
	 */
	public Object getCornerValue() {
		return sheet.getCornerValue();
	}
	/**
	 * ̃R[i[̒lݒ肵܂.
	 * @param	value	lBnull
	 */
	public void setCornerValue(Object value) {
		logger.debug("setCornerValue() value="+value);
		sheet.setCornerValue(value);
		logger.debug("exit");
	}
	/**
	 * wb_̏c̐Ԃ܂B
	 * @param orientation	wb_̎. ROW/COLUMN
	 * @return	f[^̐(DataIndex)
	 */
	public int getCellCount(int orientation) {
		logger.debug("enter");
		assert orientation == JSpread.ROW || orientation == JSpread.COLUMN: orientation;
		int count = sheet.getCellCount(orientation);
		logger.debug("exit");
		return count;
	}
	/**
	 * Z̃TCYݒ肵܂B
	 * ʏ́Ar[̐؂ւȂǁAO傫؂ւꍇɎgp܂B
	 * ̃\bh͂Ȃׂ̏c悤ɓw͂܂A
	 * ̃f[^\ԂȂǂ͖ɂȂ܂B
	 * TCYςȂꍇ͉s܂B
	 * @param rowCount	̐B0ȏ
	 * @param colCount	s̐B0ȏ
	 * @param initValue	l(null)
	 */
	public void setCellCount(int rowCount, int colCount, Object initValue) {
		logger.debug("enter");
		assert rowCount >= 0: rowCount;
		assert colCount >= 0: colCount;
		sheet.setCellCount(rowCount, colCount, initValue);
		// TODO:TCYς̂ǁAǂĐݒ肷΂悢HeJScrollPaneƂB
		//setPreferredSize(new Dimension(sheet.colHeader.getTotalWidth(), sheet.rowHeader.getTotalWidth()));
		revalidate();
		// IĂZ̈ʒuςB
		CurrentFocus prev = sheet.getCurrentFocus();
		sheet.focusCol = Math.min(sheet.focusCol, colCount-1);
		sheet.focusRow = Math.min(sheet.focusRow, rowCount-1);
		sheet.curCol = Math.min(sheet.curCol, colCount-1);
		sheet.curRow = Math.min(sheet.curRow, rowCount-1);
		CurrentFocus next = sheet.getCurrentFocus();
		if (! prev.equals(next)) {
			fireSelectionListener(new JSpreadSelectionEvent(this, prev, next));
		}
		logger.debug("exit");
	}

	/**
	 * w肳ꂽꏊɗ/s}܂BdataIndex-1w肷Ɩɒǉ܂B
	 * @param value			Z̒lBnull
	 * @param header		wb_̎. ROW/COLUMN
	 * @param dataIndex		}ꏊB-1̏ꍇAɒǉ܂B
	 * @param count			}s/̐. 1ȏ
	 * @param headerValue	wb_̒lBnull
	 */
	public void insertValueAt(Object value, int header, int dataIndex, int count, Object headerValue) {
		assert header != ROW || header != COLUMN: header;
		assert 0 <= dataIndex || dataIndex == -1: dataIndex;
		assert 1 <= count: count;
		logger.debug("insertValueAt() value="+value+" header="+header+" dataIndex="+dataIndex+
				" count="+count+" headerValue="+headerValue);
		sheet.insertValueAt(value, header, dataIndex, count, headerValue);
	}
	//---------------------------------------------------------------------
	// wb_֌W
	//---------------------------------------------------------------------
	/**
	 * w肳ꂽꏊɗ/s}܂BdataIndex-1w肷Ɩɒǉ܂B
	 * @param value			Z̒lBnull
	 * @param header		wb_̎. ROW/COLUMN
	 * @param dataIndex		}ꏊB-1̏ꍇAɒǉ܂B
	 * @param count			}s/̐. 1ȏ
	 * @param headerValue	wb_̒lBnull
	 */
	public JSpreadHeader getHeader(int header) {
		assert header != ROW || header != COLUMN: header;
		return header == ROW ? sheet.rowHeader : sheet.colHeader;
	}
	
	//---------------------------------------------------------------------
	// r[֌W
	//---------------------------------------------------------------------
	/**
	 * Xvbh̃r[쐬܂B
	 * ̖߂lJPanelȂǂɒǉĂB
	 * @return	SwingR|[lg
	 */
	public JComponent createView() {
		viewController.createView(this);
		//getComponent(CELL_PANE_NAME).grabFocus();
		return this;
	}
	/**
	 * XN[o[t̃r[쐬܂.
	 * @param vsbPolicy	XN[o[̕\|V[łB
	 * 		JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
	 * 		JScrollPane.VERTICAL_SCROLLBAR_NEVER,
	 * 		JScrollPane.VERTICAL_SCROLLBAR_ALWAYS ̂ꂩw肵܂B
	 * @param hsbPolicy	XN[o[̕\|V[łB
	 * 		JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED,
	 * 		JScrollPane.HORIZONTAL_SCROLLBAR_NEVER,
	 * 		JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS ̂ꂩw肵܂B
	 * @return	XN[o[t̃r[.
	 */
	public JPanel createScrollView(int vsbPolicy, int hsbPolicy) {
		logger.debug("enter");
		assert 
			vsbPolicy == JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED ||
			vsbPolicy == JScrollPane.VERTICAL_SCROLLBAR_NEVER ||
			vsbPolicy == JScrollPane.VERTICAL_SCROLLBAR_ALWAYS: vsbPolicy;
		assert
			hsbPolicy == JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED ||
			hsbPolicy == JScrollPane.HORIZONTAL_SCROLLBAR_NEVER ||
			hsbPolicy == JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS: hsbPolicy;
		viewController.createScrollView(this, vsbPolicy, hsbPolicy);
		//getComponent(CELL_PANE_NAME).grabFocus();
		logger.debug("exit");
		return this;
	}
	/** convinienceȃ\bh. */
	public JPanel createScrollView() {
		return createScrollView(
				JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED,
				JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
	}
	/**
	 * w肳ꂽOR|[lgԂ܂.
	 * @param name
	 * @return
	 */
	public JComponent getComponent(String name) {
		assert name != null;
		JComponent comp = JSpreadUtilities.getComponent(this, name);
		assert comp != null: name;
		return comp;
	}
		
	//---------------------------------------------------------------------
	// wb_֌W
	//---------------------------------------------------------------------
	/**
	 * \ʒu1\ʒu2܂ł̍sor\ɂ܂.
	 * \ʒu1 > \ʒu2 Ŏw肵Ă\܂B 
	 * @param	rowOrColumn	s(JSpread.ROW or JSpread.COLUMN)
	 * @param	viewpos1	\ʒu1(0..)(viewIndex)
	 * @param	viewpos2	\ʒu2(0..)(viewIndex)
	 */
	public void hideHeader(int rowOrColumn, int viewpos1, int viewpos2) {
		assert rowOrColumn == ROW || rowOrColumn == COLUMN: rowOrColumn;
		assert 0 <= viewpos1: viewpos1;
		assert 0 <= viewpos2: viewpos2;
		headerController.hideHeader(rowOrColumn, viewpos1, viewpos2);
	}
	/**
	 * ׂĂ̍sor\AԂɖ߂܂. 
	 * @param	rowOrColumn	s(JSpread.ROW or JSpread.COLUMN)
	 */
	public void showHeaderAll(int rowOrColumn) {
		assert rowOrColumn == ROW || rowOrColumn == COLUMN || rowOrColumn == BOTH: rowOrColumn;
		headerController.showHeaderAll(rowOrColumn);
	}
	
	public int getViewPositionAtPoint(int rowOrColumn, int xy) {
		assert rowOrColumn == ROW || rowOrColumn == COLUMN: rowOrColumn;
		return (rowOrColumn == ROW) ?
					sheet.rowHeader.getViewPositionAtPoint(xy):
					sheet.colHeader.getViewPositionAtPoint(xy);
	}
	
	//---------------------------------------------------------------------
	// CAEg֌W
	//---------------------------------------------------------------------
//	public void doLayout() {
//		logger.debug("enter");
//		new JSpreadControllerResize().doLayout(this);
//		logger.debug("exit");
//	}

	// ---------------------------------------------------------------------
	// ZE_[֌W
	// ---------------------------------------------------------------------
	/**
	 * Z`悷̂ɎgpR|[lgԂ܂.
	 * @param value				Z̒l(null)
	 * @param rowDataIndex		\ԍ(dataIndex)(0..)
	 * @param columnDataIndex	s\ԍ(dataIndex)(0..)
	 * @return Z`悷̂ɎgpR|[lg(null)
	 */ 
	public JSpreadCellRenderer getCellRenderer(Object value, 
			int rowDataIndex, int columnDataIndex) {
		assert 0 <= rowDataIndex: rowDataIndex;
		assert 0 <= columnDataIndex: columnDataIndex;
		return rendererController.getCellRenderer(value, 
				rowDataIndex, columnDataIndex);
	}
	/**
	 * wb_`悷̂ɎgpR|[lgԂ܂.
	 * @param value			Z̒l(null)
	 * @param header		wb_̎. ROW/COLUMN/CORNER
	 * @param ataIndex		s\ԍ(dataIndex)(0..)
	 * @return Z`悷̂ɎgpR|[lg(null)
	 */ 
    public JSpreadCellRenderer getHeaderRenderer(Object value,
    		int header, int dataIndex) {
		assert header == ROW || header == COLUMN || header == CORNER: header;
		assert 0 <= dataIndex: dataIndex;
		return rendererController.getHeaderRenderer(value, header, dataIndex);
    }
	//---------------------------------------------------------------------
	// ZEGfB^֌W
	//---------------------------------------------------------------------

	/**
	 * w肳ꂽZҏW\ǂ擾܂.
	 * ftHg<code> false </code>łB
	 * @param	rowDataIndex	f[^ԍ(dataIndex)(0..)
	 * @param	colDataIndex	sf[^ԍ(dataIndex)(0..)
	 * @return	trueFҏW / false:ҏWs 
	 */
	public boolean isCellEditable(int rowDataIndex, int colDataIndex) {
		assert 0 <= rowDataIndex: rowDataIndex;
		assert 0 <= colDataIndex: colDataIndex;
		return editorController.isCellEditable(rowDataIndex, colDataIndex);
	}
	/**
	 * w肵Z̕ҏWJn܂B
	 * @param	rowViewIndex	\ԍ(viewIndex)(0..)
	 * @param	colViewIndex	s\ԍ(viewIndex)(0..)
	 * @param event	CxgBҏWJn邩ǂ̔fɎgBnull̂ƂACxg̃`FbN͍sȂB
	 * @return	true:ҏWJn / false:ҏWJnȂ
	 */
	public boolean editCellAt(int rowViewIndex, int colViewIndex, EventObject event) {
		logger.debug("editCellAt() enter");
		boolean rc = editorController.editCellAt(rowViewIndex, colViewIndex, event);
		logger.debug("editCellAt() exit rc="+rc);
		return rc;
	}
	
	/**
	 * Z̕ҏWsR|[lgԂ܂.
	 * isCellEditable()falseԂꍇ́AĂ΂܂B
	 * @param	value	f[^̒l(null)
	 * @param	rowDataIndex	f[^ԍ(dataIndex)(0..)
	 * @param	colDataIndex	sf[^ԍ(dataIndex)(0..)
	 * @return	ZEGfB^(null)
	 */
	public JSpreadCellEditor getCellEditor(Object value, 
			int rowDataIndex, int colDataIndex) {
		return editorController.getCellEditor(value, rowDataIndex, colDataIndex);
	}	
	/**
	 * Z̕ҏWI܂.
	 * ߂ltruȅꍇ́AҏW̒l̓ZɊi[܂B
	 * ҏWꂽlsȏꍇȂǁAҏWIȂꍇfalseԂ܂B
	 * @return	true:ҏWI / false:IłȂ
	 */
	public boolean stopCellEditing() {
		return editorController.stopCellEditing();
	}
	/**
	 * Z̕ҏWLZ܂.
	 * ҏW̒l̓Zɂ͊i[܂B
	 */
	public void cancelCellEditing() {
		editorController.cancelCellEditing();
	}
	/**
	 * ҏWǂԂ܂.
	 * @return	true:ҏW / false:ҏWłȂ
	 */
	public boolean isEditing() {
		return editorController.isEditing();
	}
	/**
	 * ҏW̏ꍇAZGfB^̃R|[lgԂ܂B
	 * ҏWłȂꍇAnullԂ܂B
	 * @return	ZGfB^̃R|[lg.null
	 */
	public JComponent getEditorComponent() {
		return editorController.getEditorComponent();
	}
	//---------------------------------------------------------------------
	// vpeB֌W
	//---------------------------------------------------------------------
	public static void putClassProperty(String key, Object value) {
		JSpreadProperty.classProperties.put(key, value);
	}
	public void putObjectProperty(String key, Object value) {
		properties.objectProperties.put(key, value);
	}
	//---------------------------------------------------------------------
	// Z̃tH[JẌʒu֌W 
	//---------------------------------------------------------------------
	public int getFocusColumn() { return sheet.focusCol; }
	public void setFocusColumn(int column) { sheet.focusCol = column; }
	public int getFocusRow() 	{ return sheet.focusRow; }
	public void setFocusRow(int row) { sheet.focusRow = row; }
	public int getCurrentColumn() 	{ return sheet.curCol; }
	public void setCurrentColumn(int column) { sheet.curCol = column; } 
	public int getCurrentRow()		{ return sheet.curRow; }
	public void setCurrentRow(int row) { sheet.curRow = row; } 
	
	/**
	 * A܂͍s̕\ĂZ̐Ԃ܂B
	 * As͔\ɏôŁAۂ̃f[^̃TCYƕ\ĂTCY͈قȂ邱Ƃ܂B
	 * @param header	ROWA܂COLUMN
	 * @return	\Ăs܂͗̐Ԃ܂B
	 */
	public int getViewCount(int header) {
		assert header == COLUMN || header == ROW: header;
		return header == COLUMN ? sheet.colHeader.getViewCount() : sheet.rowHeader.getViewCount();
	}
	/**
	 * wb_̃̕TCY@w肵܂B
	 * @param header	COLUMN,ROW,BOTĤꂩw肵܂B
	 * @param mode		AUTO_RESIZE_OFF,AUTO_RESIZE_NEXT_COLUMN,
	 * AUTO_RESIZE_LAST_COLUMN ̂ꂩw肵܂B
	 */ 			
	public void setAutoResizeMode(int header, int mode) {
		assert header == COLUMN || header == ROW || header == BOTH: header; 
		assert  mode == AUTO_RESIZE_OFF ||
				mode == AUTO_RESIZE_NEXT_COLUMN ||
				mode == AUTO_RESIZE_LAST_COLUMN:
				mode;
		if ((header & COLUMN) != 0) {
			sheet.colHeader.autoResizeMode = mode;
		}
		if ((header & ROW) != 0) {
			sheet.rowHeader.autoResizeMode = mode;
		}
	}
	/**
	 * wb_\邩ǂ擾܂B
	 * @param header	COLUMN,ROŴꂩw肵܂B
	 * @return	truêƂwb_\܂B
	 */
	public boolean getHeaderVisible(int header) {
		assert header == COLUMN || header == ROW: header;
		return header == COLUMN ? sheet.colHeaderVisible : sheet.rowHeaderVisible;
	}
	/**
	 * wb_\邩ǂw肵܂B
	 * ̃\bhĂłɃr[͕ς܂BĂяoɁArebuildView()ĂŉB
	 * @param header	COLUMN,ROW,BOTĤꂩw肵܂B
	 * @param visible	truêƂwb_\܂B
	 */
	public void setHeaderVisible(int header, boolean visible) {
		assert header == ROW || header == COLUMN || header == BOTH: header;
		if ((header & ROW) != 0) {
			sheet.rowHeaderVisible = visible;
		}
		if ((header & COLUMN) != 0) {
			sheet.colHeaderVisible = visible;
		}
	}
	//---------------------------------------------------------------------
	// Z̑I֌W 
	//---------------------------------------------------------------------
	/**
	 * Z̑IԂݒ肵܂B
	 * @param	rowViewIndex	\ԍ(viewIndex)(0..)
	 * @param	colViewIndex	s\ԍ(viewIndex)(0..)
	 * @param 	sel				I(true/false)	
	 */
	public void setCellSelection(int rowViewIndex, int colViewIndex, boolean sel) {
		assert 0 <= rowViewIndex && rowViewIndex < getViewCount(ROW): rowViewIndex;
		assert 0 <= colViewIndex && colViewIndex < getViewCount(COLUMN): colViewIndex;
		sheet.cellSelection[rowViewIndex][colViewIndex] = sel;
	}
	/**
	 * Z̑IԂ擾܂B
	 * @param	rowViewIndex	\ԍ(viewIndex)(0..)
	 * @param	colViewIndex	s\ԍ(viewIndex)(0..)
	 * @return	I(true/false)
	 */
	public boolean getCellSelection(int rowViewIndex, int colViewIndex) {
		assert 0 <= rowViewIndex && rowViewIndex < getViewCount(ROW): rowViewIndex;
		assert 0 <= colViewIndex && colViewIndex < getViewCount(COLUMN): colViewIndex;
		return sheet.getSelection(rowViewIndex, colViewIndex);
//		return sheet.cellSelection[rowViewIndex][colViewIndex];
	}
	/**
	 * wb_̑IԂ擾܂B
	 * @param	orientation	COLUMN,ROŴꂩw肵܂B
	 * @param	viewIndex	\ԍ(viewIndex)(0..)
	 * @return	I(true/false)
	 */
	public boolean getHeaderSelection(int orientation, int viewIndex) {
		assert orientation == ROW || orientation == COLUMN: orientation;
		assert 0 <= viewIndex && viewIndex < getViewCount(orientation): viewIndex;
		return sheet.getHeaderSelection(orientation, viewIndex);
	}
	/**
	 * w肳ꂽwb_̑Iꂽ\ԍ̔zԂ܂B
	 * IĂȂƂɂ͗vfO̔zԂ܂inull͕Ԃ܂jB
	 * @param	orientation	COLUMN,ROŴꂩw肵܂B
	 * @return	Iꂽ\ԍ̔zB(not null,[viewIndex])
	 */
	public int[] getHeaderSelections(int orientation) {
		assert orientation == ROW || orientation == COLUMN: orientation;
		// IĂwb_̐𐔂B
		int count = 0;
		for (int i=0; i<getViewCount(orientation); i++) {
			if (getHeaderSelection(orientation, i)) count++;
		}
		// IĂwb_̕\indexW߂B
		int[] result = new int[count];
		int j = 0;
		for (int i=0; i<getViewCount(orientation); i++) {
			if (getHeaderSelection(orientation, i)) result[j++] = i;
		}
		return result;
	}
	public void addSelectionListener(JSpreadSelectionListener listener) {
		logger.debug(listener);
		if (selectionListeners == null) {
			selectionListeners = new ArrayList();
		}
		selectionListeners.add(listener);
	}
	void fireSelectionListener(JSpreadSelectionEvent e) {
		assert e != null; 
		if (selectionListeners == null) return;
		for (int i=0; i<selectionListeners.size(); i++) {
			JSpreadSelectionListener listener = (JSpreadSelectionListener) selectionListeners.get(i);
			logger.debug(listener);
			listener.valueChanged(e);
		}
	}
	
	
	
	
	
	
	
	
	// TODO:ĕ`()Oς
	public void ĕ`() {
		logger.debug("enter ĕ`()");
		this.repaint();
		logger.debug("exit");
	}
	// TODO:Ĕzu()Oς
	public void Ĕzu() {
		logger.debug("enter Ĕzu()");
		this.revalidate();
		// JScrollPanêƂAȂ̃r[ɍĔzusȂ̂ŁAIɌĂԁB
		if (this.getComponent(0) instanceof JScrollPane) {
			JScrollPane sp = (JScrollPane) this.getComponent(0);
			JComponent c = (JComponent) sp.getViewport().getView();
			c.revalidate();
		}
		ĕ`();
		logger.debug("exit");
	}
	/** r[蒼܂. */
//	public void rebuildView() {
//		logger.debug("enter r[̍蒼()");
//		controller.createView(this);
//		Ĕzu();
//		logger.debug("exit");
//	}
	//---------------------------------------------------------------------
	// c[`bv֌W 
	//---------------------------------------------------------------------
	/**
	 * c[`bvLɂɂ́Ã\bhĂт܂.
	 * setToolTipText(String)͎gpȂłB
	 * @param panename	̖OB"CellPane"Ȃ
	 * @param enabled
	 */
	public void setToolTipEnabled(String panename, boolean enabled) {
		assert panename != null;
		getComponent(panename).setToolTipText(enabled ? "JSpread" : null);
	}
	/**
	 * c[`bvLɂƂ́Ã\bhI[o[ChĂB
	 * @param panename	̖OB"CellPane"Ȃ
	 * @param event		}EXCxg
	@* @return	c[`bṽeLXgB\Ȃꍇ́AnullԂĂBHTML`ɂΉĂ܂B
	 */
	protected String getToolTipText(String panename, MouseEvent event) {
		return null;
	}
	
	
	public boolean inv() {
		return sheet.inv();
	}
	/**
	 * Ȑff̌ʂԂ܂ifobOpj.
	 * JSpread̓Ԃ𕶎ƂĕԂ܂B
	 * @return	JSpread̓
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();
		// ݂̃V[gɊւ
		sb.append("focusCol="+this.getFocusColumn()+
				" focusRow="+this.getFocusRow()+"\n");
		sb.append("curCol="+this.getCurrentColumn()+
				" curRow="+this.getCurrentRow()+"\n");
		// er[̃TCY
		JComponent comp = this.getComponent("CellPane");			
		sb.append("CellPane.bounds="+comp.getBounds()+"\n");
		comp = this.getComponent("RowHeaderPane");			
		sb.append("RowHeaderPane.bounds="+comp.getBounds()+"\n");

		sb.append("inv="+this.inv());
//		sb.append(panel.toString());
		return sb.toString();
	}

	public static void main(String[] args) {
		JSpread spread = new JSpread(10, 10);
		JFrame frame = new JFrame("HelloJSpread");
		spread.setValueAt("Hello", 0, 0);
		spread.setValueAt("JSpread", 0, 1);
		spread.createView();
		spread.doLayout();
		//spread.createScrollView();
		frame.getContentPane().setLayout(new BorderLayout());
		frame.getContentPane().add(spread, BorderLayout.CENTER);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(480, 200);
		frame.setVisible(true);
	}	
}

