/*
 * 쐬: 2006/03/15
 */
package net.sourceforge.swingx.jspread;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

import net.sourceforge.swingx.Logger;


public class JSpread2x2Panel extends JPanel {
	static Logger logger = Logger.getLogger(JSpread2x2Panel.class);
	final JComponent[][] pane;	// [2..2][2..2]vfnulls
	final int fixRow;	// 0,1
	final int fixCol;	// 0,1

	JSpread2x2Panel(int fixRow, int fixCol) {
		assert fixRow == 0 || fixRow == 1: fixRow;
		assert fixCol == 0 || fixCol == 1: fixCol;
		this.fixRow = fixRow;
		this.fixCol = fixCol;
		this.pane = new JComponent[2][2];
		// eyCnullsȂ̂ŁA_~[̃R|[lgݒ肵ĂB
		Dimension dim = new Dimension(1, 1);
		this.pane[0][0] = new Box.Filler(dim, dim, dim);
		this.pane[0][1] = new Box.Filler(dim, dim, dim);
		this.pane[1][0] = new Box.Filler(dim, dim, dim);
		this.pane[1][1] = new Box.Filler(dim, dim, dim);
		setLayout(new JFixSplitInsideLayoutManager());
	}

	public void setPane(int row, int col, JComponent comp) {
		assert 0 <= row && row < 2: row;
		assert 0 <= col && col < 2: col;
		assert comp != null: comp;
		if (pane[row][col] != null) remove(pane[row][col]);
		pane[row][col] = comp;
		add(comp);
	}

	class JFixSplitInsideLayoutManager implements LayoutManager {

	    /** w肳ꂽReizu܂B */
		public void layoutContainer(Container target) {
			synchronized (target.getTreeLock()) {
				logger.debug("target="+target.getSize());
				// ꉞCZbgΉĂ̂Ń{[_[gB
				Insets insets = target.getInsets();
				int x0 = insets.left;
				int y0 = insets.top;
				int x9 = target.getWidth() - insets.right;
				int y9 = target.getHeight() - insets.bottom;
				int w = Math.max(
						pane[0][fixCol].getPreferredSize().width, 
						pane[1][fixCol].getPreferredSize().width);
				int h = Math.max(
						pane[fixRow][0].getPreferredSize().height, 
						pane[fixRow][1].getPreferredSize().height);
				int x5 = (fixCol == 0) ? (x0 + w) : (x9 - w);
				int y5 = (fixRow == 0) ? (y0 + h) : (y9 - h);
				pane[0][0].setBounds(x0, y0, x5-x0, y5-y0);
				pane[0][1].setBounds(x5, y0, x9-x5, y5-y0);
				pane[1][0].setBounds(x0, y5, x5-x0, y9-y5);
				pane[1][1].setBounds(x5, y5, x9-x5, y9-y5);
			}
		}

		/** w肳ꂽRei̍ŏTCY̐@vZ܂B */
		public Dimension minimumLayoutSize(Container parent) {
			// X̃yC̍ŏTCYZ
			Dimension d00 = pane[0][0].getMinimumSize();
			Dimension d01 = pane[0][1].getMinimumSize();
			Dimension d10 = pane[1][0].getMinimumSize();
			Dimension d11 = pane[1][1].getMinimumSize();
			return new Dimension(
					Math.max(d00.width, d10.width) + Math.max(d01.width, d11.width),
					Math.max(d00.height, d01.height) + Math.max(d10.height, d11.height));
		}
	    /** w肳ꂽRei̐TCY̐@vZ܂B */
		public Dimension preferredLayoutSize(Container parent) {
			// X̃yC̐TCYZ
			Dimension d00 = pane[0][0].getPreferredSize();
			Dimension d01 = pane[0][1].getPreferredSize();
			Dimension d10 = pane[1][0].getPreferredSize();
			Dimension d11 = pane[1][1].getPreferredSize();
			return new Dimension(
					Math.max(d00.width, d10.width) + Math.max(d01.width, d11.width),
					Math.max(d00.height, d01.height) + Math.max(d10.height, d11.height));
		}
	    /** CAEg}l[WR|[lgƂ̕gpꍇACAEgɃR|[lg comp ǉAname ɂĎw肳ꂽɊ֘At܂B */
		public void addLayoutComponent(String name, Component comp){}
		/** w肳ꂽR|[lgCAEg폜܂B */	
		public void removeLayoutComponent(Component comp) {}
	}
	public String toString() {
		return "JSpread2x2Panel[\n"
			+"pane[0][0]="+JSpreadUtilities.toString(pane[0][0].getBounds())+"\n"
			+"pane[0][1]="+JSpreadUtilities.toString(pane[0][1].getBounds())+"\n"
			+"pane[1][0]="+JSpreadUtilities.toString(pane[1][0].getBounds())+"\n"
			+"pane[1][1]="+JSpreadUtilities.toString(pane[1][1].getBounds())+"\n"
			+"]\n";
	}
}

