/*
 * 쐬: 2007/10/21
 */
package net.sourceforge.swingx.jspread;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;


public class JSpreadActions {
	
	static class SelectAllAction extends AbstractAction {
		private final JSpread spread;
		public SelectAllAction(JSpread spread) {
			super("ׂĂI(A)");
			putValue(MNEMONIC_KEY, new Integer('A'));
			putValue(SHORT_DESCRIPTION, "ׂĂI");
			putValue(LONG_DESCRIPTION, "ׂĂI");
			this.spread = spread;
		}
		public void actionPerformed(ActionEvent ev) {
			System.out.println("JSpreadActions.SelectAllAction");
			spread.sheet.setSelectionAll(true);
			spread.repaint();
		}
	}
	
	/**
	 * Iꂽ͈͂̃Z̒l^u؂̕ƂăNbv{[hɃRs[.
	 * TODO:JavãlCeBuȃIuWFNg̃Rs[邱ƁB 
	 */
	static class CopyClipboardAction extends AbstractAction {
		private final JSpread spread;
		public CopyClipboardAction(JSpread spread) {
			super("Rs[(C)");
			putValue(MNEMONIC_KEY, new Integer('C'));
			putValue(SHORT_DESCRIPTION, "Iꂽ͈͂TAB؂ŃRs[܂");
			putValue(LONG_DESCRIPTION, "Iꂽ͈͂TAB؂ŃRs[܂");
			putValue(SMALL_ICON, spread.properties.getImageIcon(JSpread.COPY_ICON));
			this.spread = spread;
		}
		public void actionPerformed(ActionEvent ev) {
			System.out.println("JSpreadActions.CopyClipboardAction");
			// IĂ͈͂߂B
			int minRow = Integer.MAX_VALUE;
			int minCol = Integer.MAX_VALUE;
			int maxRow = Integer.MIN_VALUE;
			int maxCol = Integer.MIN_VALUE;
			JSpreadHeader rowHeader = spread.getHeader(JSpread.ROW);
			JSpreadHeader colHeader = spread.getHeader(JSpread.COLUMN);
			for (int r=0; r<rowHeader.getViewCount(); r++) {
				for (int c=0; c<colHeader.getViewCount(); c++) {
					if (spread.getCellSelection(r, c)) {
						minRow = Math.min(minRow, r);
						minCol = Math.min(minCol, c);
						maxRow = Math.max(maxRow, r);
						maxCol = Math.max(maxCol, c);
					}
				}
			}
			// Iꂽ͈͂̒őIꂽZ̒l^u؂
			StringBuffer sb = new StringBuffer();
			for (int r=minRow; r<=maxRow; r++) {
				for (int c=minCol; c<=maxCol; c++) {
					if (spread.getCellSelection(r, c)) {
						int cc = colHeader.getDataIndex(c);
						int rr = rowHeader.getDataIndex(r);
						Object val = spread.getValueAt(rr, cc);
						if (val != null) sb.append(val);
					}
					sb.append("\t");
				}
				sb.append("\n");
			}
			// Nbv{[hɃRs[
			StringSelection ss = new StringSelection(sb.toString());
			Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss,ss);
		}
		
	}	

}
