/*
 * 쐬: 2006/04/30
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
//import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

import net.sourceforge.swingx.Logger;



/**
 * Z̕ҏWs߂ɕKvȃC^[tF[XłB
 * ftHgł͈ȉ̃NXɑ΂āAȉ̃ZEGfB^܂BZ̒lYNX̏ꍇ́A
 * ɑΉGfB^gp܂B
 * AZ̒ljava.lang.DoublȅꍇAȉ̊YNXjava.lang.Numberjava.lang.Object
 * QɂȂ܂Ałp̋߂java.lang.Number̃ZEGfB^AȂ킿JSpreadCellEditor.NumberEditor
 * gp܂Bf[^̌^null̏ꍇ́Ajava.lang.ObjectJSpreadCellEditor.DefaultCellEditor
 * g܂B
 * <table border="1">
 * <tr><th>f[^̌^</ht><th>JSpreadCellEditor</th></tr>
 * <tr><td>java.lang.Object</td><td>JSpreadCellEditor.DefaultCellEditor</td></tr>
 * <tr><td>java.lang.Number</td><td>JSpreadCellEditor.NumberEditor</td></tr>
 * <tr><td>java.lang.Boolean</td><td>JSpreadCellEditor.BooleanEditor</td></tr>
 * <tr><td>java.util.Date</td><td>JSpreadCellEditor.DateEditor</td></tr>
 * <tr><td>-</td><td>JSpreadCellEditor.CheckBoxEditor</td></tr>
 * <tr><td>-</td><td>JSpreadCellEditor.ComboBoxEditor</td></tr>
 * <tr><td>-</td><td>JSpreadCellEditor.ButtonEditor</td></tr>
 * <tr><td>-</td><td>JSpreadCellEditor.ButtonedCellEditor</td></tr>
 * </table>
 * datanCt"-"̃ZGfB^̓ftHgł͉̌^Ɋ蓖ĂĂ킯ł͂܂B
 * p҂Ǝ̃ZEGfB^ۂɁA{Iȋ@\񋟂܂B
 * @author Asan
 */
public interface JSpreadCellEditor {
	
	/**
	 * Xvbhݒ肵܂B
	 * ZҏWOɌĂ΂܂B
	 * @param	spread	nulls
	 */
	void setSpread(JSpread spread);
	
    /**
     * GfB^R|[lgւ̎QƂԂ܂B
     * @return	Z̕ҏWsR|[lg(nulls)
     */ 
	JComponent getCellEditorComponent();
	
	/**
	 * GfB^ɕێꂽlԂ܂.
	 * @return	GfB^̒lBnull
	 */ 
	Object getCellValue();
	
	/**
	 * GfB^ŕҏWlݒ肵܂.
	 * @param	value	null
	 */
	void setCellValue(Object value);
	
	/**
	 * anEvent gĕҏWn߂邩ǂGfB^ɖ₢킹܂.
	 * @param anEvent	ҏWJn邩ǂ𔻒fCxg
	 * @return	truêƂҏWJn܂.
	 */
	boolean isCellEditable(EventObject anEvent);
     
//    /**
//     * ҏW~ĈꕔҏWς݂̒lGfB^̒lƂĎ󂯕t悤ɁAGfB^ɒʒm܂.
//     */ 
//	boolean stopCellEditing(); 
//    /**
//     * ҏWĈꕔҏWς݂̒l󂯕tȂ悤ɃGfB^ɒʒm܂B
//     */  
//	void cancelCellEditing(); 

	//boolean shouldSelectCell(EventObject anEvent) 
//     ҏWZIꍇ true ԂAłȂꍇ false Ԃ܂B 


	/**
	 * ftHg̃ZGfB^łB
	 * JTextFieldg܂B
	 * ɂ邱ƂłIuWFNgA񂩂IuWFNg𐶐łꍇ
	 * (̈̃RXgN^ꍇ)Ɏg܂B
	 * @author Asan
	 */
	public static class DefaultCellEditor implements JSpreadCellEditor {
		private static final Logger logger = Logger.getLogger(DefaultCellEditor.class);
		protected JSpread spread;
		protected Class[] argTypes = new Class[]{String.class}; 
		protected Constructor constructor; 
		protected Object value; 
		protected JTextField textField;
	    protected int clickCountToStart = 1;
		
	    public DefaultCellEditor() {
			textField = new JTextField();
			clickCountToStart = 2;
		}
		public final void setSpread(JSpread spread) {
			assert spread != null;
			this.spread = spread;
		}
	    public boolean isCellEditable(EventObject anEvent) {
		    if (anEvent instanceof MouseEvent) { 
		    	return ((MouseEvent)anEvent).getClickCount() >= clickCountToStart;
		    }
		    return true;
		}

		public JComponent getCellEditorComponent() {
			return textField;
		}
		public void setCellValue(Object value) {
			textField.setBorder(new LineBorder(Color.black));
			try {
				Class type = (value != null) ? value.getClass() : String.class;
				// Since our obligation is to produce a value which is
				// assignable for the required type it is OK to use the
				// String constructor for columns which are declared
				// to contain Objects. A String is an Object.
				if (type == Object.class) {
					type = String.class;
				}
				constructor = type.getConstructor(argTypes);
			} catch (Exception e) {
			}
			textField.setText(value != null ? "" + value : "");
			textField.selectAll();
		}
		public Object getCellValue() { 
			String s = textField.getText();
		    if ("".equals(s)) { 
				if (constructor.getDeclaringClass() == String.class) { 
				    value = s; 
				}
		    }
		    try { 
		    	value = constructor.newInstance(new Object[]{s}); 
		    } catch (Exception e) { 
				textField.setBorder(new LineBorder(Color.red));
				return value; 
		    }
		    logger.debug("constructor="+constructor+" value.class="+value.getClass());
		    return value; 
		}
		
	}
	/**
	 * ҏWZEGfB^ł.
	 * javax.swing.JTextField El߂ŕҏWs܂B
	 * @author Asan
	 */
	public static class NumberEditor extends DefaultCellEditor {
		public NumberEditor() {
			super();
			textField.setHorizontalAlignment(JTextField.RIGHT);
		}
	}
	/**
	 * ҏWZEGfB^ł.
	 * javax.swing.JTextField ŕҏWs܂B
	 * \E߂tH[}bgw肷邱Ƃł܂B
	 * @author Asan
	 */
	public static class DateEditor extends DefaultCellEditor {
		private static Logger logger = Logger.getLogger(DateEditor.class);
		protected DateFormat formatter = null;
		public DateEditor() {
			super();
		}
		/**
		 * tH[}bgw肵܂B̃\bhĂ΂Ȃ΁AftHg̓tH[}bg
		 * <code> DateFormat.getInstance() </code>gp܂B
		 * @param formatter	tH[}bg(nulls)
		 */
		public void setFormat(DateFormat formatter) {
			assert formatter != null;
			this.formatter = formatter;
		}
		/**
		 * lݒ肵܂.
		 * Cӂ̃IuWFNgAJLabel̃ACRɐݒ肵܂.
		 * @param value	Zɕ\l(null)
		 */
		public void setCellValue(Object value) {
			if (formatter == null) {
				formatter = DateFormat.getDateInstance();
			}
			textField.setText((value == null) ? "" : formatter.format(value));
		}
		public Object getCellValue() { 
			String s = textField.getText();
		    try { 
		    	value = formatter.parse(s); 
		    } catch (ParseException e) {
		    	logger.debug(s, e);
				textField.setBorder(new LineBorder(Color.red));
				return value; 
		    }
		    return value; 
		}
	}	

	/**
	 * javax.swing.JCheckBox ŕҏWZEGfB^ł.
	 * @author Asan
	 */
	public static abstract class CheckBoxEditor implements JSpreadCellEditor, ActionListener {
    	private static Logger logger = Logger.getLogger(CheckBoxEditor.class);
    	JCheckBox checkBox = new JCheckBox();
    	JSpread spread;
        protected int clickCountToStart = 1;
    	public CheckBoxEditor() {
    	    checkBox.setHorizontalAlignment(JCheckBox.CENTER);
    	    checkBox.addActionListener(this);
    	}
    	/**
    	 * Xvbhݒ肵܂B
    	 * @param	spread	nulls
    	 */
    	public final void setSpread(JSpread spread) {
    		assert spread != null;
    		this.spread = spread;
    	}
        public boolean isCellEditable(EventObject anEvent) {
    	    if (anEvent instanceof MouseEvent) { 
    	    	return ((MouseEvent)anEvent).getClickCount() >= clickCountToStart;
    	    }
    	    return true;
    	}
        public JComponent getCellEditorComponent() {
    		return checkBox;
    	}
    	public void setCellValue(Object value) {
           	boolean selected = false; 
    		if (value instanceof Boolean) {
    		    selected = ((Boolean)value).booleanValue();
    		}
    		else if (value instanceof String) {
    		    selected = value.equals("true");
    		}
    		checkBox.setSelected(selected);
    	}
    	public abstract Object getCellValue();
        /**
         * ANVAҏW߂.
         * @param e the action event
         */
         public void actionPerformed(ActionEvent e) {
        	 logger.debug("actionPerformed() "+e);
        	 spread.stopCellEditing();
         }
    }
	/**
	 * BooleanҏWZEGfB^ł.
	 * JCheckBoxŕҏW܂B 
	 * @author Asan
	 */
	public static class BooleanEditor extends CheckBoxEditor {
	   	public Object getCellValue() { 
    		return Boolean.valueOf(checkBox.isSelected());
    	}
 		
	}

	/**
	 * R{{bNXŕҏW\ȃZłB
	 * ZGfB^ƃZ_ƂĎg܂BI͂ł܂AeLXgҏW͂ł܂B
	 * AZ_[ƃZGfB^͕ʂ̃CX^XɂKv܂B
	 * lƎۂɕ\郂m̂Qݒ肷邱Ƃł܂B 
	 * @author Asan
	 */
	public static class ComboBoxEditor implements JSpreadCellRenderer, JSpreadCellEditor, ItemListener {
		private static Logger logger = Logger.getLogger(ComboBoxEditor.class);
		protected JSpread spread;
		protected JComboBox comboBox; 
		protected Object[] keys;
		protected Object[] values;
		protected Map keyValueMap = new HashMap();
		protected Map valueKeyMap = new HashMap();
		
		public ComboBoxEditor(Object[] keys, Object[] values) {
			assert keys != null && keys.length > 0: keys;
			assert values != null && values.length > 0: values;
			assert keys.length == values.length: "keys.length="+keys.length + " values.length="+values.length;
			this.keys = keys;
			this.values = values;
			for (int i=0; i<keys.length; i++) {
				keyValueMap.put(keys[i], values[i]);
				valueKeyMap.put(values[i], keys[i]);
			}
			comboBox = new JComboBox(values);
			comboBox.addItemListener(this);
		}
		public final void setSpread(JSpread spread) {
			assert spread != null;
			this.spread = spread;
		}
		/** Z`悷̂ɎgpR|[lgԂ܂. */ 
		public JComponent getSpreadRendererComponent(JSpread spread, Object value, 
				boolean isSelected, boolean hasFocus, 
				int type, int row, int column) {
			setCellValue(value);
			return comboBox;
		}
	    /**
	     * GfB^R|[lgւ̎QƂԂ܂B
	     */ 
		public JComponent getCellEditorComponent() {
			return comboBox;
		}
		
		/**
		 * GfB^ɕێꂽlԂ܂.
		 * @return	GfB^̒lBnull
		 */ 
		public Object getCellValue() {
			Object value = comboBox.getSelectedItem();
			return valueKeyMap.get(value);
		}
		
		/**
		 * GfB^ŕҏWL[ɑ΂lݒ肵܂.
		 * @param	key	L[w肵܂Bnull
		 */
		public void setCellValue(Object key) {
			comboBox.setSelectedItem(keyValueMap.get(key));
		}
		
		/**
		 * anEvent gĕҏWn߂邩ǂGfB^ɖ₢킹܂.
		 * @param anEvent	ҏWJn邩ǂ𔻒fCxg
		 * @return	truêƂҏWJn܂.
		 */
		public boolean isCellEditable(EventObject anEvent) {
			return true;
		}
		public void itemStateChanged(ItemEvent e) {
			logger.debug("itemStateChanged() e="+e);
			if (spread != null && spread.isEditing() && spread.getEditorComponent() == comboBox) {
				spread.stopCellEditing();
			}
		}
	}

	/**
	 * {^tZEGfB^łBZ_[ƂĂg܂B
	 * AZ_[ƃZGfB^͕ʂ̃CX^XɂKv܂B
	 * `sJComponentJButtonō\Ă܂B
	 * JComponent̓RXgN^Ŏw肵܂B
	 * {^ꂽƂ̏pŎKv܂B
	 * 
	 * @author Asan
	 */
	public static abstract class ButtonedCellEditor extends JPanel implements JSpreadCellRenderer, JSpreadCellEditor, ActionListener {
		private static Logger logger = Logger.getLogger(ButtonedCellEditor.class);
		private static final int BUTTON_WIDTH = 15;
		protected JSpread spread;
		protected JComponent comp;
		protected JButton button;
		protected Object value;
		
		public ButtonedCellEditor(JComponent comp) {
			assert comp != null: comp;
			this.comp = comp;
			button = new JButton("...");
			add(comp);
			add(button);
			setLayout(new ButtonedCellLayout());
			button.addActionListener(this);
		}
		public final void setSpread(JSpread spread) {
			assert spread != null;
			this.spread = spread;
		}
		/** Z`悷̂ɎgpR|[lgԂ܂. */ 
		public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, 
				boolean isSelected, boolean hasFocus, 
				int row, int column) {
			setCellValue(value);
			return this;
		}

	    /**
	     * GfB^R|[lgւ̎QƂԂ܂B
	     */ 
		public JComponent getCellEditorComponent() {
			return this;
		}
		
		/**
		 * GfB^ɕێꂽlԂ܂.
		 * @return	GfB^̒lBnull
		 */ 
		public Object getCellValue() {
			return value;
		}
		
		/**
		 * GfB^ŕҏWlݒ肵܂.
		 * @param	value	null
		 */
		public void setCellValue(Object value) {
			logger.debug("setCellValue() value="+value);
			this.value = value;
		}
		
		/**
		 * anEvent gĕҏWn߂邩ǂGfB^ɖ₢킹܂.
		 * @param anEvent	ҏWJn邩ǂ𔻒fCxg
		 * @return	truêƂҏWJn܂.
		 */
		public boolean isCellEditable(EventObject anEvent) {
			return true;
		}
		/**
		 * {^ꂽƂ̏pŎKv܂.
		 * ҏWƂɂ́Aspread.stopCellEditing()A
		 * LZƂ́Aspread.cancelCellEditing()ĂŉB
		 * @param	event	Cxg(nulls)
		 */
	    public abstract void actionPerformed(ActionEvent event);
//	    {
//	    	JOptionPane.showMessageDialog(this, 
//	    			"ButtonedCellpAactionPerformed(ActionEvent event)ĂB\n"+
//	    			"value="+value);
//			spread.stopCellEditing();
//	    }

		/**
		 * {^tZp̃CAEg}l[W.
		 */
		private class ButtonedCellLayout implements LayoutManager {
			public void addLayoutComponent(String name, Component comp) {
			}
			public void removeLayoutComponent(Component comp) {
			}
			/** w肳ꂽplɃReizu܂B */
			public void layoutContainer(Container parent) {
				synchronized(parent.getTreeLock()) {
					comp.setBounds(0, 0, parent.getWidth() - BUTTON_WIDTH, parent.getHeight());
					button.setBounds(parent.getWidth()-BUTTON_WIDTH, 0, BUTTON_WIDTH, parent.getHeight());
				}
			}
			/** w肳ꂽeReiɃR|[lgzũpl̍ŏTCYvZ܂B */
			public Dimension minimumLayoutSize(Container parent) {
				return parent.getMaximumSize();
			}
			/** w肳ꂽeReiɃR|[lgzũpl̐TCYvZ܂B */
			public Dimension preferredLayoutSize(Container parent) {
				return parent.getPreferredSize();
			}
		}
	}

	/**
	 * {^̃ZEGfB^łBZE_ƂĂgƂł܂B
	 * AZ_[ƃZGfB^͕ʂ̃CX^XɂKv܂B
	 * 
	 * @author Asan
	 */
	public static abstract class ButtonEditor 
			implements JSpreadCellRenderer, JSpreadCellEditor, ActionListener {
		protected JButton button;
		protected JSpread spread;
		protected Object value;
		
		/**
		 * {^̃Z𐶐܂B
		 * Ƀ{^ݒ肵܂B
		 * @param button	{^(nulls)
		 */
		public ButtonEditor(JButton button) {
			assert button != null;
			this.button = button;
			button.addActionListener(this);
		}
		
		/**
		 * Z`悷̂ɎgpR|[lgԂ܂.
		 * @param	spread	Xvbh(nulls)
		 * @param	value	l(null)
		 * @param	isSelected	ZIĂ邩ǂH
		 * @param	hasFocus	ZɃtH[JX邩ǂH
		 * @param	rowDataIndex	f[^ԍ(dataIndex)(0..)
		 * @param	colDataIndex	sf[^ԍ(dataIndex)(0..)
		 * @return	Z`悷̂ɎgpR|[lg(nulls)
		 */ 
		public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, 
				boolean isSelected, boolean hasFocus, 
				int rowDataIndex, int colDataIndex) {
			return button;
		}
		
		/**
		 * Xvbhݒ肵܂B
		 * ZҏWOɌĂ΂܂B
		 * @param	spread	nulls
		 */
		public final void setSpread(JSpread spread) {
			assert spread != null;
			this.spread = spread;
		}

	    /**
	     * GfB^R|[lgւ̎QƂԂ܂B
	     * @return	Z̕ҏWsR|[lg(nulls)
	     */ 
		public JComponent getCellEditorComponent() {
			return button;
		}
		
		/**
		 * GfB^ɕێꂽlԂ܂.
		 * @return	GfB^̒lBnull
		 */ 
		public Object getCellValue() {
			return value;
		}
		
		/**
		 * GfB^ŕҏWlݒ肵܂.
		 * @param	value	null
		 */
		public void setCellValue(Object value) {
			this.value = value;
		}

		/**
		 * anEvent gĕҏWn߂邩ǂGfB^ɖ₢킹܂.
		 * @param anEvent	ҏWJn邩ǂ𔻒fCxg
		 * @return	truêƂҏWJn܂.
		 */
		public boolean isCellEditable(EventObject anEvent) {
			return true;
		}

		/**
		 * {^ꂽƂ̏Lq܂B
		 * ̃NXpK̃\bhI[o[ChĂB
		 * ҏWƂɂ́Aspread.stopCellEditing()A
		 * LZƂ́Aspread.cancelCellEditing()ĂŉB
		 * @param	event	{^ꂽƂ\CxgB(nulls)
		 */
		public abstract void actionPerformed(ActionEvent event);
	}



}
