/*
 * 쐬: 2006/04/30
 */
package net.sourceforge.swingx.jspread;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.text.DateFormat;

import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import net.sourceforge.swingx.SxBevelBorder;


/**
 * ZE_[ɕKvȃ\bh`܂.
 * ɂ̃NX`Ă܂B
 * @author Asan
 */
public interface JSpreadCellRenderer {

	/**
	 * Z`悷̂ɎgpR|[lgԂ܂.
	 * @param	spread	Xvbh(nulls)
	 * @param	value	l(null)
	 * @param	isSelected	ZIĂ邩ǂH
	 * @param	hasFocus	ZɃtH[JX邩ǂH
	 * @param	type		CELL/ROW/COLUMN/CORNER
	 * @param	rowDataIndex	f[^ԍ(dataIndex)(0..)
	 * @param	colDataIndex	sf[^ԍ(dataIndex)(0..)
	 * @return	Z`悷̂ɎgpR|[lg(nulls)
	 */ 
	JComponent getSpreadRendererComponent(JSpread spread, Object value, 
			boolean isSelected, boolean hasFocus, 
			int type, int rowDataIndex, int colDataIndex);

	
	/**
	 * ftHg̃ZE_[ł.
	 * javax.swing.JLabel gĕ`悵܂B
	 * @author Asan
	 */
	public static class DefaultCellRenderer extends JLabel
				implements JSpreadCellRenderer {
	    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
	    protected static Border bevelBorder = new SxBevelBorder(BevelBorder.RAISED);
	    /**
	     * ftHg̃ZE_[쐬܂.
	     */
	    public DefaultCellRenderer() {
			super();
			setOpaque(true);
			setBorder(noFocusBorder);
		}
		/**
		 * Z`悷̂ɎgpR|[lgԂ܂.
		 * @param	spread	Xvbh(nulls)
		 * @param	value	l(null)
		 * @param	isSelected	ZIĂ邩ǂH
		 * @param	hasFocus	ZɃtH[JX邩ǂH
		 * @param	type		CELL/ROW/COLUMN/CORNER
		 * @param	rowDataIndex	f[^ԍ(dataIndex)(0..)
		 * @param	colDataIndex	sf[^ԍ(dataIndex)(0..)
		 * @return	Z`悷̂ɎgpR|[lg(nulls)
		 */ 
		public JComponent getSpreadRendererComponent(JSpread spread, Object value, 
				boolean isSelected, boolean hasFocus, 
				int type, int rowDataIndex, int colDataIndex) {
			switch (type) {
			case JSpread.CELL:
				return getSpreadCellRendererComponent(spread, value, isSelected, hasFocus, rowDataIndex, colDataIndex);
			case JSpread.ROW:
			case JSpread.COLUMN:
			case JSpread.CORNER:
				return getSpreadHeaderRendererComponent(spread, value, 
						isSelected, hasFocus, type, rowDataIndex, colDataIndex);
			}
			return this;
		}
		public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, 
				boolean isSelected, boolean hasFocus, 
				int rowDataIndex, int colDataIndex) {
			if (isSelected) {
				super.setForeground(spread.properties.getColor(JSpread.CELL_SELECT_FOREGROUND_COLOR));
				super.setBackground(spread.properties.getColor(JSpread.CELL_SELECT_BACKGROUND_COLOR));
			} else {
				super.setForeground(spread.properties.getColor(JSpread.CELL_FOREGROUND_COLOR));
				super.setBackground(spread.properties.getColor(JSpread.CELL_BACKGROUND_COLOR));
			}

			setFont(spread.getFont());

			if (hasFocus) {
				setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
				if (!isSelected && spread.isCellEditable(rowDataIndex, colDataIndex)) {
					Color col;
					col = UIManager.getColor("Table.focusCellForeground");
					if (col != null) {
						super.setForeground(col);
					}
					col = UIManager.getColor("Table.focusCellBackground");
					if (col != null) {
						super.setBackground(col);
					}
				}
			} else {
				setBorder(noFocusBorder);
			}
			setHorizontalAlignment(JLabel.LEFT);
			setValue(value);
			return this;
		}

		public JComponent getSpreadHeaderRendererComponent(JSpread spread, Object value, 
				boolean isSelected, boolean hasFocus, 
				int type, int rowDataIndex, int colDataIndex) {
			if (isSelected) {
				super.setForeground(spread.properties.getColor(JSpread.HEADER_SELECT_FOREGROUND_COLOR));
				super.setBackground(spread.properties.getColor(JSpread.HEADER_SELECT_BACKGROUND_COLOR));
			} else {
				super.setForeground(spread.properties.getColor(JSpread.HEADER_FOREGROUND_COLOR));
				super.setBackground(spread.properties.getColor(JSpread.HEADER_BACKGROUND_COLOR));
			}

			setFont(spread.getFont());

			if (hasFocus) {
				setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
				if (!isSelected && spread.isCellEditable(rowDataIndex, colDataIndex)) {
					Color col;
					col = UIManager.getColor("Table.focusCellForeground");
					if (col != null) {
						super.setForeground(col);
					}
					col = UIManager.getColor("Table.focusCellBackground");
					if (col != null) {
						super.setBackground(col);
					}
				}
			} else {
				setBorder(bevelBorder);
			}
			setHorizontalAlignment(JLabel.CENTER);
			setValue(value);
			return this;
			
		}
		/**
		 * lݒ肵܂.
		 * Cӂ̃IuWFNgAjavax.swing.JLabel ̃eLXgɐݒ肵܂.
		 * @param value	Zɕ\l(null)
		 */
		protected void setValue(Object value) {
			setText((value == null) ? "" : value.toString());
		}
	}

    /**
     * java.lang.Number pIuWFNgŎgp郌_[łB
     * Byte, Integer, Long, Short, BigInteger ȂǂŎg܂.
     * JSpreadDefaultCellRendererpAEl߂ŕ\܂B
     * Double, Float, BigDecimal͂̃NXpDoubleRendererg܂B
     * @author Asan 
    */
    public static class NumberRenderer extends DefaultCellRenderer {
		public NumberRenderer() {
			super();
		}
		public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, 
				boolean isSelected, boolean hasFocus, 
				int rowDataIndex, int colDataIndex) {
			JLabel comp = (JLabel) super.getSpreadCellRendererComponent(spread, value, 
					isSelected, hasFocus, 
					rowDataIndex, colDataIndex);
			comp.setHorizontalAlignment(JLabel.RIGHT);
			return comp;
		}
    }

    /**
     * Icon ̃ZE_ł.
     * IconC^[tF[XĂIuWFNgɑ΂Ďgp܂B
     * @author Asan 
     */
    public static class IconRenderer extends DefaultCellRenderer {
		public IconRenderer() {
			super();
		}
		public JComponent getSpreadCellRendererComponent(JSpread spread, Object value, 
				boolean isSelected, boolean hasFocus, 
				int rowDataIndex, int colDataIndex) {
			JLabel comp = (JLabel) super.getSpreadCellRendererComponent(spread, value, 
					isSelected, hasFocus, 
					rowDataIndex, colDataIndex);
			comp.setHorizontalAlignment(JLabel.CENTER);
			return comp;
		}

		/**
		 * lݒ肵܂.
		 * Cӂ̃IuWFNgAJLabel̃ACRɐݒ肵܂.
		 * @param value	Zɕ\l(null)
		 */
		public void setValue(Object value) {
			setIcon((value instanceof Icon) ? (Icon) value : null);
		}
	}
    
    /**
     * Date ̃ZE_ł.
      * @author Asan 
     */
    public static class DateRenderer extends DefaultCellRenderer {
		protected DateFormat formatter = null;

		public DateRenderer() {
			super();
		}
		/**
		 * tH[}bgw肵܂B̃\bhĂ΂Ȃ΁AftHg̓tH[}bg
		 * <code> DateFormat.getInstance() </code>gp܂B
		 * @param formatter	tH[}bg(nulls)
		 */
		public void setFormat(DateFormat formatter) {
			assert formatter != null;
			this.formatter = formatter;
		}
		/**
		 * lݒ肵܂.
		 * Cӂ̃IuWFNgAJLabel̃ACRɐݒ肵܂.
		 * @param value	Zɕ\l(null)
		 */
		public void setValue(Object value) {
			if (formatter == null) {
				formatter = DateFormat.getDateInstance();
			}
			setText((value == null) ? "" : formatter.format(value));
		}
	}
    
    /**
     * Boolean ̃ZE_ł.
     * javax.swing.JCheckBoxgĕ`悵܂.
     * @author Asan
     */
    public static class BooleanRenderer extends JCheckBox implements JSpreadCellRenderer {
		private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

		public BooleanRenderer() {
			super();
			setBorderPainted(true);
		}

		/**
		 * Z`悷̂ɎgpR|[lgԂ܂.
		 * @param	spread	Xvbh(nulls)
		 * @param	value	l(null)
		 * @param	isSelected	ZIĂ邩ǂH
		 * @param	hasFocus	ZɃtH[JX邩ǂH
		 * @param	type		CELL/ROW/COLUMN/CORNER
		 * @param	rowDataIndex	f[^ԍ(dataIndex)(0..)
		 * @param	colDataIndex	sf[^ԍ(dataIndex)(0..)
		 * @return	Z`悷̂ɎgpR|[lg(nulls)
		 */ 
		public JComponent getSpreadRendererComponent(JSpread spread,
				Object value, boolean isSelected, boolean hasFocus,
				int type, int rowDataIndex, int colDataIndex) {
			if (isSelected) {
				setForeground(spread.properties.getColor(JSpread.CELL_SELECT_FOREGROUND_COLOR));
				setBackground(spread.properties.getColor(JSpread.CELL_SELECT_BACKGROUND_COLOR));
			} else {
				setForeground(spread.properties.getColor(JSpread.CELL_FOREGROUND_COLOR));
				setBackground(spread.properties.getColor(JSpread.CELL_BACKGROUND_COLOR));
			}
			setSelected((value != null && ((Boolean) value).booleanValue()));

			if (hasFocus) {
				setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
			} else {
				setBorder(noFocusBorder);
			}
			setHorizontalAlignment(JLabel.CENTER);

			return this;
		}
	}
    
    /**
     * java.awt.Color ̃ZE_ł.
     * javax.swing.JLabel̃ACRɂ̐FAxRGBl\܂B
     * @author Asan
     */
	public static class ColorRenderer extends DefaultCellRenderer {
		/** F̃ACR̕ł. */
		public static final int ICON_WIDTH = 15;
		/** F̃ACR̍ł. */
		public static final int ICON_HEIGHT = 15;
		/**
		 * lݒ肵܂.
		 * Cӂ̃IuWFNgAJLabel̃ACRɐݒ肵܂.
		 * @param value	Zɕ\l(null)
		 */
		public void setValue(Object value) {
			if (value instanceof Color) {
				Color color = (Color) value;
				this.setText(""+color.getRed()+" "+color.getGreen()+" "+color.getBlue());
				System.out.println("Font.size="+getFont().getSize());
				
				this.setIcon(new ColorIcon(color, ICON_WIDTH, getFont().getSize()));
			} else {
				this.setText("");
				this.setIcon(new ColorIcon(null, ICON_WIDTH, getFont().getSize()));
			}
		}
		static class ColorIcon implements Icon {
			protected Color color;
			protected int width, height;
			public ColorIcon(Color color, int w, int h) {
				this.color = color;
				width = w;
				height = h;
			}
			public int getIconWidth() { return width; }
			public int getIconHeight() { return height; }
			public void paintIcon(Component c, Graphics g, int x, int y) {
				if (color != null) {
					g.setColor(color);
					g.fillRect(x, y, width, height);
					g.setColor(Color.BLACK);
					g.drawRect(x, y, width, height);	
				}
				else {	// null̂Ƃɂ́Aĝ
					g.setColor(Color.white);
					g.fillRect(x, y, width, height);
					g.setColor(Color.black);
					g.drawRect(x, y, width, height);
				}
			}
		}
	}	
}
