/*
 * 쐬: 2006/04/02
 */
package net.sourceforge.swingx.jspread;

import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;

import javax.swing.JComponent;

import net.sourceforge.swingx.Logger;

/**
 * Z̕ҏWs܂B
 * y蓮ɂҏWJnz
 * JSpreadCellListener.mouseClicked(MouseEvent e)Ă΂B
 * y蓮ɂҏWIz
 * tH[JXƂB
 * JSpreadCellListener.mousePressed(MouseEvent e)
 * @author Asan
 */
class JSpreadControllerCellEditor {
	static Logger logger = Logger.getLogger(JSpreadControllerCellEditor.class);

	final JSpread spread;
	boolean atEdit = false;
	int editColumn = -1;
	int editRow = -1;
	private JComponent editorParent;
	Rectangle editorRect = null;
	JSpreadCellEditor editor = null;

    private PropertyChangeListener editorRemover = null;
	/** HashMap<Class, JSpreadDefaultCellEditor> */
    transient protected HashMap defaultEditorsByClass = null;
	
    
    
	JSpreadControllerCellEditor(JSpread spread) {
		this.spread = spread;
		// ftHg̃ZEGfB^̓o^
		createDefaultEditors();
	}
	/** ftHg̃ZE_̓o^. */
    protected void createDefaultEditors() {
    	defaultEditorsByClass = new HashMap();
        // Objects
    	defaultEditorsByClass.put(Object.class, new JSpreadCellEditor.DefaultCellEditor());
    	// Numbers
    	defaultEditorsByClass.put(Number.class, new JSpreadCellEditor.NumberEditor());
        // Booleans
    	defaultEditorsByClass.put(Boolean.class, new JSpreadCellEditor.BooleanEditor());
    	// Date
    	defaultEditorsByClass.put(Date.class, new JSpreadCellEditor.DateEditor());
    }
    
	/** Z`悷̂ɎgpR|[lgԂ܂. */ 
    private JSpreadCellEditor getDefaultCellEditorComponent(Object value,
			int row, int column) {
		if (value != null) {
			for (Class cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
				JSpreadCellEditor editor = 
					(JSpreadCellEditor) defaultEditorsByClass.get(cls);
				if (editor != null)
					return editor;
			}
		}
		return (JSpreadCellEditor) defaultEditorsByClass.get(Object.class);
	}
    
	boolean isCellEditable(int rowDataIndex, int colDataIndex) { 
		return false;
	}
	/** Z̃GfB^Ԃ܂BisCellEditable()falseԂꍇ́AĂ΂܂B */
	JSpreadCellEditor getCellEditor(Object value, 
			int rowDataIndex, int colDataIndex) {
		JSpreadCellEditor editor = getDefaultCellEditorComponent(value, rowDataIndex, colDataIndex);
		logger.debug("getCellEditor(row="+rowDataIndex+"col="+colDataIndex+
				") editor="+editor.getClass());
		return editor;
	}	
	/**
	 * w肵Z̕ҏWJn܂B
	 * ҏWΏۂ̃V[g͌ݑIĂV[głB
	 * @param	rowViewIndex	\ԍ(viewIndex)(0..)
	 * @param	colViewIndex	s\ԍ(viewIndex)(0..)
	 * @param event	CxgBҏWJn邩ǂ̔fɎgBnull̂ƂACxg̃`FbN͍sȂB
	 * @return	true:ҏWJn / false:ҏWJnȂ
	 */
	boolean editCellAt(int rowViewIndex, int colViewIndex, EventObject event) {
		logger.debug("editCellAt(row="+rowViewIndex+", column="+colViewIndex+", event="+event+")");

		// łɕҏWŁAҏWIłȂAVȕҏW͍sȂB
		if (editor != null && ! spread.stopCellEditing()) {
            return false;
        }
		
		// ҏWsZ𒲂ׂ
        JSpreadSheet sheet = spread.getSheet();
		assert 0 <= rowViewIndex && rowViewIndex < sheet.rowHeader.getViewCount(): rowViewIndex;
		assert 0 <= colViewIndex && colViewIndex < sheet.colHeader.getViewCount(): colViewIndex;
		int colDataIndex = sheet.colHeader.getDataIndex(colViewIndex);
		int rowDataIndex = sheet.rowHeader.getDataIndex(rowViewIndex);

		// ̃ZҏW\łȂȂΉȂB
		if (! spread.isCellEditable(rowDataIndex, colDataIndex)) {
			return false;
		}
		
		// TODO:tH[JXȂȂҏW߂悤ɁAGfB^폜NX쐬
        if (editorRemover == null) {
            KeyboardFocusManager fm =
                KeyboardFocusManager.getCurrentKeyboardFocusManager();
            editorRemover = new CellEditorRemover(fm);
            fm.addPropertyChangeListener("permanentFocusOwner", editorRemover);
        }
		
		// ҏWO̒l擾
		Object value = spread.getValueAt(rowDataIndex, colDataIndex);

		// Z̕ҏWsR|[lg擾
		JSpreadCellEditor editor = spread.getCellEditor(
				value, rowDataIndex, colDataIndex);
		if (editor == null) {
			return false;
		}
		editor.setSpread(spread);
		editor.setCellValue(value);
		
		// ҏWJñCxgH
		if (! editor.isCellEditable(event)) {
			return false;
		}
       
		// ҏWs`AAsAҏWǂޔ
		this.editor = editor;
		this.editorRect = new Rectangle(
				sheet.colHeader.getPoint(colViewIndex),
				sheet.rowHeader.getPoint(rowViewIndex),
				sheet.colHeader.getWidth(colDataIndex),
				sheet.rowHeader.getWidth(rowDataIndex)
		);
		this.editRow = rowViewIndex;
		this.editColumn = colViewIndex;
		this.atEdit = true;
		
		// ǂ̑ŕҏWsHsĂꍇAtH[JX̂鑋ŕҏWsB
		//logger.debug("source="+event.getSource());
		JSpreadCellPane pane = (JSpreadCellPane) spread.getComponent("CellPane");//spread.getCellPane();
//		FIND_PANE:
//		for (int r=0; r<sheet.rowPaneNum; r++) {
//			for (int c=0; c<sheet.colPaneNum; c++) {
//				JSpreadCellPane p = spread.getCellPane(r, c);
//				logger.debug("pane["+r+"]["+c+"].hasFocus="+p.hasFocus());
//				if (p.hasFocus()) {
//					pane = p;
//					break FIND_PANE;
//				}
//			}
//		}
		
		JComponent comp = editor.getCellEditorComponent();
		pane.add(comp);
		this.editorParent = pane;
		comp.setBounds(this.editorRect);
		comp.validate();
		return true;
	}
	// TODO:ZGfB^܂SłȂB₵B
	boolean stopCellEditing() {
		assert editor != null: "editor";
		logger.debug("stopCellEditing()");
		Object value = editor.getCellValue();
		spread.setValueAt(value, editRow, editColumn);
		removeEditor();
		return true;
	}
	void cancelCellEditing() {
		logger.debug("cancelCellEditing()");
		removeEditor();
	}
	private void removeEditor() {
		logger.debug("removeEditor() editor="+editor+" rect="+editorRect);
		assert editor != null: editor;
		atEdit = false;
		JComponent comp = editor.getCellEditorComponent();
		editorParent.repaint(editorRect.x, editorRect.y, editorRect.width, editorRect.height);
		editorParent.remove(comp);
		editor = null;
		editColumn = -1;
		editRow = -1;
		editorRect = null;
	}
//	Object getCellEditorValue() {
//		return editor.getCellValue();
//	}


	boolean isEditing() {
		return atEdit;
	}
	public JComponent getEditorComponent() {
		return editor != null ? editor.getCellEditorComponent() : null;
	}
	
    class CellEditorRemover implements PropertyChangeListener {
        KeyboardFocusManager focusManager;

        public CellEditorRemover(KeyboardFocusManager fm) {
            this.focusManager = fm;
        }

        public void propertyChange(PropertyChangeEvent ev) {
//        	logger.debug("@@@"+ev.getPropertyName()+
//        			" old="+ev.getOldValue()+
//        			" new="+ev.getNewValue());
        	if ( spread.isEditing() && ev.getPropertyName().equals("permanentFocusOwner") && ev.getOldValue()== editor) {
        		logger.debug("@@@ tH[JXǂɂ̂ŕҏWI");
        		// ҏWIB_ȂLZB
        		if (! spread.stopCellEditing()) {
					spread.cancelCellEditing();
				}
        	}
//            if (!isEditing() || spread.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
//                return;
//            }
//
//            Component c = focusManager.getPermanentFocusOwner();
//            while (c != null) {
//                if (c == spread) {
//                    // focus remains inside the table
//                    return;
//                } else if ((c instanceof Window) ||
//                           (c instanceof Applet && c.getParent() == null)) {
//                    if (c == SwingUtilities.getRoot(spread)) {
//                        if (! spread.stopCellEditing()) {
//                            spread.cancelCellEditing();
//                        }
//                    }
//                    break;
//                }
//                c = c.getParent();
//            }

        }
    }
}
