/*
 * 쐬: 2006/04/02
 */
package net.sourceforge.swingx.jspread;

import java.util.Date;
import java.util.HashMap;

import javax.swing.Icon;
import javax.swing.ImageIcon;

class JSpreadControllerCellRenderer implements JSpreadConstant {
	private JSpread spread;
	/** HashMap<Class, JSpreadCellRenderer> */
    transient protected HashMap defaultRenderersByClass = null;
    
    JSpreadControllerCellRenderer(JSpread spread) {
    	assert spread != null: spread;
    	this.spread = spread;
		// ftHg̃ZE_̓o^
		createDefaultRenderers();
    }
	/** ftHg̃ZE_̓o^. */
    protected void createDefaultRenderers() {
    	defaultRenderersByClass = new HashMap();
        // Objects
    	defaultRenderersByClass.put(Object.class, new JSpreadCellRenderer.DefaultCellRenderer());
    	// Numbers
    	defaultRenderersByClass.put(Number.class, new JSpreadCellRenderer.NumberRenderer());
    	// Dates
    	defaultRenderersByClass.put(Date.class, new JSpreadCellRenderer.DateRenderer());
        // Icons and ImageIcons
    	JSpreadCellRenderer iconRenderer = new JSpreadCellRenderer.IconRenderer();
    	defaultRenderersByClass.put(Icon.class, iconRenderer);
    	defaultRenderersByClass.put(ImageIcon.class, iconRenderer);
        // Booleans
    	defaultRenderersByClass.put(Boolean.class, new JSpreadCellRenderer.BooleanRenderer());
    	// Color
    	defaultRenderersByClass.put(java.awt.Color.class, new JSpreadCellRenderer.ColorRenderer());
    }

	/** Z`悷̂ɎgpR|[lgԂ܂. */ 
    JSpreadCellRenderer getDefaultCellRenderer(Object value,
			int row, int column) {
		if (value != null) {
			for (Class cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
				JSpreadCellRenderer renderer = (JSpreadCellRenderer) defaultRenderersByClass.get(cls);
				if (renderer != null)
					return renderer;
			}
		}
		return (JSpreadCellRenderer) defaultRenderersByClass.get(Object.class);
	}
	/** wb_`悷̂ɎgpR|[lgԂ܂. */ 
    JSpreadCellRenderer getDefaultHeaderRenderer(Object value,
			int header, int dataIndex) {
		if (value != null) {
			for (Class cls = value.getClass(); cls != null; cls = cls.getSuperclass()) {
				JSpreadCellRenderer renderer = (JSpreadCellRenderer) defaultRenderersByClass.get(cls);
				if (renderer != null)
					return renderer;
			}
		}
		return (JSpreadCellRenderer) defaultRenderersByClass.get(Object.class);
	}
	/** Z`悷̂ɎgpR|[lgԂ܂. */ 
	public JSpreadCellRenderer getCellRenderer(Object value,
			int rowDataIndex, int columnDataIndex) {
		JSpreadCellRenderer defaultRenderer = getDefaultCellRenderer(value, 
				rowDataIndex, columnDataIndex);
		return defaultRenderer;
	}
	/**
	 * wb_`悷̂ɎgpR|[lgԂ܂.
	 * @param value			Z̒l(null)
	 * @param header		wb_̎. ROW/COLUMN/CORNER
	 * @param ataIndex		s\ԍ(dataIndex)(0..)
	 * @return Z`悷̂ɎgpR|[lg(null)
	 */ 
    public JSpreadCellRenderer getHeaderRenderer(Object value,
    		int header, int dataIndex) {
		assert header == ROW || header == COLUMN || header == CORNER: header;
		assert 0 <= dataIndex: dataIndex;
		JSpreadCellRenderer defaultRenderer = getDefaultHeaderRenderer(value, 
				header, dataIndex);
		return defaultRenderer;
    }
}
