/*
 * 쐬: 2006/04/08
 */
package net.sourceforge.swingx.jspread;

class JSpreadControllerHeader {
	JSpread spread;
	JSpreadControllerHeader(JSpread spread) {
		this.spread = spread;
	}
	/**
	 * \ʒu1\ʒu2܂ł̍sor\ɂ܂.
	 * \ʒu1 > \ʒu2 Ŏw肵Ă\܂B 
	 * @param	rowOrColumn	s(JSpread.ROW or JSpread.COLUMN)
	 * @param	viewpos1	\ʒu1(0..)(viewIndex)
	 * @param	viewpos2	\ʒu2(0..)(viewIndex)
	 */
	void hideHeader(int rowOrColumn, int viewpos1, int viewpos2) {
		JSpreadSheet sheet = spread.sheet;
		assert rowOrColumn == JSpread.ROW || rowOrColumn == JSpread.COLUMN: rowOrColumn;
		if (rowOrColumn == JSpread.ROW) {
			int viewCount = sheet.rowHeader.getViewCount();
			assert 0 <= viewpos1 && viewpos1 < viewCount;
			assert 0 <= viewpos2 && viewpos2 < viewCount;
			int maxpos = Math.max(viewpos1, viewpos2);
			int minpos = Math.min(viewpos1, viewpos2);
			for (int i=minpos; i<=maxpos; i++) {
				sheet.rowHeader.getInfo(sheet.rowHeader.getDataIndex(i)).viewPosition = -1;
			}
			for (int i=0; i<sheet.rowHeader.getCount(); i++) {
				if (sheet.rowHeader.getInfo(i).viewPosition > maxpos) {
					sheet.rowHeader.getInfo(i).viewPosition -= (maxpos-minpos+1);
				}
			}
			sheet.rowHeader.makeDataIndexList();
			sheet.cellSelection = new boolean[sheet.rowHeader.getViewCount()][sheet.colHeader.getViewCount()];
			sheet.rowSelection = new boolean[sheet.rowHeader.getViewCount()];
//			spread.getRowScrollBar(0).setMaximum(sheet.rowHeader.getViewCount()); 
//			spread.getRowScrollBar(1).setMaximum(sheet.rowHeader.getViewCount()); 
		}
		else {
			int viewCount = sheet.colHeader.getViewCount();
			assert 0 <= viewpos1 && viewpos1 < viewCount;
			assert 0 <= viewpos2 && viewpos2 < viewCount;
			int maxpos = Math.max(viewpos1, viewpos2);
			int minpos = Math.min(viewpos1, viewpos2);
			for (int i=minpos; i<=maxpos; i++) {
				sheet.colHeader.getInfo(sheet.colHeader.getDataIndex(i)).viewPosition = -1;
			}
			for (int i=0; i<sheet.colHeader.getCount(); i++) {
				if (sheet.colHeader.getInfo(i).viewPosition > maxpos) {
					sheet.colHeader.getInfo(i).viewPosition -= (maxpos-minpos+1);
				}
			}
			sheet.colHeader.makeDataIndexList();
			sheet.cellSelection = new boolean[sheet.rowHeader.getViewCount()][sheet.colHeader.getViewCount()];
			sheet.colSelection = new boolean[sheet.colHeader.getViewCount()];
//			spread.getColumnScrollBar(0).setMaximum(sheet.colHeader.getViewCount()); 
//			spread.getColumnScrollBar(1).setMaximum(sheet.colHeader.getViewCount()); 
		}
	}
	/**
	 * ׂĂ̍sor\AԂɖ߂܂. 
	 * @param	rowOrColumn	s(JSpread.ROW or JSpread.COLUMN or JSpread.BOTH)
	 */
	void showHeaderAll(int rowOrColumn) {
		JSpreadSheet sheet = spread.sheet;
		assert rowOrColumn == JSpread.ROW || rowOrColumn == JSpread.COLUMN ||
				rowOrColumn == JSpread.BOTH: rowOrColumn;
		if ((rowOrColumn & JSpread.ROW) != 0) {
			for (int i=0; i<sheet.rowHeader.getCount(); i++) {
				sheet.rowHeader.getInfo(i).viewPosition = i;
			}
			sheet.rowHeader.makeDataIndexList();
			sheet.cellSelection = new boolean[sheet.rowHeader.getViewCount()][sheet.colHeader.getViewCount()];
			sheet.rowSelection = new boolean[sheet.rowHeader.getViewCount()];
//			spread.getRowScrollBar(0).setMaximum(sheet.rowHeader.getViewCount()); 
//			spread.getRowScrollBar(1).setMaximum(sheet.rowHeader.getViewCount()); 
		}
		if ((rowOrColumn & JSpread.COLUMN) != 0) {
			for (int i=0; i<sheet.colHeader.getCount(); i++) {
				sheet.colHeader.getInfo(i).viewPosition = i;
			}
			sheet.colHeader.makeDataIndexList();
			sheet.cellSelection = new boolean[sheet.rowHeader.getViewCount()][sheet.colHeader.getViewCount()];
			sheet.colSelection = new boolean[sheet.colHeader.getViewCount()];
//			spread.getColumnScrollBar(0).setMaximum(sheet.colHeader.getViewCount()); 
//			spread.getColumnScrollBar(1).setMaximum(sheet.colHeader.getViewCount()); 
		}
	}
	/**
	 * wb_̍œKȕ擾܂.
	 * @param	header		wb_̎. ROW/COLUMN
	 * @param	dataIndex	f[^ԍ(dataIndex)(0..*)
	 * @return	l(>0)
	 */
	int getPreferredWidth(int rowOrColumn, int dataIndex) {
		assert rowOrColumn == JSpread.ROW || rowOrColumn == JSpread.COLUMN: rowOrColumn;
		JSpreadHeader header = rowOrColumn == JSpread.ROW ? spread.sheet.rowHeader : spread.sheet.colHeader;
		assert 0 <= dataIndex && dataIndex < header.getCount(): dataIndex; 
		return header.getInfo(dataIndex).preferredWidth;
	}

}
